/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.cloud.OxygenUtil;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.RunUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OxygenClient {
    private final File mClientBinary;
    private IRunUtil mRunUtil = RunUtil.getDefault();
    private static final Set<String> INVOCATION_ATTRIBUTES = new HashSet<String>(Arrays.asList("work_unit_id"));
    public static final Map<String, String> sGceDeviceParamsToOxygenMap = Stream.of({"--branch", "-build_branch"}, {"--build-branch", "-build_branch"}, {"--build_branch", "-build_branch"}, {"--build-target", "-build_target"}, {"--build_target", "-build_target"}, {"--build-id", "-build_id"}, {"--build_id", "-build_id"}, {"--system-build-id", "-system_build_id"}, {"--system_build_id", "-system_build_id"}, {"--system-build-target", "-system_build_target"}, {"--system_build_target", "-system_build_target"}, {"--kernel-build-id", "-kernel_build_id"}, {"--kernel_build_id", "-kernel_build_id"}, {"--kernel-build-target", "-kernel_build_target"}, {"--kernel_build_target", "-kernel_build_target"}, {"--boot-build-id", "-boot_build_id"}, {"--boot_build_id", "-boot_build_id"}, {"--boot-build-target", "-boot_build_target"}, {"--boot_build_target", "-boot_build_target"}, {"--boot-artifact", "-boot_artifact"}, {"--boot_artifact", "-boot_artifact"}, {"--host_package_build_id", "-host_package_build_id"}, {"--host_package_build_target", "-host_package_build_target"}, {"--bootloader-build-id", "-bootloader_build_id"}, {"--bootloader_build_id", "-bootloader_build_id"}, {"--bootloader-build-target", "-bootloader_build_target"}, {"--bootloader_build_target", "-bootloader_build_target"}).collect(Collectors.collectingAndThen(Collectors.toMap(data -> data[0], data -> data[1]), Collections::unmodifiableMap));

    IRunUtil getRunUtil() {
        return this.mRunUtil;
    }

    public OxygenClient(File clientBinary, IRunUtil runUtil) {
        this(clientBinary);
        this.mRunUtil = runUtil;
    }

    public OxygenClient(File clientBinary) {
        String error = null;
        if (clientBinary == null) {
            error = "the Oxygen client binary reference is null";
        } else if (!clientBinary.exists()) {
            error = String.format("the Oxygen client binary file does not exist at %s", clientBinary.getAbsolutePath());
        } else if (!clientBinary.canExecute()) {
            error = String.format("the Oxygen client binary file at %s is not executable", clientBinary.getAbsolutePath());
        }
        if (clientBinary == null || !clientBinary.exists()) {
            throw new HarnessRuntimeException(String.format("Error in instantiating OxygenClient class: %s", error), InfraErrorIdentifier.CONFIGURED_ARTIFACT_NOT_FOUND);
        }
        this.mClientBinary = clientBinary;
    }

    public Boolean noWaitForBootSpecified(TestDeviceOptions deviceOptions) {
        return deviceOptions.getExtraOxygenArgs().containsKey("no_wait_for_boot");
    }

    public String getOverrideFetchCvdPath(TestDeviceOptions deviceOptions) {
        if (!deviceOptions.getExtraOxygenArgs().containsKey("override_fetch_cvd_path")) {
            return null;
        }
        String path = deviceOptions.getExtraOxygenArgs().get("override_fetch_cvd_path");
        return path == null ? "" : path;
    }

    private void addInvocationAttributes(List<String> args, MultiMap<String, String> attributes) {
        if (attributes == null) {
            return;
        }
        ArrayList<String> debugInfo = new ArrayList<String>();
        for (Map.Entry<String, String> attr : attributes.entries()) {
            if (!INVOCATION_ATTRIBUTES.contains(attr.getKey())) continue;
            debugInfo.add(String.format("%s:%s", attr.getKey(), attr.getValue()));
        }
        if (debugInfo.size() > 0) {
            args.add("-user_debug_info");
            args.add(String.join((CharSequence)",", debugInfo));
        }
    }

    public CommandResult leaseDevice(IBuildInfo b, TestDeviceOptions deviceOptions, MultiMap<String, String> attributes) {
        List<String> oxygenClientArgs = ArrayUtil.list(this.mClientBinary.getAbsolutePath());
        List<String> gceDriverParams = deviceOptions.getGceDriverParams();
        oxygenClientArgs.add("-lease");
        String branch = null;
        Boolean buildIdSet = false;
        for (int i = 0; i < gceDriverParams.size(); ++i) {
            String gceDriverOption = gceDriverParams.get(i);
            if (!sGceDeviceParamsToOxygenMap.containsKey(gceDriverOption)) continue;
            oxygenClientArgs.add(sGceDeviceParamsToOxygenMap.get(gceDriverOption));
            oxygenClientArgs.add(gceDriverParams.get(i + 1));
            if (gceDriverOption.equals("--branch")) {
                branch = gceDriverParams.get(i + 1);
            } else if (!buildIdSet.booleanValue() && sGceDeviceParamsToOxygenMap.get(gceDriverOption).equals("-build_id")) {
                buildIdSet = true;
            }
            ++i;
        }
        if (branch != null && !buildIdSet.booleanValue()) {
            oxygenClientArgs.add("-build_id");
            oxygenClientArgs.add(branch);
        }
        if (!oxygenClientArgs.contains("-build_target")) {
            oxygenClientArgs.add("-build_target");
            if (b.getBuildAttributes().containsKey("build_target")) {
                oxygenClientArgs.add(b.getBuildAttributes().get("build_target"));
            } else {
                oxygenClientArgs.add(b.getBuildFlavor());
            }
            oxygenClientArgs.add("-build_branch");
            oxygenClientArgs.add(b.getBuildBranch());
            oxygenClientArgs.add("-build_id");
            oxygenClientArgs.add(b.getBuildId());
        }
        oxygenClientArgs.add("-target_region");
        oxygenClientArgs.add(OxygenUtil.getTargetRegion(deviceOptions));
        oxygenClientArgs.add("-accounting_user");
        oxygenClientArgs.add(deviceOptions.getOxygenAccountingUser());
        oxygenClientArgs.add("-lease_length_secs");
        oxygenClientArgs.add(Long.toString(deviceOptions.getOxygenLeaseLength() / 1000L));
        String override_fetch_cvd_path = this.getOverrideFetchCvdPath(deviceOptions);
        if (override_fetch_cvd_path != null) {
            oxygenClientArgs.add("-override_fetch_cvd_path");
            if (override_fetch_cvd_path.isEmpty()) {
                String build_target = b.getBuildAttributes().getOrDefault("build_target", b.getBuildFlavor());
                override_fetch_cvd_path = String.format("ab/%s/%s", b.getBuildId(), build_target);
            }
            oxygenClientArgs.add(override_fetch_cvd_path);
        }
        for (Map.Entry<String, String> arg : deviceOptions.getExtraOxygenArgs().entrySet()) {
            oxygenClientArgs.add("-" + arg.getKey());
            if (Strings.isNullOrEmpty(arg.getValue())) continue;
            oxygenClientArgs.add(arg.getValue());
        }
        this.addInvocationAttributes(oxygenClientArgs, attributes);
        LogUtil.CLog.i("Leasing device from oxygen client with %s", oxygenClientArgs.toString());
        return this.runOxygenTimedCmd(oxygenClientArgs.toArray(new String[oxygenClientArgs.size()]), deviceOptions.getGceCmdTimeout());
    }

    public CommandResult leaseMultipleDevices(List<IBuildInfo> buildInfos, TestDeviceOptions deviceOptions, MultiMap<String, String> attributes) {
        List<String> oxygenClientArgs = ArrayUtil.list(this.mClientBinary.getAbsolutePath());
        oxygenClientArgs.add("-lease");
        ArrayList<String> buildTargets = new ArrayList<String>();
        ArrayList<String> buildBranches = new ArrayList<String>();
        ArrayList<String> buildIds = new ArrayList<String>();
        for (IBuildInfo iBuildInfo : buildInfos) {
            if (iBuildInfo.getBuildAttributes().containsKey("build_target")) {
                buildTargets.add(iBuildInfo.getBuildAttributes().get("build_target"));
            } else {
                buildTargets.add(iBuildInfo.getBuildFlavor());
            }
            buildBranches.add(iBuildInfo.getBuildBranch());
            buildIds.add(iBuildInfo.getBuildId());
        }
        if (buildTargets.size() > 0) {
            oxygenClientArgs.add("-build_target");
            oxygenClientArgs.add(String.join((CharSequence)",", buildTargets));
        }
        if (buildBranches.size() > 0) {
            oxygenClientArgs.add("-build_branch");
            oxygenClientArgs.add(String.join((CharSequence)",", buildBranches));
        }
        if (buildIds.size() > 0) {
            oxygenClientArgs.add("-build_id");
            oxygenClientArgs.add(String.join((CharSequence)",", buildIds));
        }
        oxygenClientArgs.add("-multidevice_size");
        oxygenClientArgs.add(String.valueOf(buildInfos.size()));
        oxygenClientArgs.add("-target_region");
        oxygenClientArgs.add(OxygenUtil.getTargetRegion(deviceOptions));
        oxygenClientArgs.add("-accounting_user");
        oxygenClientArgs.add(deviceOptions.getOxygenAccountingUser());
        oxygenClientArgs.add("-lease_length_secs");
        oxygenClientArgs.add(Long.toString(deviceOptions.getOxygenLeaseLength() / 1000L));
        for (Map.Entry entry : deviceOptions.getExtraOxygenArgs().entrySet()) {
            oxygenClientArgs.add("-" + (String)entry.getKey());
            if (Strings.isNullOrEmpty((String)entry.getValue())) continue;
            oxygenClientArgs.add((String)entry.getValue());
        }
        this.addInvocationAttributes(oxygenClientArgs, attributes);
        LogUtil.CLog.i("Leasing multiple devices from oxygen client with %s", oxygenClientArgs.toString());
        return this.runOxygenTimedCmd(oxygenClientArgs.toArray(new String[oxygenClientArgs.size()]), deviceOptions.getGceCmdTimeout());
    }

    public boolean release(GceAvdInfo gceAvdInfo, TestDeviceOptions deviceOptions) {
        if (gceAvdInfo == null || gceAvdInfo.instanceName() == null || gceAvdInfo.hostAndPort() == null || gceAvdInfo.hostAndPort().getHost() == null) {
            return true;
        }
        List<String> oxygenClientArgs = ArrayUtil.list(this.mClientBinary.getAbsolutePath());
        for (Map.Entry<String, String> arg : deviceOptions.getExtraOxygenArgs().entrySet()) {
            oxygenClientArgs.add("-" + arg.getKey());
            if (Strings.isNullOrEmpty(arg.getValue())) continue;
            oxygenClientArgs.add(arg.getValue());
        }
        oxygenClientArgs.add("-release");
        oxygenClientArgs.add("-target_region");
        oxygenClientArgs.add(OxygenUtil.getTargetRegion(deviceOptions));
        oxygenClientArgs.add("-server_url");
        oxygenClientArgs.add(gceAvdInfo.hostAndPort().getHost());
        oxygenClientArgs.add("-session_id");
        oxygenClientArgs.add(gceAvdInfo.instanceName());
        oxygenClientArgs.add("-accounting_user");
        oxygenClientArgs.add(deviceOptions.getOxygenAccountingUser());
        LogUtil.CLog.i("Releasing device from oxygen client with command %s", oxygenClientArgs.toString());
        CommandResult res = this.runOxygenTimedCmd(oxygenClientArgs.toArray(new String[oxygenClientArgs.size()]), deviceOptions.getGceCmdTimeout());
        if (!res.getStatus().equals((Object)CommandStatus.SUCCESS)) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.OXYGEN_DEVICE_RELEASE_FAILURE_COUNT, 1L);
            if (res.getStderr() != null) {
                String error = "Unknown";
                if (res.getStderr().contains("context deadline exceeded")) {
                    error = "SERVER_CALL_TIMEOUT";
                }
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.OXYGEN_DEVICE_RELEASE_FAILURE_MESSAGE, error);
            }
        }
        return res.getStatus().equals((Object)CommandStatus.SUCCESS);
    }

    private CommandResult runOxygenTimedCmd(String[] oxygenCmd, long timeout) {
        CommandResult res = this.getRunUtil().runTimedCmd(timeout, oxygenCmd);
        LogUtil.CLog.i("Oxygen client result status: %s, stdout: %s, stderr: %s", new Object[]{res.getStatus(), res.getStdout(), res.getStderr()});
        return res;
    }
}

