/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.GCSFileDownloader;
import com.android.tradefed.util.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OxygenUtil {
    private static final long MAX_FILE_SIZE_FOR_ERROR = 0xA00000L;
    private static final String ZONE_METADATA_URL = "http://metadata/computeMetadata/v1/instance/zone";
    private static final String DEFAULT_REGION = "us-west1";
    private GCSFileDownloader mDownloader;
    private static final Map<Pattern, LogDataType> REMOTE_LOG_NAME_PATTERN_TO_TYPE_MAP = Stream.of(new AbstractMap.SimpleEntry<Pattern, LogDataType>(Pattern.compile("^logcat.*"), LogDataType.LOGCAT), new AbstractMap.SimpleEntry<Pattern, LogDataType>(Pattern.compile(".*kernel.*"), LogDataType.KERNEL_LOG), new AbstractMap.SimpleEntry<Pattern, LogDataType>(Pattern.compile(".*bugreport.*zip"), LogDataType.BUGREPORTZ), new AbstractMap.SimpleEntry<Pattern, LogDataType>(Pattern.compile(".*bugreport.*txt"), LogDataType.BUGREPORT), new AbstractMap.SimpleEntry<Pattern, LogDataType>(Pattern.compile(".*tombstones-zip.*zip"), LogDataType.TOMBSTONEZ)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final Map<Pattern, Pair<String, String>> REMOTE_LOG_NAME_PATTERN_TO_ERROR_SIGNATURE_MAP = Stream.of(new AbstractMap.SimpleEntry<Pattern, Pair<String, String>>(Pattern.compile("^launcher\\.log.*"), Pair.create("Address already in use", "launch_cvd_port_collision")), new AbstractMap.SimpleEntry<Pattern, Pair<String, String>>(Pattern.compile("^launcher\\.log.*"), Pair.create("vcpu hw run failure: 0x7", "crosvm_vcpu_hw_run_failure_7")), new AbstractMap.SimpleEntry<Pattern, Pair<String, String>>(Pattern.compile("^launcher\\.log.*"), Pair.create("Unable to connect to vsock server", "unable_to_connect_to_vsock_server")), new AbstractMap.SimpleEntry<Pattern, Pair<String, String>>(Pattern.compile("^launcher\\.log.*"), Pair.create("failed to initialize fetch system images", "fetch_cvd_failure")), new AbstractMap.SimpleEntry<Pattern, Pair<String, String>>(Pattern.compile("^launcher\\.log.*"), Pair.create("failed to read from socket, retry", "rootcanal_socket_error"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    public OxygenUtil() {
        this.mDownloader = new GCSFileDownloader(true);
    }

    @VisibleForTesting
    OxygenUtil(GCSFileDownloader downloader) {
        this.mDownloader = downloader;
    }

    public void downloadLaunchFailureLogs(TargetSetupError error, ITestLogger logger) {
        String errorMessage = error.getMessage();
        if (error.getCause() != null) {
            errorMessage = String.format("%s %s", errorMessage, error.getCause().getMessage());
        }
        LogUtil.CLog.d("Downloading device launch failure logs based on error message: %s", errorMessage);
        Pattern pattern = Pattern.compile(".*/storage/browser/(.*)\\?&project=.*", 32);
        Matcher matcher = pattern.matcher(errorMessage);
        if (!matcher.find()) {
            LogUtil.CLog.d("Error message doesn't contain expected GCS link.");
            return;
        }
        String remoteFilePath = "gs://" + matcher.group(1);
        try {
            File localDir = this.mDownloader.downloadFile(remoteFilePath);
            String oxygenVersion = OxygenUtil.collectOxygenVersion(localDir);
            if (!Strings.isNullOrEmpty(oxygenVersion)) {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_OXYGEN_VERSION, oxygenVersion);
            }
            Set<String> files = FileUtil.findFiles(localDir, ".*");
            for (String f : files) {
                File file2 = new File(f);
                if (file2.isDirectory()) continue;
                LogUtil.CLog.d("Logging %s", f);
                try (FileInputStreamSource data = new FileInputStreamSource(file2);){
                    String logFileName = "oxygen_" + localDir.toPath().relativize(file2.toPath()).toString().replace(File.separatorChar, '_');
                    LogDataType logDataType = OxygenUtil.getDefaultLogType(logFileName);
                    if (logDataType == LogDataType.UNKNOWN) {
                        logDataType = LogDataType.CUTTLEFISH_LOG;
                    }
                    logger.testLog(logFileName, logDataType, data);
                }
            }
        }
        catch (Exception e) {
            LogUtil.CLog.e("Failed to download Oxygen log from %s", remoteFilePath);
            LogUtil.CLog.e(e);
        }
    }

    public static LogDataType getDefaultLogType(String logFileName) {
        for (Map.Entry<Pattern, LogDataType> entry : REMOTE_LOG_NAME_PATTERN_TO_TYPE_MAP.entrySet()) {
            Matcher matcher = entry.getKey().matcher(logFileName);
            if (!matcher.find()) continue;
            return entry.getValue();
        }
        LogUtil.CLog.d(String.format("Unable to determine log type of the remote log file %s, log type is UNKNOWN", logFileName));
        return LogDataType.UNKNOWN;
    }

    public static List<String> collectErrorSignatures(File logDir) {
        LogUtil.CLog.d("Collect error signature from logs under: %s.", logDir);
        ArrayList<String> signatures = new ArrayList<String>();
        try {
            Set<String> files = FileUtil.findFiles(logDir, ".*");
            block12: for (String f : files) {
                File file2 = new File(f);
                if (file2.isDirectory()) continue;
                String fileName = file2.getName();
                ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
                for (Map.Entry<Pattern, Pair<String, String>> entry : REMOTE_LOG_NAME_PATTERN_TO_ERROR_SIGNATURE_MAP.entrySet()) {
                    Matcher matcher = entry.getKey().matcher(fileName);
                    if (!matcher.find()) continue;
                    pairs.add(entry.getValue());
                }
                if (pairs.size() == 0) continue;
                try (FileInputStream stream = new FileInputStream(file2);){
                    long skipSize = Files.size(file2.toPath()) - 0xA00000L;
                    if (skipSize > 0L) {
                        stream.skip(skipSize);
                    }
                    try (Scanner scanner = new Scanner(stream);){
                        ArrayList<Pair> pairsToRemove = new ArrayList<Pair>();
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            for (Pair pair : pairs) {
                                if (line.indexOf((String)pair.first) == -1) continue;
                                pairsToRemove.add(pair);
                                signatures.add((String)pair.second);
                            }
                            if (pairsToRemove.size() <= 0) continue;
                            pairs.removeAll(pairsToRemove);
                            if (pairs.size() != 0) continue;
                            continue block12;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LogUtil.CLog.e("Failed to collect error signature.");
            LogUtil.CLog.e(e);
        }
        Collections.sort(signatures);
        return signatures;
    }

    public static long[] collectDeviceLaunchMetrics(File logDir) {
        LogUtil.CLog.d("Collect device launcher metrics from logs under: %s.", logDir);
        long[] metrics = new long[]{-1L, -1L};
        try {
            Set<String> files = FileUtil.findFiles(logDir, "^vdl_stdout\\.txt.*");
            if (files.size() == 0) {
                LogUtil.CLog.d("There is no vdl_stdout.txt found.");
                return metrics;
            }
            File vdlStdout = new File(files.iterator().next());
            double cuttlefishCommon = 0.0;
            double launchDevice = 0.0;
            double mainstart = 0.0;
            Pattern cuttlefishCommonPatteren = Pattern.compile(".*\\|\\s*(\\d+\\.\\d+)\\s*\\|\\sCuttlefishCommon");
            Pattern launchDevicePatteren = Pattern.compile(".*\\|\\s*(\\d+\\.\\d+)\\s*\\|\\sLaunchDevice");
            Pattern mainstartPatteren = Pattern.compile(".*\\|\\s*(\\d+\\.\\d+)\\s*\\|\\sCuttlefishLauncherMainstart");
            try (Scanner scanner = new Scanner(vdlStdout);){
                boolean metricsPending = false;
                while (scanner.hasNextLine()) {
                    Matcher matcher;
                    String line = scanner.nextLine();
                    if (!metricsPending) {
                        if (line.indexOf("launch_cvd exited") == -1) continue;
                        metricsPending = true;
                    }
                    if (cuttlefishCommon == 0.0 && (matcher = cuttlefishCommonPatteren.matcher(line)).find()) {
                        cuttlefishCommon = Double.parseDouble(matcher.group(1));
                    }
                    if (launchDevice == 0.0 && (matcher = launchDevicePatteren.matcher(line)).find()) {
                        launchDevice = Double.parseDouble(matcher.group(1));
                    }
                    if (mainstart != 0.0 || !(matcher = mainstartPatteren.matcher(line)).find()) continue;
                    mainstart = Double.parseDouble(matcher.group(1));
                }
            }
            if (mainstart > 0.0) {
                metrics[0] = (long)((mainstart - launchDevice - cuttlefishCommon) * 1000.0);
                metrics[1] = (long)(launchDevice * 1000.0);
            }
        }
        catch (Exception e) {
            LogUtil.CLog.e("Failed to parse device launch time from vdl_stdout.txt.");
            LogUtil.CLog.e(e);
        }
        return metrics;
    }

    public static String collectOxygenVersion(File logDir) {
        LogUtil.CLog.d("Collect Oxygen version from logs under: %s.", logDir);
        try {
            Set<String> files = FileUtil.findFiles(logDir, "^oxygen_version\\.txt.*");
            if (files.size() == 0) {
                LogUtil.CLog.d("There is no oxygen_version.txt found.");
                return null;
            }
            return FileUtil.readStringFromFile(new File(files.iterator().next())).replaceAll("(?s)\\n+$", "").trim();
        }
        catch (Exception e) {
            LogUtil.CLog.e("Failed to read oxygen_version.txt .");
            LogUtil.CLog.e(e);
            return null;
        }
    }

    public static String getTargetRegion(TestDeviceOptions deviceOptions) {
        if (deviceOptions.getOxygenTargetRegion() != null) {
            return deviceOptions.getOxygenTargetRegion();
        }
        try {
            URL url = new URL(ZONE_METADATA_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Metadata-Flavor", "Google");
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            return OxygenUtil.getRegionFromZoneMeta(response.toString());
        }
        catch (Exception e) {
            LogUtil.CLog.e(e);
            return DEFAULT_REGION;
        }
    }

    public static String getRegionFromZoneMeta(String zone) {
        int lastSlashIndex = zone.lastIndexOf("/");
        String region = zone.substring(lastSlashIndex + 1);
        int lastDashIndex = region.lastIndexOf("-");
        return region.substring(0, lastDashIndex);
    }
}

