/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.ddmlib.IDevice;
import com.android.tradefed.command.remote.DeviceDescriptor;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceMonitor;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.RemoteAndroidDevice;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.connection.AdbSshConnection;
import com.android.tradefed.device.connection.DefaultConnection;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;

public class RemoteAndroidVirtualDevice
extends RemoteAndroidDevice {
    public RemoteAndroidVirtualDevice(IDevice device, IDeviceStateMonitor stateMonitor, IDeviceMonitor allocationMonitor) {
        super(device, stateMonitor, allocationMonitor);
    }

    @Override
    public List<File> getTombstones() throws DeviceNotAvailableException {
        TestDeviceOptions.InstanceType type = this.getOptions().getInstanceType();
        if ((TestDeviceOptions.InstanceType.CUTTLEFISH.equals((Object)type) || TestDeviceOptions.InstanceType.REMOTE_NESTED_AVD.equals((Object)type)) && this.getConnection() instanceof AdbSshConnection) {
            return ((AdbSshConnection)this.getConnection()).getTombstones();
        }
        return super.getTombstones();
    }

    @Override
    public DeviceDescriptor getDeviceDescriptor(boolean shortDescriptor) {
        String initialSerial;
        DeviceDescriptor descriptor = super.getDeviceDescriptor(shortDescriptor);
        if (this.getConnection() instanceof DefaultConnection && !(initialSerial = ((DefaultConnection)this.getConnection()).getInitialSerial()).equals(descriptor.getSerial())) {
            descriptor = new DeviceDescriptor(descriptor, initialSerial, initialSerial + "[" + descriptor.getSerial() + "]");
        }
        return descriptor;
    }

    @Deprecated
    @Nullable
    public GceAvdInfo getAvdInfo() {
        if (this.getConnection() instanceof AdbSshConnection) {
            LogUtil.CLog.w("Getting GceAvdInfo via deprecated method.");
            return ((AdbSshConnection)this.getConnection()).getAvdInfo();
        }
        return null;
    }

    @Deprecated
    public boolean powerwashGce() throws TargetSetupError {
        throw new UnsupportedOperationException("RemoteAndroidVirtualDevice#powerwash should never be called. Only connection one should be invoked.");
    }

    @Deprecated
    public CommandResult powerwash() throws TargetSetupError {
        return this.powerwashGce(null, null);
    }

    @Deprecated
    public CommandResult powerwashGce(String user, Integer offset) throws TargetSetupError {
        throw new UnsupportedOperationException("RemoteAndroidVirtualDevice#powerwash should never be called. Only connection one should be invoked.");
    }
}

