/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.cloud;

import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.cloud.GceRemoteCmdFormatter;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class RemoteFileUtil {
    public static File fetchRemoteFile(GceAvdInfo remoteInstance, TestDeviceOptions options, IRunUtil runUtil, long timeout, String remoteFilePath) {
        String fileName = new File(remoteFilePath).getName();
        File localFile = null;
        try {
            localFile = FileUtil.createTempFile(FileUtil.getBaseName(fileName) + "_", FileUtil.getExtension(fileName));
            if (RemoteFileUtil.fetchRemoteFile(remoteInstance, options, runUtil, timeout, remoteFilePath, localFile)) {
                return localFile;
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
        FileUtil.deleteFile(localFile);
        return null;
    }

    public static boolean fetchRemoteFile(GceAvdInfo remoteInstance, TestDeviceOptions options, IRunUtil runUtil, long timeout, String remoteFilePath, File localFile) {
        return RemoteFileUtil.internalScpExec(remoteInstance, options, null, runUtil, timeout, remoteFilePath, localFile, GceRemoteCmdFormatter.ScpMode.PULL);
    }

    public static boolean fetchRemoteDir(GceAvdInfo remoteInstance, TestDeviceOptions options, IRunUtil runUtil, long timeout, String remoteDirPath, File localDir) {
        return RemoteFileUtil.internalScpExec(remoteInstance, options, Arrays.asList("-r"), runUtil, timeout, remoteDirPath, localDir, GceRemoteCmdFormatter.ScpMode.PULL);
    }

    public static File fetchRemoteDir(GceAvdInfo remoteInstance, TestDeviceOptions options, IRunUtil runUtil, long timeout, String remoteDirPath) {
        String dirName = new File(remoteDirPath).getName();
        File localFile = null;
        try {
            localFile = FileUtil.createTempDir(dirName);
            if (RemoteFileUtil.internalScpExec(remoteInstance, options, Arrays.asList("-r"), runUtil, timeout, remoteDirPath, localFile, GceRemoteCmdFormatter.ScpMode.PULL)) {
                return localFile;
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
        FileUtil.deleteFile(localFile);
        return null;
    }

    public static boolean doesRemoteFileExist(GceAvdInfo remoteInstance, TestDeviceOptions options, IRunUtil runUtil, long timeout, String remotePath) {
        List<String> sshCmd = GceRemoteCmdFormatter.getSshCommand(options.getSshPrivateKeyPath(), null, options.getInstanceUser(), remoteInstance.hostAndPort().getHost(), "ls", remotePath);
        CommandResult resSsh = runUtil.runTimedCmd(timeout, sshCmd.toArray(new String[0]));
        return resSsh.getExitCode() == 0;
    }

    public static boolean pushFileToRemote(GceAvdInfo remoteInstance, TestDeviceOptions options, List<String> scpArgs, IRunUtil runUtil, long timeout, String remoteFilePath, File localFile) {
        return RemoteFileUtil.internalScpExec(remoteInstance, options, scpArgs, runUtil, timeout, remoteFilePath, localFile, GceRemoteCmdFormatter.ScpMode.PUSH);
    }

    private static boolean internalScpExec(GceAvdInfo remoteInstance, TestDeviceOptions options, List<String> scpArgs, IRunUtil runUtil, long timeout, String remoteFilePath, File localFile, GceRemoteCmdFormatter.ScpMode mode) {
        List<String> scpCmd = GceRemoteCmdFormatter.getScpCommand(options.getSshPrivateKeyPath(), scpArgs, options.getInstanceUser(), remoteInstance.hostAndPort().getHost(), remoteFilePath, localFile.getAbsolutePath(), mode);
        CommandResult resScp = runUtil.runTimedCmd(timeout, scpCmd.toArray(new String[0]));
        if (!CommandStatus.SUCCESS.equals((Object)resScp.getStatus())) {
            StringBuilder builder = new StringBuilder();
            builder.append("Issue when ");
            if (GceRemoteCmdFormatter.ScpMode.PULL.equals((Object)mode)) {
                builder.append("pulling ");
            } else {
                builder.append("pushing ");
            }
            builder.append(String.format("file, status: %s", new Object[]{resScp.getStatus()}));
            LogUtil.CLog.e(builder.toString());
            LogUtil.CLog.e("%s", resScp.getStderr());
            return false;
        }
        return true;
    }
}

