/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.connection;

import com.android.ddmlib.IDevice;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NativeDevice;
import com.android.tradefed.device.NullDevice;
import com.android.tradefed.device.RemoteAvdIDevice;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.cloud.CommonLogRemoteFileUtil;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.cloud.GceManager;
import com.android.tradefed.device.cloud.GceSshTunnelMonitor;
import com.android.tradefed.device.cloud.OxygenUtil;
import com.android.tradefed.device.cloud.RemoteFileUtil;
import com.android.tradefed.device.cloud.VmRemoteDevice;
import com.android.tradefed.device.connection.AdbTcpConnection;
import com.android.tradefed.device.connection.DefaultConnection;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.StreamUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdbSshConnection
extends AdbTcpConnection {
    private GceAvdInfo mGceAvd = null;
    private GceManager mGceHandler = null;
    private GceSshTunnelMonitor mGceSshMonitor;
    private DeviceNotAvailableException mTunnelInitFailed = null;
    private boolean mIsRemote = false;
    private String mKnownIp = null;
    private static final long CHECK_WAIT_DEVICE_AVAIL_MS = 30000L;
    private static final int WAIT_TIME_DIVISION = 4;
    private static final long WAIT_FOR_TUNNEL_OFFLINE = 5000L;
    private static final long WAIT_FOR_TUNNEL_ONLINE = 120000L;
    private static final long FETCH_TOMBSTONES_TIMEOUT_MS = 300000L;

    public AdbSshConnection(DefaultConnection.ConnectionBuilder builder) {
        super(builder);
        if (builder.existingAvdInfo != null) {
            this.mGceAvd = builder.existingAvdInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeConnection() throws DeviceNotAvailableException, TargetSetupError {
        this.mGceSshMonitor = null;
        this.mTunnelInitFailed = null;
        this.mGceHandler = new GceManager(this.getDevice().getDeviceDescriptor(), this.getDevice().getOptions(), this.getBuildInfo());
        if (this.getDevice().getIDevice() instanceof VmRemoteDevice) {
            this.mIsRemote = true;
            this.mKnownIp = ((VmRemoteDevice)this.getDevice().getIDevice()).getKnownDeviceIp();
        }
        long remainingTime = this.getDevice().getOptions().getGceCmdTimeout();
        if (this.mGceAvd != null) {
            LogUtil.CLog.d("skipped GCE launch because GceAvdInfo %s is already set", this.mGceAvd);
            this.createGceSshMonitor(this.getDevice(), this.getBuildInfo(), this.mGceAvd.hostAndPort(), this.getDevice().getOptions());
        } else {
            long startTime = this.getCurrentTime();
            try {
                if (GlobalConfiguration.getInstance().getHostOptions().getConcurrentVirtualDeviceStartupLimit() != null) {
                    GlobalConfiguration.getInstance().getHostOptions().takePermit(IHostOptions.PermitLimitType.CONCURRENT_VIRTUAL_DEVICE_STARTUP);
                    long queueTime = System.currentTimeMillis() - startTime;
                    LogUtil.CLog.v("Fetch and launch CVD permit obtained after %ds", TimeUnit.MILLISECONDS.toSeconds(queueTime));
                }
                this.launchGce(this.getBuildInfo(), this.getAttributes());
            }
            finally {
                if (GlobalConfiguration.getInstance().getHostOptions().getConcurrentVirtualDeviceStartupLimit() != null) {
                    GlobalConfiguration.getInstance().getHostOptions().returnPermit(IHostOptions.PermitLimitType.CONCURRENT_VIRTUAL_DEVICE_STARTUP);
                }
            }
            if ((remainingTime -= this.getCurrentTime() - startTime) <= 0L) {
                throw new DeviceNotAvailableException(String.format("Failed to launch GCE after %sms", this.getDevice().getOptions().getGceCmdTimeout()), this.getDevice().getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.FAILED_TO_LAUNCH_GCE);
            }
            LogUtil.CLog.d("%sms left before timeout after GCE launch returned", remainingTime);
        }
        ITestDevice.RecoveryMode previousMode = this.getDevice().getRecoveryMode();
        this.getDevice().setRecoveryMode(ITestDevice.RecoveryMode.NONE);
        boolean unresponsive = true;
        try {
            for (int i = 0; i < 4; ++i) {
                if (((IManagedTestDevice)this.getDevice()).getMonitor().waitForDeviceAvailable(remainingTime / 4L) != null) {
                    unresponsive = false;
                    break;
                }
                this.waitForTunnelOnline(120000L);
                this.waitForAdbConnect(this.getDevice().getSerialNumber(), 120000L);
            }
        }
        finally {
            this.getDevice().setRecoveryMode(previousMode);
        }
        if (!IDevice.DeviceState.ONLINE.equals((Object)this.getDevice().getIDevice().getState()) || unresponsive) {
            if (this.mGceAvd != null && GceAvdInfo.GceStatus.SUCCESS.equals((Object)this.mGceAvd.getStatus())) {
                this.mGceAvd.setStatus(GceAvdInfo.GceStatus.DEVICE_OFFLINE);
            }
            if (unresponsive) {
                throw new DeviceUnresponsiveException("AVD device booted to online but is unresponsive.", this.getDevice().getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNRESPONSIVE);
            }
            throw new DeviceNotAvailableException(String.format("AVD device booted but was in %s state", new Object[]{this.getDevice().getIDevice().getState()}), this.getDevice().getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.FAILED_TO_LAUNCH_GCE);
        }
        this.getDevice().enableAdbRoot();
        if (this.getDevice().getOptions().isLogcatCaptureEnabled()) {
            this.getDevice().startLogcat();
        }
    }

    @Override
    public void reconnect(String serial) throws DeviceNotAvailableException {
        if (!this.getGceSshMonitor().isTunnelAlive()) {
            this.getGceSshMonitor().closeConnection();
            this.getRunUtil().sleep(5000L);
            this.waitForTunnelOnline(120000L);
        }
        super.reconnect(serial);
    }

    @Override
    public void reconnectForRecovery(String serial) throws DeviceNotAvailableException {
        if (this.getGceSshMonitor() == null) {
            if (this.mTunnelInitFailed != null) {
                throw this.mTunnelInitFailed;
            }
            this.waitForTunnelOnline(120000L);
        }
        if (!this.getDevice().waitForDeviceShell(30000L)) {
            long startTime = System.currentTimeMillis();
            try {
                LogUtil.CLog.i("Attempting recovery on GCE AVD %s", serial);
                this.getGceSshMonitor().closeConnection();
                this.getRunUtil().sleep(5000L);
                this.waitForTunnelOnline(120000L);
                this.waitForAdbConnect(serial, 120000L);
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_RECOVERED_FROM_SSH_TUNNEL, 1L);
            }
            catch (Exception e) {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.RECOVERY_ROUTINE_COUNT, 1L);
                throw e;
            }
            finally {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.RECOVERY_TIME, System.currentTimeMillis() - startTime);
            }
        }
    }

    @Override
    public void notifyAdbRebootCalled() {
        GceSshTunnelMonitor tunnelMonitor = this.getGceSshMonitor();
        if (tunnelMonitor != null) {
            tunnelMonitor.isAdbRebootCalled(true);
        }
    }

    @Override
    public void tearDownConnection() {
        try {
            LogUtil.CLog.i("Invocation tear down for device %s", this.getDevice().getSerialNumber());
            this.getDevice().clearLogcat();
            this.getDevice().stopLogcat();
            if (this.getGceSshMonitor() != null) {
                this.getGceSshMonitor().logSshTunnelLogs(this.getLogger());
                this.getGceSshMonitor().shutdown();
                try {
                    this.getGceSshMonitor().joinMonitor();
                }
                catch (InterruptedException e1) {
                    LogUtil.CLog.i("Interrupted while waiting for GCE SSH monitor to shutdown.");
                }
                this.mGceSshMonitor = null;
            }
            if (!((IManagedTestDevice)this.getDevice()).waitForDeviceNotAvailable(20000L)) {
                LogUtil.CLog.w("Device %s still available after timeout.", this.getDevice().getSerialNumber());
            }
            if (this.mGceAvd != null && this.mGceAvd.hostAndPort() != null) {
                if (!GceAvdInfo.GceStatus.SUCCESS.equals((Object)this.mGceAvd.getStatus()) && !this.mGceAvd.getSkipBugreportCollection()) {
                    this.getSshBugreport();
                }
                this.getGceHandler().logSerialOutput(this.mGceAvd, this.getLogger());
                boolean isGceReachable = CommonLogRemoteFileUtil.isRemoteGceReachableBySsh(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil());
                if (isGceReachable) {
                    CommonLogRemoteFileUtil.fetchCommonFiles(this.getLogger(), this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil());
                    CommonLogRemoteFileUtil.fetchTombstones(this.getLogger(), this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil());
                } else {
                    LogUtil.CLog.e("Failed to establish ssh connect to remote file host, skipping remote common file and tombstones collection.");
                }
                if (this.getDevice().getOptions().useOxygen()) {
                    CommonLogRemoteFileUtil.logRemoteCommandOutput(this.getLogger(), this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil(), "host_kernel.log", "toybox", "dmesg");
                }
            }
            if (!this.getDevice().getOptions().shouldSkipTearDown() && this.getGceHandler() != null) {
                this.getGceHandler().shutdownGce();
            }
            this.mGceAvd = null;
            if (this.getInitialSerial() != null) {
                if (this.wasTemporaryHolder()) {
                    ((IManagedTestDevice)this.getDevice()).setIDevice(new NullDevice(this.getInitialSerial(), true));
                } else if (this.mIsRemote) {
                    ((IManagedTestDevice)this.getDevice()).setIDevice(new VmRemoteDevice(this.getInitialSerial(), this.mKnownIp));
                } else {
                    ((IManagedTestDevice)this.getDevice()).setIDevice(new RemoteAvdIDevice(this.getInitialSerial(), this.getInitialIp(), this.getInitialUser(), this.getInitialDeviceNumOffset()));
                }
                LogUtil.CLog.d("Release as idevice: %s", ((IManagedTestDevice)this.getDevice()).getIDevice());
            }
            if (this.getGceHandler() != null) {
                this.getGceHandler().cleanUp();
            }
        }
        finally {
            super.tearDownConnection();
        }
    }

    protected void launchGce(IBuildInfo buildInfo, MultiMap<String, String> attributes) throws TargetSetupError {
        DeviceErrorIdentifier errorIdentifier;
        TargetSetupError exception = null;
        for (int attempt = 0; attempt < this.getDevice().getOptions().getGceMaxAttempt(); ++attempt) {
            try {
                this.mGceAvd = this.getGceHandler().startGce(this.getInitialIp(), this.getInitialUser(), this.getInitialDeviceNumOffset(), attributes, this.getLogger());
                if (this.mGceAvd == null) continue;
                if (GceAvdInfo.GceStatus.SUCCESS.equals((Object)this.mGceAvd.getStatus())) break;
                LogUtil.CLog.w("Failed to start AVD with attempt: %s out of %s, error: %s", attempt + 1, this.getDevice().getOptions().getGceMaxAttempt(), this.mGceAvd.getErrors());
                continue;
            }
            catch (TargetSetupError tse) {
                LogUtil.CLog.w("Failed to start Gce with attempt: %s out of %s. With Exception: %s", attempt + 1, this.getDevice().getOptions().getGceMaxAttempt(), tse);
                exception = tse;
                if (!this.getDevice().getOptions().useOxygen()) continue;
                OxygenUtil util = new OxygenUtil();
                util.downloadLaunchFailureLogs(tse, this.getLogger());
            }
        }
        if (this.mGceAvd == null) {
            throw exception;
        }
        LogUtil.CLog.i("GCE AVD has been started: %s", this.mGceAvd);
        ErrorIdentifier errorIdentifier2 = errorIdentifier = this.mGceAvd.getErrorType() != null ? this.mGceAvd.getErrorType() : DeviceErrorIdentifier.FAILED_TO_LAUNCH_GCE;
        if (GceAvdInfo.GceStatus.BOOT_FAIL.equals((Object)this.mGceAvd.getStatus())) {
            String errorMsg = String.format("Device failed to boot. Error from device leasing attempt: %s", this.mGceAvd.getErrors());
            throw new TargetSetupError(errorMsg, this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)errorIdentifier);
        }
        if (GceAvdInfo.GceStatus.FAIL.equals((Object)this.mGceAvd.getStatus())) {
            throw new TargetSetupError(this.mGceAvd.getErrors(), this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)errorIdentifier);
        }
        this.createGceSshMonitor(this.getDevice(), buildInfo, this.mGceAvd.hostAndPort(), this.getDevice().getOptions());
    }

    void createGceSshMonitor(ITestDevice device, IBuildInfo buildInfo, HostAndPort hostAndPort, TestDeviceOptions deviceOptions) {
        this.mGceSshMonitor = new GceSshTunnelMonitor(device, buildInfo, hostAndPort, deviceOptions);
        this.mGceSshMonitor.start();
    }

    protected void waitForTunnelOnline(long waitTime) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Waiting %d ms for tunnel to be restarted", waitTime);
        long startTime = this.getCurrentTime();
        while (this.getCurrentTime() - startTime < waitTime) {
            if (this.getGceSshMonitor() == null) {
                LogUtil.CLog.e("Tunnel Thread terminated, something went wrong with the device.");
                break;
            }
            if (this.getGceSshMonitor().isTunnelAlive()) {
                LogUtil.CLog.d("Tunnel online again, resuming.");
                return;
            }
            this.getRunUtil().sleep(5000L);
        }
        this.mTunnelInitFailed = new DeviceNotAvailableException(String.format("Tunnel did not come back online after %sms", waitTime), this.getDevice().getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.FAILED_TO_CONNECT_TO_GCE);
        throw this.mTunnelInitFailed;
    }

    public GceSshTunnelMonitor getGceSshMonitor() {
        return this.mGceSshMonitor;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    GceManager getGceHandler() {
        return this.mGceHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSshBugreport() {
        if (this.mGceAvd == null) {
            LogUtil.CLog.w("No GceAvdInfo to fetch bugreport from.");
            return;
        }
        TestDeviceOptions.InstanceType type = this.getDevice().getOptions().getInstanceType();
        File bugreportFile = null;
        try {
            bugreportFile = TestDeviceOptions.InstanceType.GCE.equals((Object)type) || TestDeviceOptions.InstanceType.REMOTE_AVD.equals((Object)type) ? GceManager.getBugreportzWithSsh(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil()) : GceManager.getNestedDeviceSshBugreportz(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil());
            if (bugreportFile != null) {
                FileInputStreamSource bugreport = new FileInputStreamSource(bugreportFile);
                this.getLogger().testLog("bugreportz-ssh", LogDataType.BUGREPORTZ, bugreport);
                StreamUtil.cancel(bugreport);
            }
            FileUtil.deleteFile(bugreportFile);
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
        finally {
            FileUtil.deleteFile(bugreportFile);
        }
    }

    public CommandResult powerwash() throws TargetSetupError {
        return this.powerwashGce(null, null);
    }

    public CommandResult powerwashGce(String user, Integer offset) throws TargetSetupError {
        long startTime = System.currentTimeMillis();
        if (this.mGceAvd == null) {
            String errorMsg = String.format("Can not get GCE AVD Info. launch GCE first?", new Object[0]);
            throw new TargetSetupError(errorMsg, this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
        }
        if (user == null) {
            user = this.getDevice().getOptions().getInstanceUser();
        }
        String powerwashCommand = String.format("/home/%s/bin/powerwash_cvd", user);
        if (offset != null) {
            powerwashCommand = String.format("HOME=/home/%s/acloud_cf_%d acloud_cf_%d/bin/powerwash_cvd -instance_num %d", user, offset + 1, offset + 1, offset + 1);
        }
        if (this.getDevice().getOptions().useOxygen()) {
            CommandResult result = GceManager.remoteSshCommandExecution(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil(), 10000L, "toybox find /tmp -name powerwash_cvd".split(" "));
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                LogUtil.CLog.e("Failed to locate powerwash_cvd: %s", result.getStderr());
                return result;
            }
            String powerwashPath = result.getStdout();
            String tmpDir = powerwashPath.substring(0, powerwashPath.length() - 18);
            powerwashCommand = String.format("HOME=%s %s", tmpDir, powerwashPath);
        }
        CommandResult powerwashRes = GceManager.remoteSshCommandExecution(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil(), Math.max(300000L, this.getDevice().getOptions().getGceCmdTimeout()), powerwashCommand.split(" "));
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.POWERWASH_TIME, Long.toString(System.currentTimeMillis() - startTime));
        if (!CommandStatus.SUCCESS.equals((Object)powerwashRes.getStatus())) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.POWERWASH_FAILURE_COUNT, 1L);
            LogUtil.CLog.e("%s", powerwashRes.getStderr());
            CommandResult printAdbDevices = this.getRunUtil().runTimedCmd(60000L, "adb", "devices");
            LogUtil.CLog.e("%s\n%s", printAdbDevices.getStdout(), printAdbDevices.getStderr());
            return powerwashRes;
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.POWERWASH_SUCCESS_COUNT, 1L);
        ((IManagedTestDevice)this.getDevice()).getMonitor().waitForDeviceAvailable();
        if (this.getDevice() instanceof NativeDevice) {
            ((NativeDevice)this.getDevice()).resetContentProviderSetup();
        }
        return powerwashRes;
    }

    String commandBuilder(String command, String user, Integer offset) {
        String builtCommand = String.format("/home/%s/bin/%s", user, command);
        if (offset != null) {
            builtCommand = String.format("HOME=/home/%s/acloud_cf_%d acloud_cf_%d/bin/%s -instance_num %d", user, offset + 1, offset + 1, command, offset + 1);
        }
        if (this.getDevice().getOptions().useOxygen()) {
            CommandResult result = GceManager.remoteSshCommandExecution(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil(), 10000L, String.format("toybox find /tmp -name %s", command).split(" "));
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                LogUtil.CLog.e("Failed to locate %s: %s", command, result.getStderr());
                return "";
            }
            String commandPath = result.getStdout();
            String tmpDir = commandPath.substring(0, commandPath.length() - (command.length() + 5));
            builtCommand = String.format("HOME=%s %s", tmpDir, commandPath);
        }
        return builtCommand;
    }

    public CommandResult snapshotGce(String user, Integer offset, String snapshotId) throws TargetSetupError {
        String snapshotCommand;
        long startTime = System.currentTimeMillis();
        if (this.mGceAvd == null) {
            String errorMsg = "Can not get GCE AVD Info. launch GCE first?";
            throw new TargetSetupError(errorMsg, this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
        }
        if (user == null) {
            user = this.getDevice().getOptions().getInstanceUser();
        }
        if (Strings.isNullOrEmpty(snapshotCommand = this.commandBuilder(String.format("cvd snapshot_take --snapshot_path=/tmp/%s/snapshots/%s", user, snapshotId), user, offset))) {
            throw new TargetSetupError("failed to set up snapshot command, invalid path", this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_SNAPSHOT);
        }
        CommandResult snapshotRes = GceManager.remoteSshCommandExecution(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil(), Math.max(30000L, this.getDevice().getOptions().getGceCmdTimeout()), snapshotCommand);
        if (!CommandStatus.SUCCESS.equals((Object)snapshotRes.getStatus())) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SNAPSHOT_FAILURE_COUNT, 1L);
            LogUtil.CLog.e("%s", snapshotRes.getStderr());
            throw new TargetSetupError("failed to snapshot device", this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_SNAPSHOT);
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SNAPSHOT_DURATIONS, Long.toString(System.currentTimeMillis() - startTime));
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SNAPSHOT_SUCCESS_COUNT, 1L);
        return snapshotRes;
    }

    public CommandResult suspendGce(String user, Integer offset) throws TargetSetupError {
        String suspendCommand;
        long startTime = System.currentTimeMillis();
        if (user == null) {
            user = this.getDevice().getOptions().getInstanceUser();
        }
        if ((suspendCommand = this.commandBuilder("cvd suspend", user, offset)).length() == 0) {
            throw new TargetSetupError("failed to set up suspend command, invalid path", this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_SUSPEND);
        }
        CommandResult suspendRes = GceManager.remoteSshCommandExecution(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil(), Math.max(30000L, this.getDevice().getOptions().getGceCmdTimeout()), suspendCommand);
        if (!CommandStatus.SUCCESS.equals((Object)suspendRes.getStatus())) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SUSPEND_FAILURE_COUNT, 1L);
            LogUtil.CLog.e("%s", suspendRes.getStderr());
            throw new TargetSetupError("failed to suspend device", this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_SUSPEND);
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SUSPEND_DURATIONS, Long.toString(System.currentTimeMillis() - startTime));
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SUSPEND_SUCCESS_COUNT, 1L);
        return suspendRes;
    }

    public CommandResult resumeGce(String user, Integer offset) throws TargetSetupError {
        String resumeCommand;
        long startTime = System.currentTimeMillis();
        if (user == null) {
            user = this.getDevice().getOptions().getInstanceUser();
        }
        if ((resumeCommand = this.commandBuilder("cvd resume", user, offset)).length() == 0) {
            throw new TargetSetupError("failed to set up resume command, invalid path", this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_RESUME);
        }
        CommandResult resumeRes = GceManager.remoteSshCommandExecution(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil(), Math.max(300000L, this.getDevice().getOptions().getGceCmdTimeout()), resumeCommand);
        if (!CommandStatus.SUCCESS.equals((Object)resumeRes.getStatus())) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_RESUME_FAILURE_COUNT, 1L);
            LogUtil.CLog.e("%s", resumeRes.getStderr());
            throw new TargetSetupError("failed to resume device", this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_RESUME);
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_RESUME_DURATIONS, Long.toString(System.currentTimeMillis() - startTime));
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_RESUME_SUCCESS_COUNT, 1L);
        return resumeRes;
    }

    public CommandResult restoreSnapshotGce(String user, Integer offset, String snapshotId) throws TargetSetupError {
        String restoreCommand;
        long startTime = System.currentTimeMillis();
        if (user == null) {
            user = this.getDevice().getOptions().getInstanceUser();
        }
        if ((restoreCommand = this.commandBuilder(String.format("cvd start --snapshot_path=/tmp/%s/snapshots/%s", user, snapshotId), user, offset)).length() == 0) {
            throw new TargetSetupError("failed to set up restore command, invalid path", this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_RESTORE_SNAPSHOT);
        }
        CommandResult restoreRes = GceManager.remoteSshCommandExecution(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil(), Math.max(300000L, this.getDevice().getOptions().getGceCmdTimeout()), restoreCommand);
        if (!CommandStatus.SUCCESS.equals((Object)restoreRes.getStatus())) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SNAPSHOT_RESTORE_FAILURE_COUNT, 1L);
            LogUtil.CLog.e("%s", restoreRes.getStderr());
            throw new TargetSetupError("failed to restore device", this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_RESTORE_SNAPSHOT);
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_RESUME_DURATIONS, Long.toString(System.currentTimeMillis() - startTime));
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SNAPSHOT_RESTORE_SUCCESS_COUNT, 1L);
        return restoreRes;
    }

    public CommandResult stopGce(String user, Integer offset) throws TargetSetupError {
        String stopCommand;
        long startTime = System.currentTimeMillis();
        if (user == null) {
            user = this.getDevice().getOptions().getInstanceUser();
        }
        if ((stopCommand = this.commandBuilder("cvd stop", user, offset)).length() == 0) {
            throw new TargetSetupError("failed to set up stop command, invalid path", this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_STOP);
        }
        CommandResult stopRes = GceManager.remoteSshCommandExecution(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil(), Math.max(300000L, this.getDevice().getOptions().getGceCmdTimeout()), stopCommand);
        if (!CommandStatus.SUCCESS.equals((Object)stopRes.getStatus())) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_STOP_FAILURE_COUNT, 1L);
            LogUtil.CLog.e("%s", stopRes.getStderr());
            throw new TargetSetupError("failed to stop device", this.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_STOP);
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_STOP_DURATIONS, Long.toString(System.currentTimeMillis() - startTime));
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_STOP_SUCCESS_COUNT, 1L);
        return stopRes;
    }

    public List<File> getTombstones() {
        TestDeviceOptions.InstanceType type = this.getDevice().getOptions().getInstanceType();
        if (TestDeviceOptions.InstanceType.CUTTLEFISH.equals((Object)type) || TestDeviceOptions.InstanceType.REMOTE_NESTED_AVD.equals((Object)type)) {
            ArrayList<File> tombs = new ArrayList<File>();
            String remoteRuntimePath = String.format("/home/%s/cuttlefish_runtime/", this.getDevice().getOptions().getInstanceUser()) + "tombstones/*";
            File localDir = null;
            try {
                localDir = FileUtil.createTempDir("tombstones");
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
                return tombs;
            }
            if (!this.fetchRemoteDir(localDir, remoteRuntimePath)) {
                LogUtil.CLog.e("Failed to pull %s", remoteRuntimePath);
                FileUtil.recursiveDelete(localDir);
            } else {
                tombs.addAll(Arrays.asList(localDir.listFiles()));
                localDir.deleteOnExit();
            }
            return tombs;
        }
        return new ArrayList<File>();
    }

    @VisibleForTesting
    boolean fetchRemoteDir(File localDir, String remotePath) {
        return RemoteFileUtil.fetchRemoteDir(this.mGceAvd, this.getDevice().getOptions(), this.getRunUtil(), 300000L, remotePath, localDir);
    }

    public GceAvdInfo getAvdInfo() {
        return this.mGceAvd;
    }
}

