/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.connection;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.RemoteAndroidDevice;
import com.android.tradefed.device.connection.DefaultConnection;
import com.android.tradefed.device.internal.DeviceResetHandler;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;

public class AdbTcpConnection
extends DefaultConnection {
    protected static final long RETRY_INTERVAL_MS = 5000L;
    protected static final int MAX_RETRIES = 5;
    protected static final long DEFAULT_SHORT_CMD_TIMEOUT = 20000L;
    protected static final long WAIT_FOR_ADB_CONNECT = 120000L;
    private static final String ADB_SUCCESS_CONNECT_TAG = "connected to";
    private static final String ADB_ALREADY_CONNECTED_TAG = "already";
    private static final String ADB_CONN_REFUSED = "Connection refused";
    private File mAdbConnectLogs = null;

    public AdbTcpConnection(DefaultConnection.ConnectionBuilder builder) {
        super(builder);
    }

    public void setAdbLogFile(File adbLogFile) {
        this.mAdbConnectLogs = adbLogFile;
    }

    @Override
    public void tearDownConnection() {
        super.tearDownConnection();
        FileUtil.deleteFile(this.mAdbConnectLogs);
    }

    @Override
    public void reconnect(String serial) throws DeviceNotAvailableException {
        super.reconnect(serial);
        this.adbTcpConnect(this.getHostName(serial), this.getPortNum(serial));
        this.waitForAdbConnect(serial, 120000L);
    }

    @Override
    public void recoverVirtualDevice(ITestDevice device, DeviceNotAvailableException dnae) throws DeviceNotAvailableException {
        DeviceResetHandler recoveryHandler = new DeviceResetHandler();
        boolean recoverSuccess = recoveryHandler.resetDevice(device);
        if (!recoverSuccess) {
            throw new DeviceNotAvailableException(String.format("Failed to recover device: %s", device.getSerialNumber()), device.getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_RESET);
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_RECOVERED_FROM_DEVICE_RESET, 1L);
    }

    public boolean adbTcpConnect(String host, String port) {
        for (int i = 0; i < 5; ++i) {
            CommandResult result = this.adbConnect(host, port);
            if (CommandStatus.SUCCESS.equals((Object)result.getStatus()) && result.getStdout().contains(ADB_SUCCESS_CONNECT_TAG)) {
                LogUtil.CLog.d("adb connect output: status: %s stdout: %s", new Object[]{result.getStatus(), result.getStdout()});
                if (this.confirmAdbTcpConnect(host, port)) {
                    return true;
                }
            } else if (CommandStatus.SUCCESS.equals((Object)result.getStatus()) && result.getStdout().contains(ADB_CONN_REFUSED)) {
                return false;
            }
            LogUtil.CLog.d("adb connect output: status: %s stdout: %s stderr: %s, retrying.", new Object[]{result.getStatus(), result.getStdout(), result.getStderr()});
            this.getRunUtil().sleep((long)(i + 1) * 5000L);
        }
        return false;
    }

    protected void waitForAdbConnect(String serial, long waitTime) throws DeviceNotAvailableException {
        LogUtil.CLog.i("Waiting %d ms for adb connection.", waitTime);
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < waitTime) {
            if (this.confirmAdbTcpConnect(this.getHostName(serial), this.getPortNum(serial))) {
                LogUtil.CLog.d("Adb connection confirmed.");
                return;
            }
            this.getRunUtil().sleep(5000L);
        }
        throw new DeviceNotAvailableException(String.format("No adb connection after %sms.", waitTime), serial, (ErrorIdentifier)DeviceErrorIdentifier.FAILED_TO_CONNECT_TO_TCP_DEVICE);
    }

    private boolean confirmAdbTcpConnect(String host, String port) {
        CommandResult resultConfirmation = this.adbConnect(host, port);
        if (CommandStatus.SUCCESS.equals((Object)resultConfirmation.getStatus()) && resultConfirmation.getStdout().contains(ADB_ALREADY_CONNECTED_TAG)) {
            LogUtil.CLog.d("adb connect confirmed:\nstdout: %s\n", resultConfirmation.getStdout());
            return true;
        }
        LogUtil.CLog.d("adb connect confirmation failed:\nstatus:%s\nstdout: %s\nsterr: %s", new Object[]{resultConfirmation.getStatus(), resultConfirmation.getStdout(), resultConfirmation.getStderr()});
        return false;
    }

    private CommandResult adbConnect(String host, String port) {
        IRunUtil runUtil = this.getRunUtil();
        if (this.mAdbConnectLogs != null) {
            runUtil = new RunUtil();
            runUtil.setEnvVariable("ADB_TRACE", "1");
        }
        CommandResult result = runUtil.runTimedCmd(20000L, "adb", "connect", String.format("%s:%s", host, port));
        if (this.mAdbConnectLogs != null) {
            try {
                FileUtil.writeToFile(result.getStderr(), this.mAdbConnectLogs, true);
                FileUtil.writeToFile("\n======= SEPARATOR OF ATTEMPTS =====\n", this.mAdbConnectLogs, true);
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        }
        return result;
    }

    public boolean adbTcpDisconnect(String host, String port) {
        CommandResult result = this.getRunUtil().runTimedCmd(20000L, "adb", "disconnect", String.format("%s:%s", host, port));
        return CommandStatus.SUCCESS.equals((Object)result.getStatus());
    }

    public String getHostName(String serial) {
        if (!RemoteAndroidDevice.checkSerialFormatValid(serial)) {
            throw new RuntimeException(String.format("Serial Format is unexpected: %s should look like <hostname>:<port>", serial));
        }
        return serial.split(":")[0];
    }

    public String getPortNum(String serial) {
        if (!RemoteAndroidDevice.checkSerialFormatValid(serial)) {
            throw new RuntimeException(String.format("Serial Format is unexpected: %s should look like <hostname>:<port>", serial));
        }
        return serial.split(":")[1];
    }
}

