/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.connection;

import com.android.ddmlib.IDevice;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.IConfigurableVirtualDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.ManagedTestDeviceFactory;
import com.android.tradefed.device.NativeDevice;
import com.android.tradefed.device.NullDevice;
import com.android.tradefed.device.RemoteAndroidDevice;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.cloud.RemoteAndroidVirtualDevice;
import com.android.tradefed.device.connection.AbstractConnection;
import com.android.tradefed.device.connection.AdbSshConnection;
import com.android.tradefed.device.connection.AdbTcpConnection;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.MultiMap;

public class DefaultConnection
extends AbstractConnection {
    private final IRunUtil mRunUtil;
    private final ITestDevice mDevice;
    private final IBuildInfo mBuildInfo;
    private final MultiMap<String, String> mAttributes;
    private final String mInitialIpDevice;
    private final String mInitialUser;
    private final Integer mInitialDeviceNumOffset;
    private final String mInitialSerial;
    private final ITestLogger mTestLogger;
    private final boolean mTemporaryHolder;

    public static DefaultConnection createInopConnection(ConnectionBuilder builder) {
        return new DefaultConnection(builder);
    }

    public static DefaultConnection createConnection(ConnectionBuilder builder) {
        boolean isCuttlefish;
        ITestDevice device = builder.device;
        if (device == null) {
            return new DefaultConnection(builder);
        }
        TestDeviceOptions.InstanceType type = device.getOptions().getInstanceType();
        LogUtil.CLog.d("Instance type for connection: %s", new Object[]{type});
        boolean bl = isCuttlefish = type.equals((Object)TestDeviceOptions.InstanceType.CUTTLEFISH) || type.equals((Object)TestDeviceOptions.InstanceType.REMOTE_NESTED_AVD);
        if (device instanceof RemoteAndroidVirtualDevice) {
            ((NativeDevice)device).setFastbootEnabled(isCuttlefish);
            ((NativeDevice)device).setLogStartDelay(0);
            return new AdbSshConnection(builder);
        }
        if (device instanceof RemoteAndroidDevice) {
            return new AdbTcpConnection(builder);
        }
        LogUtil.CLog.d("Instance type for connection: %s", new Object[]{type});
        if (isCuttlefish) {
            if (ManagedTestDeviceFactory.isTcpDeviceSerial(device.getSerialNumber())) {
                return new AdbTcpConnection(builder);
            }
            ((NativeDevice)device).setLogStartDelay(0);
            return new AdbSshConnection(builder);
        }
        return new DefaultConnection(builder);
    }

    protected DefaultConnection(ConnectionBuilder builder) {
        this.mRunUtil = builder.runUtil;
        this.mDevice = builder.device;
        this.mBuildInfo = builder.buildInfo;
        this.mAttributes = builder.attributes;
        IDevice idevice = this.mDevice.getIDevice();
        this.mInitialSerial = this.mDevice.getSerialNumber();
        this.mTestLogger = builder.logger;
        if (idevice instanceof IConfigurableVirtualDevice) {
            this.mInitialIpDevice = ((IConfigurableVirtualDevice)((Object)idevice)).getKnownDeviceIp();
            this.mInitialUser = ((IConfigurableVirtualDevice)((Object)idevice)).getKnownUser();
            this.mInitialDeviceNumOffset = ((IConfigurableVirtualDevice)((Object)idevice)).getDeviceNumOffset();
        } else {
            this.mInitialIpDevice = null;
            this.mInitialUser = null;
            this.mInitialDeviceNumOffset = null;
        }
        this.mTemporaryHolder = idevice instanceof NullDevice ? ((NullDevice)idevice).isTemporary() : false;
    }

    protected IRunUtil getRunUtil() {
        return this.mRunUtil;
    }

    public final ITestDevice getDevice() {
        return this.mDevice;
    }

    public final IBuildInfo getBuildInfo() {
        return this.mBuildInfo;
    }

    public final MultiMap<String, String> getAttributes() {
        return this.mAttributes;
    }

    public String getInitialIp() {
        return this.mInitialIpDevice;
    }

    public String getInitialUser() {
        return this.mInitialUser;
    }

    public Integer getInitialDeviceNumOffset() {
        return this.mInitialDeviceNumOffset;
    }

    public String getInitialSerial() {
        return this.mInitialSerial;
    }

    public ITestLogger getLogger() {
        return this.mTestLogger;
    }

    public boolean wasTemporaryHolder() {
        return this.mTemporaryHolder;
    }

    public static class ConnectionBuilder {
        ITestDevice device;
        IBuildInfo buildInfo;
        MultiMap<String, String> attributes;
        IRunUtil runUtil;
        ITestLogger logger;
        GceAvdInfo existingAvdInfo;

        public ConnectionBuilder(IRunUtil runUtil, ITestDevice device, IBuildInfo buildInfo, ITestLogger logger) {
            this.runUtil = runUtil;
            this.device = device;
            this.buildInfo = buildInfo;
            this.logger = logger;
            this.attributes = new MultiMap();
        }

        public ConnectionBuilder addAttributes(MultiMap<String, String> attributes) {
            this.attributes.putAll(attributes);
            return this;
        }

        public ConnectionBuilder setExistingAvdInfo(GceAvdInfo info) {
            this.existingAvdInfo = info;
            return this;
        }
    }
}

