/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.contentprovider;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentProviderHandler {
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_ABSOLUTE_PATH = "absolute_path";
    public static final String COLUMN_DIRECTORY = "is_directory";
    public static final String COLUMN_MIME_TYPE = "mime_type";
    public static final String COLUMN_METADATA = "metadata";
    public static final String QUERY_INFO_VALUE = "INFO";
    public static final String NO_RESULTS_STRING = "No result found.";
    public static final String[] COLUMNS = new String[]{"name", "absolute_path", "is_directory", "mime_type", "metadata"};
    public static final String PACKAGE_NAME = "android.tradefed.contentprovider";
    public static final String CONTENT_PROVIDER_URI = "content://android.tradefed.contentprovider";
    private static final String APK_NAME = "TradefedContentProvider.apk";
    private static final String CONTENT_PROVIDER_APK_RES = "/TradefedContentProvider.apk";
    private static final String CONTENT_PROVIDER_APK_RES_FALLBACK = "/android/tradefed/contentprovider/TradefedContentProvider.apk";
    private static final String PROPERTY_RESULT = "LEGACY_STORAGE: allow";
    private static final String ERROR_MESSAGE_TAG = "[ERROR]";
    private static final String ERROR_PROVIDER_NOT_INSTALLED = "Could not find provider: android.tradefed.contentprovider";
    private ITestDevice mDevice;
    private File mContentProviderApk = null;
    private boolean mReportNotFound = false;

    public ContentProviderHandler(ITestDevice device) {
        this.mDevice = device;
    }

    public boolean contentProviderNotFound() {
        return this.mReportNotFound;
    }

    public boolean setUp() throws DeviceNotAvailableException {
        String output;
        if (this.mDevice.isPackageInstalled(PACKAGE_NAME, Integer.toString(this.mDevice.getCurrentUser()))) {
            this.mReportNotFound = false;
            return true;
        }
        if (this.mContentProviderApk == null || !this.mContentProviderApk.exists()) {
            try {
                this.mContentProviderApk = this.extractResourceApk();
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
                return false;
            }
        }
        if ((output = this.mDevice.installPackage(this.mContentProviderApk, true, true, new String[0])) != null) {
            LogUtil.CLog.e("Something went wrong while installing the content provider apk: %s", output);
            FileUtil.deleteFile(this.mContentProviderApk);
            return false;
        }
        CommandResult setResult = this.mDevice.executeShellV2Command(String.format("cmd appops set %s android:legacy_storage allow", PACKAGE_NAME));
        if (!CommandStatus.SUCCESS.equals((Object)setResult.getStatus())) {
            LogUtil.CLog.e("Failed to set legacy_storage. Stdout: %s\nstderr: %s", setResult.getStdout(), setResult.getStderr());
            FileUtil.deleteFile(this.mContentProviderApk);
            return false;
        }
        CommandResult appOpsResult = this.mDevice.executeShellV2Command(String.format("cmd appops get %s", PACKAGE_NAME));
        if (CommandStatus.SUCCESS.equals((Object)appOpsResult.getStatus()) && appOpsResult.getStdout().contains(PROPERTY_RESULT)) {
            this.mReportNotFound = false;
            return true;
        }
        LogUtil.CLog.e("Failed to get legacy_storage. Stdout: %s\nstderr: %s", appOpsResult.getStdout(), appOpsResult.getStderr());
        FileUtil.deleteFile(this.mContentProviderApk);
        return false;
    }

    public void tearDown() throws DeviceNotAvailableException {
        FileUtil.deleteFile(this.mContentProviderApk);
        this.mDevice.uninstallPackage(PACKAGE_NAME);
    }

    public boolean deleteFile(String deviceFilePath) throws DeviceNotAvailableException {
        String contentUri = ContentProviderHandler.createEscapedContentUri(deviceFilePath);
        String deleteCommand = String.format("content delete --user %d --uri %s", this.mDevice.getCurrentUser(), contentUri);
        CommandResult deleteResult = this.mDevice.executeShellV2Command(deleteCommand);
        if (this.isSuccessful(deleteResult)) {
            return true;
        }
        LogUtil.CLog.e("Failed to remove a file at %s using content provider. Error: '%s'", deviceFilePath, deleteResult.getStderr());
        return false;
    }

    public boolean pullDir(String deviceFilePath, File localDir) throws DeviceNotAvailableException {
        return this.pullDirInternal(deviceFilePath, localDir, null);
    }

    public boolean pullFile(String deviceFilePath, File localFile) throws DeviceNotAvailableException {
        return this.pullFileInternal(deviceFilePath, localFile, null);
    }

    public boolean pushFile(File fileToPush, String deviceFilePath) throws DeviceNotAvailableException, IllegalArgumentException {
        if (!fileToPush.exists()) {
            LogUtil.CLog.w("File '%s' to push does not exist.", fileToPush);
            return false;
        }
        if (fileToPush.isDirectory()) {
            LogUtil.CLog.w("'%s' is not a file but a directory, can't use #pushFile on it.", fileToPush);
            return false;
        }
        Integer currentUser = this.mDevice.getCurrentUser();
        boolean res = this.pushFileInternal(fileToPush, deviceFilePath, currentUser);
        if (!res && this.mReportNotFound) {
            boolean installed = this.setUp();
            if (!installed) {
                return false;
            }
            res = this.pushFileInternal(fileToPush, deviceFilePath, currentUser);
        }
        return res;
    }

    public boolean pushDir(File localFileDir, String deviceFilePath, Set<String> excludedDirectories) throws DeviceNotAvailableException {
        return this.pushDirInternal(localFileDir, deviceFilePath, excludedDirectories, this.mDevice.getCurrentUser());
    }

    public boolean doesFileExist(String deviceFilePath) throws DeviceNotAvailableException {
        String contentUri = ContentProviderHandler.createEscapedContentUri(deviceFilePath);
        String queryContentCommand = String.format("content query --user %d --uri %s", this.mDevice.getCurrentUser(), contentUri);
        String listCommandResult = this.mDevice.executeShellCommand(queryContentCommand);
        return !NO_RESULTS_STRING.equals(listCommandResult.trim());
    }

    private boolean isSuccessful(CommandResult result) {
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            return false;
        }
        String stdout = result.getStdout();
        if (stdout.contains(ERROR_MESSAGE_TAG)) {
            return false;
        }
        String stderr = result.getStderr();
        if (stderr != null && stderr.contains(ERROR_PROVIDER_NOT_INSTALLED)) {
            this.mReportNotFound = true;
        }
        return Strings.isNullOrEmpty(stderr);
    }

    private File extractResourceApk() throws IOException {
        File apkTempFile = FileUtil.createTempFile(APK_NAME, ".apk");
        try {
            InputStream apkStream = ContentProviderHandler.class.getResourceAsStream(CONTENT_PROVIDER_APK_RES);
            FileUtil.writeToFile(apkStream, apkTempFile);
        }
        catch (IOException e) {
            InputStream apkStream = ContentProviderHandler.class.getResourceAsStream(CONTENT_PROVIDER_APK_RES_FALLBACK);
            FileUtil.writeToFile(apkStream, apkTempFile);
        }
        return apkTempFile;
    }

    public static String createEscapedContentUri(String deviceFilePath) {
        String escapedFilePath = deviceFilePath;
        try {
            String encoded = URLEncoder.encode(deviceFilePath, "UTF-8");
            escapedFilePath = UrlEscapers.urlPathSegmentEscaper().escape(encoded);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.CLog.e(e);
        }
        return String.format("\"%s/%s\"", CONTENT_PROVIDER_URI, escapedFilePath);
    }

    @VisibleForTesting
    final HashMap<String, String> parseQueryResultRow(String row) {
        HashMap<String, String> columnValues = new HashMap<String, String>();
        StringJoiner pattern = new StringJoiner(", ");
        for (int i = 0; i < COLUMNS.length; ++i) {
            pattern.add(String.format("(%s=.*)", COLUMNS[i]));
        }
        Pattern p = Pattern.compile(pattern.toString());
        Matcher m = p.matcher(row);
        if (m.find()) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                String[] keyValue = m.group(i).split("=");
                if (keyValue.length != 2) continue;
                columnValues.put(keyValue[0], keyValue[1]);
            }
        }
        return columnValues;
    }

    private boolean pullDirInternal(String deviceFilePath, File localDir, Integer currentUser) throws DeviceNotAvailableException {
        String[] listResult;
        String queryContentCommand;
        String listCommandResult;
        if (!localDir.isDirectory()) {
            LogUtil.CLog.e("Local path %s is not a directory", localDir.getAbsolutePath());
            return false;
        }
        String contentUri = ContentProviderHandler.createEscapedContentUri(deviceFilePath);
        if (currentUser == null) {
            currentUser = this.mDevice.getCurrentUser();
        }
        if (NO_RESULTS_STRING.equals((listCommandResult = this.mDevice.executeShellCommand(queryContentCommand = String.format("content query --user %d --uri %s", currentUser, contentUri))).trim())) {
            return true;
        }
        LogUtil.CLog.d("Received from content provider:\n%s", listCommandResult);
        for (String row : listResult = listCommandResult.split("[\\r\\n]+")) {
            HashMap<String, String> columnValues = this.parseQueryResultRow(row);
            boolean isDirectory = Boolean.valueOf(columnValues.get(COLUMN_DIRECTORY));
            String name = columnValues.get(COLUMN_NAME);
            if (name == null) {
                LogUtil.CLog.w("Output from the content provider doesn't seem well formatted:\n%s", row);
                return false;
            }
            String path = columnValues.get(COLUMN_ABSOLUTE_PATH);
            File localChild = new File(localDir, name);
            if (isDirectory) {
                if (!localChild.mkdir()) {
                    LogUtil.CLog.w("Failed to create sub directory %s, aborting.", localChild.getAbsolutePath());
                    return false;
                }
                if (this.pullDirInternal(path, localChild, currentUser)) continue;
                LogUtil.CLog.w("Failed to pull sub directory %s from device, aborting", path);
                return false;
            }
            if (this.pullFileInternal(path, localChild, currentUser)) continue;
            LogUtil.CLog.w("Failed to pull file %s from device, aborting", path);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pullFileInternal(String deviceFilePath, File localFile, Integer currentUser) throws DeviceNotAvailableException {
        FileOutputStream localFileStream;
        String contentUri = ContentProviderHandler.createEscapedContentUri(deviceFilePath);
        if (currentUser == null) {
            currentUser = this.mDevice.getCurrentUser();
        }
        String pullCommand = String.format("content read --user %d --uri %s", currentUser, contentUri);
        try {
            localFileStream = new FileOutputStream(localFile);
        }
        catch (FileNotFoundException e) {
            LogUtil.CLog.e("Failed to open OutputStream to the local file. Error: %s", e.getMessage());
            return false;
        }
        try {
            CommandResult pullResult = this.mDevice.executeShellV2Command(pullCommand, localFileStream);
            if (this.isSuccessful(pullResult)) {
                boolean bl = true;
                return bl;
            }
            String stderr = pullResult.getStderr();
            LogUtil.CLog.e("Failed to pull a file at '%s' to %s using content provider. Error: '%s'", deviceFilePath, localFile, stderr);
            if (stderr.contains(ERROR_PROVIDER_NOT_INSTALLED)) {
                this.mReportNotFound = true;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            StreamUtil.close(localFileStream);
        }
    }

    private boolean pushFileInternal(File fileToPush, String deviceFilePath, Integer currentUser) throws DeviceNotAvailableException {
        if (currentUser == null) {
            currentUser = this.mDevice.getCurrentUser();
        }
        String contentUri = ContentProviderHandler.createEscapedContentUri(deviceFilePath);
        String pushCommand = String.format("content write --user %d --uri %s", currentUser, contentUri);
        CommandResult pushResult = this.mDevice.executeShellV2Command(pushCommand, fileToPush);
        if (this.isSuccessful(pushResult)) {
            return true;
        }
        LogUtil.CLog.e("Failed to push a file '%s' at %s using content provider. Error: '%s'", fileToPush, deviceFilePath, pushResult.getStderr());
        return false;
    }

    private boolean pushDirInternal(File localFileDir, String deviceFilePath, Set<String> excludedDirectories, Integer currentUser) throws DeviceNotAvailableException {
        File[] childFiles = localFileDir.listFiles();
        if (childFiles == null) {
            LogUtil.CLog.e("Could not read files in %s", localFileDir.getAbsolutePath());
            return false;
        }
        if (currentUser == null) {
            currentUser = this.mDevice.getCurrentUser();
        }
        for (File childFile : childFiles) {
            String remotePath = String.format("%s/%s", deviceFilePath, childFile.getName());
            if (childFile.isDirectory()) {
                if (excludedDirectories.contains(childFile.getName())) {
                    LogUtil.CLog.d("%s directory was not pushed because it was filtered.", childFile.getAbsolutePath());
                    continue;
                }
                this.mDevice.executeShellCommand(String.format("mkdir -p \"%s\"", remotePath));
                if (this.pushDirInternal(childFile, remotePath, excludedDirectories, currentUser)) continue;
                return false;
            }
            if (!childFile.isFile() || this.pushFileInternal(childFile, remotePath, currentUser)) continue;
            return false;
        }
        return true;
    }
}

