/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.helper;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.ddmlib.DefaultRemoteAndroidTestRunner;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ResourceUtil;
import java.io.File;
import java.io.IOException;

public class TelephonyHelper {
    private static final String TELEPHONY_UTIL_APK_NAME = "TelephonyUtility.apk";
    private static final String TELEPHONY_APK_RES_PATH = "/";
    private static final String TELEPHONY_APK_RES_PATH_FALLBACK = "/android/telephony/utility/";
    public static final String PACKAGE_NAME = "android.telephony.utility";
    private static final String CLASS_NAME = ".SimCardUtil";
    private static final String METHOD_NAME = "getSimCardInformation";
    private static final String AJUR_RUNNER = "androidx.test.runner.AndroidJUnitRunner";
    public static final String SIM_STATE_KEY = "sim_state";
    public static final String CARRIER_PRIVILEGES_KEY = "has_carried_privileges";
    public static final String SECURED_ELEMENT_KEY = "has_secured_element";
    public static final String SE_SERVICE_KEY = "has_se_service";
    public static final TestDescription SIM_TEST = new TestDescription("android.telephony.utility.SimCardUtil", "getSimCardInformation");

    private TelephonyHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimCardInformation getSimInfo(ITestDevice device) throws DeviceNotAvailableException {
        File apkFile = null;
        boolean wasInstalled = false;
        try {
            apkFile = TelephonyHelper.extractTelephonyUtilApk();
            if (apkFile == null) {
                SimCardInformation simCardInformation = null;
                return simCardInformation;
            }
            String error = device.installPackage(apkFile, true, new String[0]);
            if (error != null) {
                LogUtil.CLog.e(error);
                SimCardInformation simCardInformation = null;
                return simCardInformation;
            }
            wasInstalled = true;
            CollectingTestListener listener = new CollectingTestListener();
            IRemoteAndroidTestRunner runner = TelephonyHelper.createTestRunner(device.getIDevice());
            runner.setMethodName("android.telephony.utility.SimCardUtil", METHOD_NAME);
            device.runInstrumentationTests(runner, listener);
            TestRunResult runResult = listener.getCurrentRunResults();
            if (!runResult.isRunComplete()) {
                LogUtil.CLog.e("Run did not complete.");
                SimCardInformation simCardInformation = null;
                return simCardInformation;
            }
            if (runResult.isRunFailure()) {
                LogUtil.CLog.e("TelephonyHelper run failure: %s", runResult.getRunFailureMessage());
                SimCardInformation simCardInformation = null;
                return simCardInformation;
            }
            TestResult testResult = runResult.getTestResults().get(SIM_TEST);
            if (testResult == null) {
                LogUtil.CLog.e("getSimCardInformation did not run");
                SimCardInformation simCardInformation = null;
                return simCardInformation;
            }
            SimCardInformation info = new SimCardInformation();
            info.mHasTelephonySupport = !TestResult.TestStatus.FAILURE.equals((Object)testResult.getStatus());
            info.mSimState = testResult.getMetrics().get(SIM_STATE_KEY);
            info.mCarrierPrivileges = TelephonyHelper.stringToBool(testResult.getMetrics().get(CARRIER_PRIVILEGES_KEY));
            info.mHasSecuredElement = TelephonyHelper.stringToBool(testResult.getMetrics().get(SECURED_ELEMENT_KEY));
            info.mHasSeService = TelephonyHelper.stringToBool(testResult.getMetrics().get(SE_SERVICE_KEY));
            LogUtil.CLog.d("%s", info);
            SimCardInformation simCardInformation = info;
            return simCardInformation;
        }
        finally {
            FileUtil.deleteFile(apkFile);
            if (wasInstalled) {
                device.uninstallPackage(PACKAGE_NAME);
            }
        }
    }

    private static File extractTelephonyUtilApk() {
        File apkTempFile = null;
        try {
            apkTempFile = FileUtil.createTempFile(TELEPHONY_UTIL_APK_NAME, ".apk");
            boolean res = ResourceUtil.extractResourceWithAltAsFile("/TelephonyUtility.apk", "/android/telephony/utility/TelephonyUtility.apk", apkTempFile);
            if (!res) {
                FileUtil.deleteFile(apkTempFile);
                LogUtil.CLog.e("Failed to extract telephony util apk.");
                return null;
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            FileUtil.deleteFile(apkTempFile);
            return null;
        }
        return apkTempFile;
    }

    private static IRemoteAndroidTestRunner createTestRunner(IDevice idevice) {
        return new DefaultRemoteAndroidTestRunner(PACKAGE_NAME, AJUR_RUNNER, idevice);
    }

    private static boolean stringToBool(String boolString) {
        if (boolString == null) {
            return false;
        }
        return Boolean.parseBoolean(boolString);
    }

    public static class SimCardInformation {
        public boolean mHasTelephonySupport;
        public String mSimState;
        public boolean mCarrierPrivileges;
        public boolean mHasSecuredElement;
        public boolean mHasSeService;

        public String toString() {
            return "SimCardInformation [mHasTelephonySupport=" + this.mHasTelephonySupport + ", mSimState=" + this.mSimState + ", mCarrierPrivileges=" + this.mCarrierPrivileges + ", mHasSecuredElement=" + this.mHasSecuredElement + ", mHasSeService=" + this.mHasSeService + "]";
        }
    }
}

