/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.internal;

import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.device.FreeDeviceState;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.service.TradefedFeatureClient;
import com.google.common.annotations.VisibleForTesting;
import com.proto.tradefed.feature.FeatureResponse;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DeviceReleaseReporter
implements ICommandScheduler.IScheduledInvocationListener {
    private final TradefedFeatureClient mTradefedFeatureClient;

    public DeviceReleaseReporter() {
        this(new TradefedFeatureClient());
    }

    @VisibleForTesting
    DeviceReleaseReporter(TradefedFeatureClient featureClient) {
        this.mTradefedFeatureClient = featureClient;
    }

    @Override
    public void invocationInitiated(IInvocationContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseDevices(IInvocationContext context, Map<ITestDevice, FreeDeviceState> devicesStates) {
        try {
            LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
            for (Map.Entry<ITestDevice, FreeDeviceState> entry : devicesStates.entrySet()) {
                args.put(context.getDeviceName(entry.getKey()), entry.getValue().name());
            }
            FeatureResponse response = this.mTradefedFeatureClient.triggerFeature("earlyDeviceRelease", args);
            if (response.hasErrorInfo()) {
                LogUtil.CLog.e("Feature Response Error: " + response.getErrorInfo());
                return;
            }
        }
        finally {
            this.mTradefedFeatureClient.close();
        }
    }

    @Override
    public void invocationComplete(IInvocationContext iInvocationContext, Map<ITestDevice, FreeDeviceState> map) {
    }
}

