/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.internal;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.RemoteAndroidDevice;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.cloud.NestedRemoteDevice;
import com.android.tradefed.device.cloud.RemoteAndroidVirtualDevice;
import com.android.tradefed.device.connection.AbstractConnection;
import com.android.tradefed.device.connection.AdbSshConnection;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.service.IRemoteFeature;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.ITestInformationReceiver;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.SerializationUtil;
import com.proto.tradefed.feature.ErrorInfo;
import com.proto.tradefed.feature.FeatureRequest;
import com.proto.tradefed.feature.FeatureResponse;
import java.io.IOException;

public class DeviceResetFeature
implements IRemoteFeature,
IConfigurationReceiver,
ITestInformationReceiver {
    public static final String DEVICE_RESET_FEATURE_NAME = "resetDevice";
    public static final String DEVICE_NAME = "device_name";
    private IConfiguration mConfig;
    private TestInformation mTestInformation;

    @Override
    public String getName() {
        return DEVICE_RESET_FEATURE_NAME;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    @Override
    public void setTestInformation(TestInformation testInformation) {
        this.mTestInformation = testInformation;
    }

    @Override
    public TestInformation getTestInformation() {
        return this.mTestInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureResponse execute(FeatureRequest request) {
        FeatureResponse.Builder responseBuilder = FeatureResponse.newBuilder();
        String deviceName = request.getArgsMap().get(DEVICE_NAME);
        if (deviceName == null) {
            responseBuilder.setErrorInfo(ErrorInfo.newBuilder().setErrorTrace("No device_name args specified."));
            return responseBuilder.build();
        }
        IDeviceConfiguration configHolder = this.mConfig.getDeviceConfigByName(deviceName);
        int index = 0;
        for (IDeviceConfiguration deviceConfig : this.mConfig.getDeviceConfig()) {
            if (deviceConfig == configHolder) break;
            ++index;
        }
        String response = String.format("Attempting device reset on %s (%s).", this.mTestInformation.getDevice().getSerialNumber(), this.mTestInformation.getDevice().getClass().getSimpleName());
        try {
            boolean res;
            this.mTestInformation.setActiveDeviceIndex(index);
            AbstractConnection connection = this.mTestInformation.getDevice().getConnection();
            if (this.mTestInformation.getDevice() instanceof RemoteAndroidVirtualDevice || connection instanceof AdbSshConnection) {
                GceAvdInfo info = this.getAvdInfo(this.mTestInformation.getDevice(), connection);
                if (info == null) {
                    throw new RuntimeException("GceAvdInfo was null. skipping");
                }
                Integer offset = info.getDeviceOffset();
                String user = info.getInstanceUser();
                long startTime = System.currentTimeMillis();
                CommandResult powerwashResult = this.powerwash(connection, user, offset);
                if (!CommandStatus.SUCCESS.equals((Object)powerwashResult.getStatus())) {
                    throw new DeviceNotAvailableException(String.format("Failed to powerwash device: %s. status:%s\nstdout: %s\nstderr:%s", new Object[]{this.mTestInformation.getDevice().getSerialNumber(), powerwashResult.getStatus(), powerwashResult.getStdout(), powerwashResult.getStderr()}), this.mTestInformation.getDevice().getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_RESET);
                }
                response = response + String.format(" Powerwash finished in %d ms.", System.currentTimeMillis() - startTime);
            } else if (this.mTestInformation.getDevice() instanceof RemoteAndroidDevice) {
                response = response + " RemoteAndroidDevice has no powerwash support.";
            } else if (this.mTestInformation.getDevice() instanceof NestedRemoteDevice && !(res = ((NestedRemoteDevice)this.mTestInformation.getDevice()).resetVirtualDevice())) {
                throw new DeviceNotAvailableException(String.format("Failed to powerwash device: %s", this.mTestInformation.getDevice().getSerialNumber()), this.mTestInformation.getDevice().getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_RESET);
            }
            for (ITargetPreparer labPreparer : configHolder.getLabPreparers()) {
                if (labPreparer.isDisabled()) continue;
                labPreparer.setUp(this.mTestInformation);
            }
            for (ITargetPreparer preparer : configHolder.getTargetPreparers()) {
                if (preparer.isDisabled()) continue;
                preparer.setUp(this.mTestInformation);
            }
        }
        catch (Exception e) {
            String error = "Failed to setup after reset device.";
            try {
                error = SerializationUtil.serializeToString(e);
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
            responseBuilder.setErrorInfo(ErrorInfo.newBuilder().setErrorTrace(error));
        }
        finally {
            this.mTestInformation.setActiveDeviceIndex(0);
        }
        responseBuilder.setResponse(response);
        return responseBuilder.build();
    }

    private GceAvdInfo getAvdInfo(ITestDevice device, AbstractConnection connection) {
        if (connection instanceof AdbSshConnection) {
            return ((AdbSshConnection)connection).getAvdInfo();
        }
        return null;
    }

    private CommandResult powerwash(AbstractConnection connection, String user, Integer offset) throws TargetSetupError {
        if (connection instanceof AdbSshConnection) {
            return ((AdbSshConnection)connection).powerwashGce(user, offset);
        }
        return new CommandResult(CommandStatus.EXCEPTION);
    }
}

