/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.internal;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.RemoteAndroidDevice;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.cloud.NestedRemoteDevice;
import com.android.tradefed.device.cloud.RemoteAndroidVirtualDevice;
import com.android.tradefed.device.connection.AbstractConnection;
import com.android.tradefed.device.connection.AdbSshConnection;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.service.IRemoteFeature;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.ITestInformationReceiver;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.SerializationUtil;
import com.proto.tradefed.feature.ErrorInfo;
import com.proto.tradefed.feature.FeatureRequest;
import com.proto.tradefed.feature.FeatureResponse;
import java.io.IOException;

public class DeviceSnapshotFeature
implements IRemoteFeature,
IConfigurationReceiver,
ITestInformationReceiver {
    public static final String DEVICE_SNAPSHOT_FEATURE_NAME = "snapshotDevice";
    public static final String DEVICE_NAME = "device_name";
    public static final String SNAPSHOT_ID = "snapshot_id";
    public static final String RESTORE_FLAG = "restore_flag";
    private IConfiguration mConfig;
    private TestInformation mTestInformation;

    @Override
    public String getName() {
        return DEVICE_SNAPSHOT_FEATURE_NAME;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    @Override
    public void setTestInformation(TestInformation testInformation) {
        this.mTestInformation = testInformation;
    }

    @Override
    public TestInformation getTestInformation() {
        return this.mTestInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureResponse execute(FeatureRequest request) {
        FeatureResponse.Builder responseBuilder = FeatureResponse.newBuilder();
        String deviceName = request.getArgsMap().get(DEVICE_NAME);
        if (deviceName == null) {
            responseBuilder.setErrorInfo(ErrorInfo.newBuilder().setErrorTrace("No device_name args specified."));
            return responseBuilder.build();
        }
        IDeviceConfiguration configHolder = this.mConfig.getDeviceConfigByName(deviceName);
        int index = 0;
        for (IDeviceConfiguration deviceConfig : this.mConfig.getDeviceConfig()) {
            if (deviceConfig == configHolder) break;
            ++index;
        }
        try {
            this.mTestInformation.setActiveDeviceIndex(index);
            AbstractConnection connection = this.mTestInformation.getDevice().getConnection();
            if (this.mTestInformation.getDevice() instanceof RemoteAndroidVirtualDevice || connection instanceof AdbSshConnection) {
                GceAvdInfo info = this.getAvdInfo(this.mTestInformation.getDevice(), connection);
                if (info == null) {
                    throw new RuntimeException("GceAvdInfo was null. skipping");
                }
                Integer offset = info.getDeviceOffset();
                String user = info.getInstanceUser();
                String snapshotId = request.getArgsMap().get(SNAPSHOT_ID);
                boolean restoreFlag = Boolean.parseBoolean(request.getArgsMap().get(RESTORE_FLAG));
                if (restoreFlag) {
                    this.restoreSnapshot(responseBuilder, connection, user, offset, snapshotId);
                } else {
                    this.snapshot(responseBuilder, connection, user, offset, snapshotId);
                }
            } else if (this.mTestInformation.getDevice() instanceof RemoteAndroidDevice) {
                responseBuilder.setResponse(" RemoteAndroidDevice has no snapshot support.");
            } else if (this.mTestInformation.getDevice() instanceof NestedRemoteDevice) {
                responseBuilder.setResponse(" NestedRemoteDevice has no snapshot support.");
            }
        }
        catch (Exception e) {
            String error = "Failed to snapshot device.";
            try {
                error = SerializationUtil.serializeToString(e);
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
            responseBuilder.setErrorInfo(ErrorInfo.newBuilder().setErrorTrace(error));
        }
        finally {
            this.mTestInformation.setActiveDeviceIndex(0);
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshot(FeatureResponse.Builder responseBuilder, AbstractConnection connection, String user, int offset, String snapshotId) throws DeviceNotAvailableException, TargetSetupError {
        String response = String.format("Attempting snapshot device on %s (%s).", this.mTestInformation.getDevice().getSerialNumber(), this.mTestInformation.getDevice().getClass().getSimpleName());
        try {
            long startTime = System.currentTimeMillis();
            CommandResult result = ((AdbSshConnection)connection).snapshotGce(user, offset, snapshotId);
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                throw new DeviceNotAvailableException(String.format("Failed to snapshot device: %s. status:%s\nstdout: %s\nstderr:%s", new Object[]{this.mTestInformation.getDevice().getSerialNumber(), result.getStatus(), result.getStdout(), result.getStderr()}), this.mTestInformation.getDevice().getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_SNAPSHOT);
            }
            response = response + String.format(" Snapshot finished in %d ms.", System.currentTimeMillis() - startTime);
        }
        finally {
            responseBuilder.setResponse(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSnapshot(FeatureResponse.Builder responseBuilder, AbstractConnection connection, String user, int offset, String snapshotId) throws DeviceNotAvailableException, TargetSetupError {
        String response = String.format("Attempting restore device snapshot on %s (%s) to %s.", this.mTestInformation.getDevice().getSerialNumber(), this.mTestInformation.getDevice().getClass().getSimpleName(), snapshotId);
        try {
            long startTime = System.currentTimeMillis();
            CommandResult result = ((AdbSshConnection)connection).restoreSnapshotGce(user, offset, snapshotId);
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                throw new DeviceNotAvailableException(String.format("Failed to restore snapshot on device: %s. status:%s\nstdout: %s\nstderr:%s", new Object[]{this.mTestInformation.getDevice().getSerialNumber(), result.getStatus(), result.getStdout(), result.getStderr()}), this.mTestInformation.getDevice().getSerialNumber(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_FAILED_TO_SNAPSHOT);
            }
            response = response + String.format(" Restoring snapshot finished in %d ms.", System.currentTimeMillis() - startTime);
        }
        finally {
            responseBuilder.setResponse(response);
        }
    }

    private GceAvdInfo getAvdInfo(ITestDevice device, AbstractConnection connection) {
        if (connection instanceof AdbSshConnection) {
            return ((AdbSshConnection)connection).getAvdInfo();
        }
        if (device instanceof RemoteAndroidVirtualDevice) {
            return ((RemoteAndroidVirtualDevice)device).getAvdInfo();
        }
        return null;
    }

    private CommandResult snapshotGce(AbstractConnection connection, String user, Integer offset, String snapshotId) throws TargetSetupError {
        if (connection instanceof AdbSshConnection) {
            return ((AdbSshConnection)connection).snapshotGce(user, offset, snapshotId);
        }
        return new CommandResult(CommandStatus.EXCEPTION);
    }
}

