/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.internal;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NativeDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.service.TradefedFeatureClient;
import com.android.tradefed.util.SerializationUtil;
import com.proto.tradefed.feature.FeatureResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceSnapshotHandler {
    private final TradefedFeatureClient mClient;
    private final IInvocationContext mContext;

    public DeviceSnapshotHandler(IInvocationContext context) {
        this(new TradefedFeatureClient(), context);
    }

    DeviceSnapshotHandler(TradefedFeatureClient client, IInvocationContext context) {
        this.mClient = client;
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean snapshotDevice(ITestDevice device, String snapshotId) throws DeviceNotAvailableException {
        FeatureResponse response;
        if (device.getIDevice() instanceof StubDevice) {
            LogUtil.CLog.d("Device '%s' is a stub device. skipping snapshot.", device.getSerialNumber());
            return true;
        }
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("device_name", this.mContext.getDeviceName(device));
            args.put("snapshot_id", snapshotId);
            response = this.mClient.triggerFeature("snapshotDevice", args);
            LogUtil.CLog.d("Response from snapshot request: %s", response.getResponse());
        }
        finally {
            this.mClient.close();
        }
        if (response.hasErrorInfo()) {
            String trace = response.getErrorInfo().getErrorTrace();
            Object o = null;
            try {
                o = SerializationUtil.deserialize(trace);
            }
            catch (IOException | RuntimeException e) {
                LogUtil.CLog.e(e);
            }
            if (o instanceof DeviceNotAvailableException) {
                throw (DeviceNotAvailableException)o;
            }
            if (o instanceof IHarnessException) {
                IHarnessException exception = (IHarnessException)o;
                throw new HarnessRuntimeException("Exception while snapshotting the device.", exception);
            }
            if (o instanceof Exception) {
                throw new HarnessRuntimeException("Exception while snapshotting the device.", (Exception)o, InfraErrorIdentifier.UNDETERMINED);
            }
            LogUtil.CLog.e("Snapshot failed: %s", response.getErrorInfo().getErrorTrace());
            return false;
        }
        Pattern durationPattern = Pattern.compile("Snapshot\\sfinished\\sin (\\d+)\\sms");
        Matcher matcher = durationPattern.matcher(response.getResponse());
        if (matcher.find()) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SNAPSHOT_SUCCESS_COUNT, 1L);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SNAPSHOT_DURATIONS, matcher.group(1));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restoreSnapshotDevice(ITestDevice device, String snapshotId) throws DeviceNotAvailableException {
        FeatureResponse response;
        if (device.getIDevice() instanceof StubDevice) {
            LogUtil.CLog.d("Device '%s' is a stub device. skipping restoring snapshot.", device.getSerialNumber());
            return true;
        }
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("snapshot_id", snapshotId);
            args.put("restore_flag", "true");
            args.put("device_name", this.mContext.getDeviceName(device));
            response = this.mClient.triggerFeature("snapshotDevice", args);
            LogUtil.CLog.d("Response from restoring snapshot(%s) request: %s", snapshotId, response.getResponse());
        }
        finally {
            this.mClient.close();
        }
        if (response.hasErrorInfo()) {
            String trace = response.getErrorInfo().getErrorTrace();
            Object o = null;
            try {
                o = SerializationUtil.deserialize(trace);
            }
            catch (IOException | RuntimeException e) {
                LogUtil.CLog.e(e);
            }
            if (o instanceof DeviceNotAvailableException) {
                throw (DeviceNotAvailableException)o;
            }
            if (o instanceof IHarnessException) {
                IHarnessException exception = (IHarnessException)o;
                throw new HarnessRuntimeException("Exception while restoring snapshot of the device.", exception);
            }
            if (o instanceof Exception) {
                throw new HarnessRuntimeException("Exception while restoring snapshot of the device.", (Exception)o, InfraErrorIdentifier.UNDETERMINED);
            }
            LogUtil.CLog.e("Restoring snapshot failed: %s", response.getErrorInfo().getErrorTrace());
            return false;
        }
        if (device instanceof NativeDevice) {
            ((NativeDevice)device).resetContentProviderSetup();
        }
        CurrentInvocation.setModuleIsolation(CurrentInvocation.IsolationGrade.FULLY_ISOLATED);
        CurrentInvocation.setRunIsolation(CurrentInvocation.IsolationGrade.FULLY_ISOLATED);
        Pattern durationPattern = Pattern.compile("Restoring snapshot\\sfinished\\sin (\\d+)\\sms");
        Matcher matcher = durationPattern.matcher(response.getResponse());
        if (matcher.find()) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SNAPSHOT_RESTORE_SUCCESS_COUNT, 1L);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEVICE_SNAPSHOT_RESTORE_DURATIONS, matcher.group(1));
        }
        return true;
    }
}

