/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.internal;

import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.device.FreeDeviceState;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.service.internal.IRemoteScheduledListenersFeature;
import com.android.tradefed.testtype.ITestInformationReceiver;
import com.proto.tradefed.feature.FeatureRequest;
import com.proto.tradefed.feature.FeatureResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EarlyDeviceReleaseFeature
implements ITestInformationReceiver,
IRemoteScheduledListenersFeature {
    public static final String EARLY_DEVICE_RELEASE_FEATURE_NAME = "earlyDeviceRelease";
    private TestInformation mTestInformation;
    private List<ICommandScheduler.IScheduledInvocationListener> mScheduledInvocationListeners;

    @Override
    public String getName() {
        return EARLY_DEVICE_RELEASE_FEATURE_NAME;
    }

    @Override
    public void setTestInformation(TestInformation testInformation) {
        this.mTestInformation = testInformation;
    }

    @Override
    public TestInformation getTestInformation() {
        return this.mTestInformation;
    }

    @Override
    public void setListeners(List<ICommandScheduler.IScheduledInvocationListener> listeners) {
        this.mScheduledInvocationListeners = listeners;
    }

    @Override
    public List<ICommandScheduler.IScheduledInvocationListener> getListeners() {
        return this.mScheduledInvocationListeners;
    }

    @Override
    public FeatureResponse execute(FeatureRequest featureRequest) {
        Map<String, String> deviceStatusMap = featureRequest.getArgsMap();
        LinkedHashMap<ITestDevice, FreeDeviceState> deviceStates = new LinkedHashMap<ITestDevice, FreeDeviceState>();
        int index = 0;
        for (Map.Entry<String, String> entry : deviceStatusMap.entrySet()) {
            ITestDevice device = this.mTestInformation.getContext().getDevice(entry.getKey());
            if (device == null) {
                device = this.mTestInformation.getContext().getDevices().get(index);
            }
            deviceStates.put(device, FreeDeviceState.valueOf(entry.getValue()));
            ++index;
        }
        this.mTestInformation.getContext().markReleasedEarly();
        for (ICommandScheduler.IScheduledInvocationListener listener : this.mScheduledInvocationListeners) {
            listener.releaseDevices(this.mTestInformation.getContext(), deviceStates);
        }
        return FeatureResponse.newBuilder().build();
    }
}

