/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceActionReceiver;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.device.metric.MetricOption;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BaseDeviceMetricCollector
implements IMetricCollector,
IDeviceActionReceiver {
    public static final String TEST_CASE_INCLUDE_GROUP_OPTION = "test-case-include-group";
    public static final String TEST_CASE_EXCLUDE_GROUP_OPTION = "test-case-exclude-group";
    @Option(name="disable", description="disables the metrics collector")
    private boolean mDisable = false;
    @Option(name="test-case-include-group", description="Specify a group to include as part of the collection,group can be specified via @MetricOption. Can be repeated.Usage: @MetricOption(group = \"groupname\") to your test methods, thenuse --test-case-include-anotation groupename to only run your group.")
    private List<String> mTestCaseIncludeAnnotationGroup = new ArrayList<String>();
    @Option(name="test-case-exclude-group", description="Specify a group to exclude from the metric collection,group can be specified via @MetricOption. Can be repeated.")
    private List<String> mTestCaseExcludeAnnotationGroup = new ArrayList<String>();
    private IInvocationContext mContext;
    private List<ITestDevice> mRealDeviceList;
    private ITestInvocationListener mForwarder;
    private Map<String, File> mTestArtifactFilePathMap = new HashMap<String, File>();
    private DeviceMetricData mRunData;
    private DeviceMetricData mTestData;
    private String mRunName;
    private boolean mSkipTestCase = false;
    private boolean mWasInitDone = false;
    private boolean mDeviceNoAvailable = false;
    private boolean mDisableReceiver = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ITestInvocationListener init(IInvocationContext context, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mContext = context;
        this.mForwarder = listener;
        if (this.mWasInitDone) {
            throw new IllegalStateException(String.format("init was called a second time on %s", this));
        }
        this.mWasInitDone = true;
        this.mDeviceNoAvailable = false;
        if (!this.isDisabledReceiver()) {
            for (ITestDevice device : this.getRealDevices()) {
                device.registerDeviceActionReceiver(this);
            }
        }
        long start = System.currentTimeMillis();
        try {
            this.extraInit(context, listener);
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
        }
        return this;
    }

    public void extraInit(IInvocationContext context, ITestInvocationListener listener) throws DeviceNotAvailableException {
    }

    @Override
    public final List<ITestDevice> getDevices() {
        return this.mContext.getDevices();
    }

    public final List<ITestDevice> getRealDevices() {
        if (this.mRealDeviceList == null) {
            this.mRealDeviceList = this.mContext.getDevices().stream().filter(d -> !(d.getIDevice() instanceof StubDevice)).collect(Collectors.toList());
        }
        return this.mRealDeviceList;
    }

    public File getFileFromTestArtifacts(String fileName) {
        if (this.mTestArtifactFilePathMap.containsKey(fileName)) {
            return this.mTestArtifactFilePathMap.get(fileName);
        }
        File resolvedFile = this.resolveRelativeFilePath(fileName);
        if (resolvedFile != null) {
            LogUtil.CLog.i("Using file %s from %s", fileName, resolvedFile.getAbsolutePath());
            this.mTestArtifactFilePathMap.put(fileName, resolvedFile);
        }
        return resolvedFile;
    }

    @Override
    public final List<IBuildInfo> getBuildInfos() {
        return this.mContext.getBuildInfos();
    }

    @Override
    public final ITestInvocationListener getInvocationListener() {
        return this.mForwarder;
    }

    @Override
    public void onTestModuleStarted() throws DeviceNotAvailableException {
    }

    @Override
    public void onTestModuleEnded() throws DeviceNotAvailableException {
    }

    @Override
    public void onTestRunStart(DeviceMetricData runData) throws DeviceNotAvailableException {
    }

    public void onTestRunFailed(DeviceMetricData testData, FailureDescription failure) throws DeviceNotAvailableException {
    }

    @Override
    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) throws DeviceNotAvailableException {
    }

    @Override
    public void onTestStart(DeviceMetricData testData) throws DeviceNotAvailableException {
    }

    @Override
    public void onTestFail(DeviceMetricData testData, TestDescription test) throws DeviceNotAvailableException {
    }

    @Override
    public void onTestAssumptionFailure(DeviceMetricData testData, TestDescription test) throws DeviceNotAvailableException {
    }

    @Override
    public void onTestEnd(DeviceMetricData testData, Map<String, MetricMeasurement.Metric> currentTestCaseMetrics) throws DeviceNotAvailableException {
    }

    @Override
    public void onTestEnd(DeviceMetricData testData, Map<String, MetricMeasurement.Metric> currentTestCaseMetrics, TestDescription test) throws DeviceNotAvailableException {
        this.onTestEnd(testData, currentTestCaseMetrics);
    }

    @Override
    public final void invocationStarted(IInvocationContext context) {
        this.mForwarder.invocationStarted(context);
    }

    @Override
    public final void invocationFailed(Throwable cause) {
        this.mForwarder.invocationFailed(cause);
    }

    @Override
    public final void invocationFailed(FailureDescription failure) {
        this.mForwarder.invocationFailed(failure);
    }

    @Override
    public final void invocationEnded(long elapsedTime) {
        this.mForwarder.invocationEnded(elapsedTime);
    }

    @Override
    public final void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        this.mForwarder.testLog(dataName, dataType, dataStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testModuleStarted(IInvocationContext moduleContext) {
        long start = System.currentTimeMillis();
        try (CloseableTraceScope ignored = new CloseableTraceScope("module_start_" + this.getClass().getSimpleName());){
            this.onTestModuleStarted();
        }
        catch (DeviceNotAvailableException dnae) {
            this.mDeviceNoAvailable = true;
            LogUtil.CLog.e(dnae);
        }
        catch (Throwable t) {
            LogUtil.CLog.e(t);
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
            this.mForwarder.testModuleStarted(moduleContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final void testModuleEnded() {
        block18: {
            long start;
            block17: {
                start = System.currentTimeMillis();
                try {
                    try (CloseableTraceScope ignored = new CloseableTraceScope("module_end_" + this.getClass().getSimpleName());){
                        this.onTestModuleEnded();
                    }
                    if (this.isDisabledReceiver()) break block17;
                }
                catch (DeviceNotAvailableException dnae) {
                    LogUtil.CLog.e(dnae);
                    break block18;
                }
                catch (Throwable t) {
                    block19: {
                        LogUtil.CLog.e(t);
                        if (this.isDisabledReceiver()) break block19;
                        for (ITestDevice device : this.getRealDevices()) {
                            device.deregisterDeviceActionReceiver(this);
                        }
                    }
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
                    this.mForwarder.testModuleEnded();
                    break block18;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (!this.isDisabledReceiver()) {
                        for (ITestDevice device : this.getRealDevices()) {
                            device.deregisterDeviceActionReceiver(this);
                        }
                    }
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
                    this.mForwarder.testModuleEnded();
                }
                for (ITestDevice device : this.getRealDevices()) {
                    device.deregisterDeviceActionReceiver(this);
                }
            }
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
            this.mForwarder.testModuleEnded();
        }
    }

    @Override
    public final void testRunStarted(String runName, int testCount) {
        this.testRunStarted(runName, testCount, 0);
    }

    @Override
    public final void testRunStarted(String runName, int testCount, int attemptNumber) {
        this.testRunStarted(runName, testCount, 0, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testRunStarted(String runName, int testCount, int attemptNumber, long startTime) {
        this.mRunData = new DeviceMetricData(this.mContext);
        this.mRunName = runName;
        this.mDeviceNoAvailable = false;
        long start = System.currentTimeMillis();
        try (CloseableTraceScope ignored = new CloseableTraceScope("run_start_" + this.getClass().getSimpleName());){
            this.onTestRunStart(this.mRunData, testCount);
        }
        catch (DeviceNotAvailableException e) {
            this.mDeviceNoAvailable = true;
            LogUtil.CLog.e(e);
        }
        catch (Throwable t) {
            LogUtil.CLog.e(t);
        }
        finally {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
        }
        this.mForwarder.testRunStarted(runName, testCount, attemptNumber, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testRunFailed(String errorMessage) {
        if (!this.mDeviceNoAvailable) {
            long start = System.currentTimeMillis();
            try {
                this.onTestRunFailed(this.mRunData, FailureDescription.create(errorMessage));
            }
            catch (DeviceNotAvailableException e) {
                this.mDeviceNoAvailable = true;
                LogUtil.CLog.e(e);
            }
            catch (Throwable t) {
                LogUtil.CLog.e(t);
            }
            finally {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
            }
        }
        this.mForwarder.testRunFailed(errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testRunFailed(FailureDescription failure) {
        if (!this.mDeviceNoAvailable) {
            long start = System.currentTimeMillis();
            try {
                this.onTestRunFailed(this.mRunData, failure);
            }
            catch (DeviceNotAvailableException e) {
                this.mDeviceNoAvailable = true;
                LogUtil.CLog.e(e);
            }
            catch (Throwable t) {
                LogUtil.CLog.e(t);
            }
            finally {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
            }
        }
        this.mForwarder.testRunFailed(failure);
    }

    @Override
    public final void testRunStopped(long elapsedTime) {
        this.mForwarder.testRunStopped(elapsedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        block19: {
            if (!this.mDeviceNoAvailable) {
                long start;
                block18: {
                    start = System.currentTimeMillis();
                    try {
                        try (CloseableTraceScope ignored = new CloseableTraceScope("run_end_" + this.getClass().getSimpleName());){
                            this.onTestRunEnd(this.mRunData, runMetrics);
                            this.mRunData.addToMetrics(runMetrics);
                        }
                        if (this.isDisabledReceiver()) break block18;
                    }
                    catch (DeviceNotAvailableException e) {
                        this.mDeviceNoAvailable = true;
                        LogUtil.CLog.e(e);
                        break block19;
                    }
                    catch (Throwable t) {
                        block20: {
                            LogUtil.CLog.e(t);
                            if (this.isDisabledReceiver()) break block20;
                            for (ITestDevice device : this.getRealDevices()) {
                                device.deregisterDeviceActionReceiver(this);
                            }
                        }
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
                        break block19;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (!this.isDisabledReceiver()) {
                            for (ITestDevice device : this.getRealDevices()) {
                                device.deregisterDeviceActionReceiver(this);
                            }
                        }
                        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
                    }
                    for (ITestDevice device : this.getRealDevices()) {
                        device.deregisterDeviceActionReceiver(this);
                    }
                }
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
            }
        }
        this.mForwarder.testRunEnded(elapsedTime, runMetrics);
    }

    @Override
    public final void testStarted(TestDescription test) {
        this.testStarted(test, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testStarted(TestDescription test, long startTime) {
        if (!this.mDeviceNoAvailable) {
            this.mTestData = new DeviceMetricData(this.mContext);
            this.mSkipTestCase = this.shouldSkip(test);
            if (!this.mSkipTestCase) {
                long start = System.currentTimeMillis();
                try {
                    this.onTestStart(this.mTestData);
                }
                catch (DeviceNotAvailableException e) {
                    this.mDeviceNoAvailable = true;
                    LogUtil.CLog.e(e);
                }
                catch (Throwable t) {
                    LogUtil.CLog.e(t);
                }
                finally {
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
                }
            }
        }
        this.mForwarder.testStarted(test, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testFailed(TestDescription test, String trace) {
        if (!this.mSkipTestCase && !this.mDeviceNoAvailable) {
            long start = System.currentTimeMillis();
            try {
                this.onTestFail(this.mTestData, test);
            }
            catch (DeviceNotAvailableException e) {
                this.mDeviceNoAvailable = true;
                LogUtil.CLog.e(e);
            }
            catch (Throwable t) {
                LogUtil.CLog.e(t);
            }
            finally {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
            }
        }
        this.mForwarder.testFailed(test, trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testFailed(TestDescription test, FailureDescription failure) {
        if (!(this.mSkipTestCase || this.mDeviceNoAvailable || failure.getFailureStatus() != null && TestRecordProto.FailureStatus.NOT_EXECUTED.equals(failure.getFailureStatus()))) {
            long start = System.currentTimeMillis();
            try {
                this.onTestFail(this.mTestData, test);
            }
            catch (DeviceNotAvailableException e) {
                this.mDeviceNoAvailable = true;
                LogUtil.CLog.e(e);
            }
            catch (Throwable t) {
                LogUtil.CLog.e(t);
            }
            finally {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
            }
        }
        this.mForwarder.testFailed(test, failure);
    }

    @Override
    public final void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.testEnded(test, System.currentTimeMillis(), testMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        if (!this.mSkipTestCase && !this.mDeviceNoAvailable) {
            long start = System.currentTimeMillis();
            try {
                this.onTestEnd(this.mTestData, testMetrics, test);
                this.mTestData.addToMetrics(testMetrics);
            }
            catch (DeviceNotAvailableException e) {
                this.mDeviceNoAvailable = true;
                LogUtil.CLog.e(e);
            }
            catch (Throwable t) {
                LogUtil.CLog.e(t);
            }
            finally {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
            }
        } else {
            LogUtil.CLog.d("Skipping %s collection for %s.", this.getClass().getName(), test.toString());
        }
        this.mForwarder.testEnded(test, endTime, testMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testAssumptionFailure(TestDescription test, String trace) {
        if (!this.mSkipTestCase && !this.mDeviceNoAvailable) {
            long start = System.currentTimeMillis();
            try {
                this.onTestAssumptionFailure(this.mTestData, test);
            }
            catch (DeviceNotAvailableException e) {
                this.mDeviceNoAvailable = true;
                LogUtil.CLog.e(e);
            }
            catch (Throwable t) {
                LogUtil.CLog.e(t);
            }
            finally {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
            }
        }
        this.mForwarder.testAssumptionFailure(test, trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        if (!this.mSkipTestCase && !this.mDeviceNoAvailable) {
            long start = System.currentTimeMillis();
            try {
                this.onTestAssumptionFailure(this.mTestData, test);
            }
            catch (DeviceNotAvailableException e) {
                this.mDeviceNoAvailable = true;
                LogUtil.CLog.e(e);
            }
            catch (Throwable t) {
                LogUtil.CLog.e(t);
            }
            finally {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.COLLECTOR_TIME, System.currentTimeMillis() - start);
            }
        }
        this.mForwarder.testAssumptionFailure(test, failure);
    }

    @Override
    public final void testIgnored(TestDescription test) {
        this.mForwarder.testIgnored(test);
    }

    @Override
    public final void setLogSaver(ILogSaver logSaver) {
        if (this.mForwarder instanceof ILogSaverListener) {
            ((ILogSaverListener)this.mForwarder).setLogSaver(logSaver);
        }
    }

    @Override
    public final void logAssociation(String dataName, LogFile logFile) {
        if (this.mForwarder instanceof ILogSaverListener) {
            ((ILogSaverListener)this.mForwarder).logAssociation(dataName, logFile);
        }
    }

    @Override
    public final void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        if (this.mForwarder instanceof ILogSaverListener) {
            ((ILogSaverListener)this.mForwarder).testLogSaved(dataName, dataType, dataStream, logFile);
        }
    }

    @Override
    public final boolean isDisabled() {
        return this.mDisable;
    }

    @Override
    public final void setDisable(boolean isDisabled) {
        this.mDisable = isDisabled;
    }

    public String getRunName() {
        return this.mRunName;
    }

    public String getModuleName() {
        return this.mContext.getAttributes().get("module-name") != null ? this.mContext.getAttributes().get("module-name").get(0) : null;
    }

    private boolean shouldSkip(TestDescription desc) {
        HashSet<String> testCaseGroups = new HashSet<String>();
        if (desc.getAnnotation(MetricOption.class) != null) {
            String groupName = desc.getAnnotation(MetricOption.class).group();
            testCaseGroups.addAll(Arrays.asList(groupName.split(",")));
        } else {
            testCaseGroups.add("");
        }
        for (String groupName : testCaseGroups) {
            if (!this.mTestCaseExcludeAnnotationGroup.contains(groupName)) continue;
            return true;
        }
        for (String includeGroupName : this.mTestCaseIncludeAnnotationGroup) {
            if (!testCaseGroups.contains(includeGroupName)) continue;
            return false;
        }
        return !this.mTestCaseIncludeAnnotationGroup.isEmpty();
    }

    private File resolveRelativeFilePath(String fileName) {
        IBuildInfo buildInfo = this.getBuildInfos().get(0);
        String mModuleName = null;
        if (this.mContext.getAttributes().get("module-name") != null) {
            mModuleName = this.mContext.getAttributes().get("module-name").get(0);
        }
        File src = null;
        if (buildInfo != null && (src = buildInfo.getFile(fileName)) != null && src.exists()) {
            return src;
        }
        if (buildInfo instanceof IDeviceBuildInfo) {
            IDeviceBuildInfo deviceBuild = (IDeviceBuildInfo)buildInfo;
            File testDir = deviceBuild.getTestsDir();
            ArrayList<File> scanDirs = new ArrayList<File>();
            File targetTestCases = deviceBuild.getFile(BuildInfoKey.BuildInfoFileKey.TARGET_LINKED_DIR);
            if (targetTestCases != null) {
                scanDirs.add(targetTestCases);
            }
            if (testDir != null) {
                scanDirs.add(testDir);
            }
            if (mModuleName != null && testDir != null) {
                try {
                    File moduleDir = FileUtil.findDirectory(mModuleName, scanDirs.toArray(new File[0]));
                    if (moduleDir != null) {
                        if (mModuleName.equals(fileName)) {
                            return moduleDir;
                        }
                        src = FileUtil.findFile(fileName, null, moduleDir);
                        if (src != null) {
                            LogUtil.CLog.i("Retrieving src file from" + src.getAbsolutePath());
                            return src;
                        }
                    } else {
                        LogUtil.CLog.d("Did not find any module directory for '%s'", mModuleName);
                    }
                }
                catch (IOException e) {
                    LogUtil.CLog.w("Something went wrong while searching for the module '%s' directory.", mModuleName);
                }
            }
            for (File searchDir : scanDirs) {
                try {
                    Set<File> allMatch = FileUtil.findFilesObject(searchDir, fileName);
                    if (allMatch.size() > 1) {
                        LogUtil.CLog.d("Several match for filename '%s', searching for top-level match.", fileName);
                        for (File f : allMatch) {
                            if (!f.getParent().equals(searchDir.getAbsolutePath())) continue;
                            return f;
                        }
                        continue;
                    }
                    if (allMatch.size() != 1) continue;
                    return allMatch.iterator().next();
                }
                catch (IOException e) {
                    LogUtil.CLog.w("Failed to find test files from directory.");
                }
            }
        }
        return src;
    }

    @Override
    public void rebootStarted(ITestDevice device) throws DeviceNotAvailableException {
    }

    @Override
    public void rebootEnded(ITestDevice device) throws DeviceNotAvailableException {
    }

    @Override
    public void setDisableReceiver(boolean isDisabled) {
        this.mDisableReceiver = isDisabled;
    }

    @Override
    public boolean isDisabledReceiver() {
        return this.mDisableReceiver;
    }
}

