/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.os.AtomsProto;
import com.android.os.StatsLog;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BluetoothConnectionLatencyCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.InputStreamSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@OptionClass(alias="bluetooth-connection-state-collector")
public class BluetoothConnectionStateCollector
extends BluetoothConnectionLatencyCollector {
    @Override
    protected void processStatsReport(ITestDevice device, InputStreamSource dataStream, DeviceMetricData runData) {
        LogUtil.CLog.d("processStatsReport is called for device %s", device.getSerialNumber());
        HashMap<String, List<Long>> btProfilesStates = new HashMap<String, List<Long>>();
        try {
            StatsLog.ConfigMetricsReportList reports = StatsLog.ConfigMetricsReportList.parseFrom(dataStream.createInputStream());
            LogUtil.CLog.d("Processing %d reports with 0th having %d metrics lists", reports.getReportsCount(), reports.getReports(0).getMetricsCount());
            StatsLog.StatsLogReport.EventMetricDataWrapper eventData = reports.getReports(0).getMetrics(0).getEventMetrics();
            for (StatsLog.EventMetricData metricData : eventData.getDataList()) {
                this.processEventMetric(device, metricData, btProfilesStates);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to process statsd metric report on device %s, error: %s", device.getSerialNumber(), e);
        }
        this.addMetricsToRunData(device, runData, btProfilesStates);
    }

    private void addMetricsToRunData(ITestDevice device, DeviceMetricData runData, HashMap<String, List<Long>> btProfilesStates) {
        for (String key : btProfilesStates.keySet()) {
            List<Long> states = btProfilesStates.get(key);
            String metricKey = String.join((CharSequence)"_", key, "connection_state_changed");
            MetricMeasurement.NumericValues values2 = MetricMeasurement.NumericValues.newBuilder().addAllNumericValue(states).build();
            MetricMeasurement.Measurements measurements = MetricMeasurement.Measurements.newBuilder().setNumericValues(values2).build();
            LogUtil.CLog.d("Adding metric on device %s with key %s and values %s", device.getSerialNumber(), metricKey, states.toString());
            runData.addMetricForDevice(device, metricKey, MetricMeasurement.Metric.newBuilder().setMeasurements(measurements));
        }
    }

    private void processEventMetric(ITestDevice device, StatsLog.EventMetricData metric, HashMap<String, List<Long>> btProfilesStates) {
        AtomsProto.Atom atom;
        AtomsProto.Atom atom2 = atom = metric.hasAtom() ? metric.getAtom() : metric.getAggregatedAtomInfo().getAtom();
        if (!atom.hasBluetoothConnectionStateChanged()) {
            LogUtil.CLog.d("Atom does not have a bluetooth_connection_state_changed info. Skipping reporting");
            return;
        }
        AtomsProto.BluetoothConnectionStateChanged bluetoothConnectionStateChanged = atom.getBluetoothConnectionStateChanged();
        int btState = bluetoothConnectionStateChanged.getState().getNumber();
        int btProfile = bluetoothConnectionStateChanged.getBtProfile();
        LogUtil.CLog.d("Processing connection state changed atom on device %s for profile number %d", device.getSerialNumber(), btProfile);
        if (BLUETOOTH_PROFILES_MAP.containsKey(btProfile)) {
            String btProfileName = (String)BLUETOOTH_PROFILES_MAP.get(btProfile);
            List states = btProfilesStates.getOrDefault(btProfileName, new ArrayList());
            states.add(Long.valueOf(btState));
            btProfilesStates.put(btProfileName, states);
            LogUtil.CLog.d("Processed connection state changed atom on device %s profile %s value %d", device.getSerialNumber(), btProfileName, btState);
        }
    }
}

