/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;

public class BugreportzOnFailureCollector
extends BaseDeviceMetricCollector {
    private static final String NAME_FORMAT = "%s-%s-bugreportz-on-failure";

    @Override
    public void onTestRunFailed(DeviceMetricData testData, FailureDescription failure) {
        for (ITestDevice device : this.getDevices()) {
            String name = String.format(NAME_FORMAT, this.getRunName(), device.getSerialNumber());
            if (device.logBugreport(name, this.getInvocationListener())) continue;
            LogUtil.CLog.e("Failed to capture bugreportz on '%s'", device.getSerialNumber());
        }
    }
}

