/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.TestDescription;
import java.util.Map;

public class BugreportzOnTestCaseFailureCollector
extends BaseDeviceMetricCollector {
    private static final String NAME_FORMAT = "%s-%s-bugreportz-on-test-case-failure";
    private boolean mTestFailed = false;

    @Override
    public void onTestRunStart(DeviceMetricData runData) {
        this.mTestFailed = false;
    }

    @Override
    public void onTestFail(DeviceMetricData testData, TestDescription test) {
        this.mTestFailed = true;
    }

    @Override
    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) {
        if (!this.mTestFailed) {
            return;
        }
        for (ITestDevice device : this.getDevices()) {
            String name = String.format(NAME_FORMAT, this.getRunName(), device.getSerialNumber());
            if (device.logBugreport(name, this.getInvocationListener())) continue;
            LogUtil.CLog.e("Failed to capture bugreportz on '%s'", device.getSerialNumber());
        }
    }
}

