/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.AdbRootElevator;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.NativeCodeCoverageFlusher;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.TarUtil;
import com.android.tradefed.util.ZipUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class ClangCodeCoverageCollector
extends BaseDeviceMetricCollector
implements IConfigurationReceiver {
    private static final String NATIVE_COVERAGE_DEVICE_PATH = "/data/misc/trace";
    private static final int MAX_PROFILE_FILES = 100;
    private static final String ZIP_CLANG_FILES_COMMAND = String.format("find %s -name '*.profraw' | tar -czf - -T - 2>/dev/null", "/data/misc/trace");
    private static final String DELETE_COVERAGE_FILES_COMMAND = String.format("find %s -name '*.profraw' -delete", "/data/misc/trace");
    private IConfiguration mConfiguration;
    private IRunUtil mRunUtil = RunUtil.getDefault();
    private long mTimeoutMilli = 1200000L;
    private File mLlvmProfileTool;
    private NativeCodeCoverageFlusher mFlusher;

    @Override
    public void extraInit(IInvocationContext context, ITestInvocationListener listener) throws DeviceNotAvailableException {
        super.extraInit(context, listener);
        this.setDisableReceiver(false);
        Verify.verifyNotNull(this.mConfiguration);
        this.setCoverageOptions(this.mConfiguration.getCoverageOptions());
        if (this.isClangCoverageEnabled() && this.mConfiguration.getCoverageOptions().shouldResetCoverageBeforeTest()) {
            for (ITestDevice device : this.getRealDevices()) {
                try (AdbRootElevator adbRoot = new AdbRootElevator(device);){
                    this.getCoverageFlusher(device).resetCoverage();
                }
            }
        }
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    @Override
    public void rebootEnded(ITestDevice device) throws DeviceNotAvailableException {
        if (this.isClangCoverageEnabled() && this.mConfiguration.getCoverageOptions().shouldResetCoverageBeforeTest()) {
            this.getCoverageFlusher(device).deleteCoverageMeasurements();
        }
    }

    @VisibleForTesting
    public void setRunUtil(IRunUtil runUtil) {
        this.mRunUtil = runUtil;
        if (this.mFlusher != null) {
            this.mFlusher.setRunUtil(runUtil);
        }
    }

    @Override
    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) throws DeviceNotAvailableException {
        if (!this.isClangCoverageEnabled()) {
            return;
        }
        for (ITestDevice device : this.getRealDevices()) {
            try (AdbRootElevator adbRoot = new AdbRootElevator(device);){
                if (this.mConfiguration.getCoverageOptions().isCoverageFlushEnabled()) {
                    this.getCoverageFlusher(device).forceCoverageFlush();
                }
                this.logCoverageMeasurement(device, this.generateMeasurementFileName());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String generateMeasurementFileName() {
        String moduleName = Strings.nullToEmpty(this.getModuleName());
        if (moduleName.length() > 0) {
            moduleName = moduleName + "_MODULE_";
        }
        return moduleName + this.getRunName().replace(' ', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCoverageMeasurement(ITestDevice device, String runName) throws DeviceNotAvailableException, IOException {
        Set<String> rawProfileFiles;
        File indexedProfileFile;
        File profileTool;
        File fileList;
        File untarDir;
        File coverageTarGz;
        block18: {
            coverageTarGz = null;
            untarDir = null;
            fileList = null;
            profileTool = null;
            indexedProfileFile = null;
            try {
                coverageTarGz = FileUtil.createTempFile("clang_coverage", ".tar.gz");
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(coverageTarGz));){
                    device.executeShellV2Command(ZIP_CLANG_FILES_COMMAND, null, out, this.mTimeoutMilli, TimeUnit.MILLISECONDS, 1);
                }
                untarDir = TarUtil.extractTarGzipToTemp(coverageTarGz, "clang_coverage");
                rawProfileFiles = FileUtil.findFiles(untarDir, this.mConfiguration.getCoverageOptions().getProfrawFilter());
                if (!rawProfileFiles.isEmpty()) break block18;
                LogUtil.CLog.i("No Clang code coverage measurements found.");
            }
            catch (Throwable throwable) {
                device.executeShellCommand(DELETE_COVERAGE_FILES_COMMAND);
                FileUtil.deleteFile(coverageTarGz);
                FileUtil.recursiveDelete(untarDir);
                FileUtil.deleteFile(fileList);
                FileUtil.recursiveDelete(this.mLlvmProfileTool);
                FileUtil.deleteFile(indexedProfileFile);
                throw throwable;
            }
            device.executeShellCommand(DELETE_COVERAGE_FILES_COMMAND);
            FileUtil.deleteFile(coverageTarGz);
            FileUtil.recursiveDelete(untarDir);
            FileUtil.deleteFile(fileList);
            FileUtil.recursiveDelete(this.mLlvmProfileTool);
            FileUtil.deleteFile(indexedProfileFile);
            return;
        }
        LogUtil.CLog.i("Received %d Clang code coverage measurements.", rawProfileFiles.size());
        profileTool = this.getProfileTool();
        Path profileBin = profileTool.toPath().resolve("bin/llvm-profdata");
        profileBin.toFile().setExecutable(true);
        ArrayList<String> command = new ArrayList<String>();
        command.add(profileBin.toString());
        command.add("merge");
        command.add("-sparse");
        if (rawProfileFiles.size() > 100) {
            fileList = FileUtil.createTempFile("clang_measurements", ".txt");
            Files.write(fileList.toPath(), rawProfileFiles, Charset.defaultCharset(), new OpenOption[0]);
            command.add("-f");
            command.add(fileList.getAbsolutePath());
        } else {
            command.addAll(rawProfileFiles);
        }
        indexedProfileFile = FileUtil.createTempFile(runName + "_clang_runtime_coverage", ".profdata");
        command.add("-o");
        command.add(indexedProfileFile.getAbsolutePath());
        CommandResult result = this.mRunUtil.runTimedCmd(0L, command.toArray(new String[0]));
        if (result.getStatus() != CommandStatus.SUCCESS) {
            command.add("-failure-mode=all");
            result = this.mRunUtil.runTimedCmd(0L, command.toArray(new String[0]));
            if (result.getStatus() != CommandStatus.SUCCESS) {
                throw new HarnessRuntimeException("Failed to merge Clang profile data:\n" + result.toString(), InfraErrorIdentifier.CODE_COVERAGE_ERROR);
            }
        }
        try (FileInputStreamSource source = new FileInputStreamSource(indexedProfileFile, true);){
            this.testLog(runName + "_clang_runtime_coverage", LogDataType.CLANG_COVERAGE, source);
        }
        device.executeShellCommand(DELETE_COVERAGE_FILES_COMMAND);
        FileUtil.deleteFile(coverageTarGz);
        FileUtil.recursiveDelete(untarDir);
        FileUtil.deleteFile(fileList);
        FileUtil.recursiveDelete(this.mLlvmProfileTool);
        FileUtil.deleteFile(indexedProfileFile);
    }

    private NativeCodeCoverageFlusher getCoverageFlusher(ITestDevice device) {
        if (this.mFlusher == null) {
            Verify.verifyNotNull(this.mConfiguration);
            this.mFlusher = new NativeCodeCoverageFlusher(device, this.mConfiguration.getCoverageOptions().getCoverageProcesses());
            this.mFlusher.setRunUtil(this.mRunUtil);
        }
        return this.mFlusher;
    }

    private boolean isClangCoverageEnabled() {
        return this.mConfiguration != null && this.mConfiguration.getCoverageOptions().isCoverageEnabled() && this.mConfiguration.getCoverageOptions().getCoverageToolchains().contains((Object)CoverageOptions.Toolchain.CLANG);
    }

    private File getProfileTool() throws IOException {
        File file2;
        File configurationTool = this.mConfiguration.getCoverageOptions().getLlvmProfdataPath();
        if (configurationTool != null) {
            return configurationTool;
        }
        if (this.mLlvmProfileTool != null && this.mLlvmProfileTool.exists()) {
            return this.mLlvmProfileTool;
        }
        File profileToolZip = null;
        for (IBuildInfo info : this.getBuildInfos()) {
            if (info.getFile("llvm-profdata.zip") == null) continue;
            profileToolZip = info.getFile("llvm-profdata.zip");
            this.mLlvmProfileTool = ZipUtil.extractZipToTemp(profileToolZip, "llvm-profdata");
            return this.mLlvmProfileTool;
        }
        try {
            IBuildInfo buildInfo = this.mConfiguration.getBuildProvider().getBuild();
            profileToolZip = Verify.verifyNotNull(buildInfo.getFile("llvm-profdata.zip"), "Could not get llvm-profdata.zip from the build.", new Object[0]);
            file2 = this.mLlvmProfileTool = ZipUtil.extractZipToTemp(profileToolZip, "llvm-profdata");
        }
        catch (BuildRetrievalError e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.deleteFile(profileToolZip);
                throw throwable;
            }
        }
        FileUtil.deleteFile(profileToolZip);
        return file2;
    }

    private void setCoverageOptions(CoverageOptions coverageOptions) {
        this.mTimeoutMilli = coverageOptions.getPullTimeout();
    }
}

