/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.testtype.IRemoteTest;
import java.util.Map;

public class CountTestCasesCollector
extends BaseDeviceMetricCollector {
    private long mTestCount = 0L;
    private String mTestType = null;

    public CountTestCasesCollector() {
    }

    public CountTestCasesCollector(IRemoteTest test) {
        this();
        this.setTestType(test);
    }

    public void setTestType(IRemoteTest test) {
        this.mTestType = test.getClass().getSimpleName();
    }

    @Override
    public void onTestEnd(DeviceMetricData testData, Map<String, MetricMeasurement.Metric> currentTestCaseMetrics) {
        if (this.mTestType == null) {
            return;
        }
        ++this.mTestCount;
    }

    @Override
    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) {
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.TOTAL_TEST_COUNT, this.mTestCount);
        if (this.mTestType == null) {
            return;
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationGroupMetricKey.TEST_TYPE_COUNT, this.mTestType, this.mTestCount);
        this.mTestCount = 0L;
    }
}

