/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.result.TestDescription;
import java.io.IOException;
import java.io.InputStream;

public class DebugHostLogOnFailureCollector
extends BaseDeviceMetricCollector {
    private static final String NAME_FORMAT = "%s-debug-hostlog-on-failure";
    private static final int THROTTLE_LIMIT_PER_RUN = 10;
    private int mCurrentCount = 0;
    private boolean mFirstThrottle = true;
    private Long offset = null;

    @Override
    public void onTestRunStart(DeviceMetricData runData) {
        this.offset = null;
        this.mCurrentCount = 0;
        this.mFirstThrottle = true;
        try (InputStreamSource source = this.getLogger().getLog();){
            if (source == null) {
                LogUtil.CLog.e("Could not obtain the host logs for debugging. It won't be available in the event of test cases failures.");
                return;
            }
            this.offset = source.size();
        }
    }

    @Override
    public void onTestFail(DeviceMetricData testData, TestDescription test) {
        if (this.offset == null) {
            return;
        }
        if (this.mCurrentCount > 10) {
            if (this.mFirstThrottle) {
                LogUtil.CLog.w("Throttle capture of host_log-on-failure due to too many failures.");
                this.mFirstThrottle = false;
            }
            return;
        }
        try (InputStreamSource source = this.getLogger().getLog();){
            if (source == null) {
                return;
            }
            try (InputStream stream = source.createInputStream();){
                stream.skip(this.offset);
                try (SnapshotInputStreamSource logSource = new SnapshotInputStreamSource("host-log-failure", stream);){
                    super.testLog(String.format(NAME_FORMAT, test.toString()), LogDataType.TEXT, logSource);
                }
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
    }

    ILeveledLogOutput getLogger() {
        LogRegistry registry = (LogRegistry)LogRegistry.getLogRegistry();
        return registry.getLogger();
    }
}

