/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class DeviceMetricData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEVICE_NAME_FORMAT_KEY = "{%s}:%s";
    private HashMap<String, MetricMeasurement.Metric> mCurrentMetrics = new LinkedHashMap<String, MetricMeasurement.Metric>();
    private final IInvocationContext mContext;

    public DeviceMetricData(IInvocationContext context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetric(String key, MetricMeasurement.Metric.Builder metric) {
        HashMap<String, MetricMeasurement.Metric> hashMap = this.mCurrentMetrics;
        synchronized (hashMap) {
            String actualKey = key;
            if (this.mContext.getDevices().size() > 1) {
                String deviceName = this.mContext.getDeviceName(this.mContext.getDevices().get(0));
                actualKey = String.format(DEVICE_NAME_FORMAT_KEY, deviceName, key);
            }
            MetricMeasurement.Metric m = metric.build();
            this.mCurrentMetrics.put(actualKey, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetricForDevice(ITestDevice device, String key, MetricMeasurement.Metric.Builder metric) {
        HashMap<String, MetricMeasurement.Metric> hashMap = this.mCurrentMetrics;
        synchronized (hashMap) {
            String actualKey = key;
            if (this.mContext.getDevices().size() > 1) {
                String deviceName = this.mContext.getDeviceName(device);
                actualKey = String.format(DEVICE_NAME_FORMAT_KEY, deviceName, key);
            }
            MetricMeasurement.Metric m = metric.build();
            this.mCurrentMetrics.put(actualKey, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToMetrics(HashMap<String, MetricMeasurement.Metric> metrics) {
        Preconditions.checkNotNull(metrics);
        HashMap<String, MetricMeasurement.Metric> hashMap = this.mCurrentMetrics;
        synchronized (hashMap) {
            metrics.putAll(this.mCurrentMetrics);
        }
    }
}

