/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.PerfettoTraceRecorder;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeviceTraceCollector
extends BaseDeviceMetricCollector {
    private static final String NAME_FORMAT = "device-trace_%s_%d_%s";
    private PerfettoTraceRecorder mPerfettoTraceRecorder = new PerfettoTraceRecorder();
    private String mInstrumentationPkgName;
    private Map<ITestDevice, Integer> mTraceCountMap = new LinkedHashMap<ITestDevice, Integer>();
    private Map<File, String> mTraceFilesMap = new LinkedHashMap<File, String>();

    public DeviceTraceCollector() {
        this.setDisableReceiver(false);
    }

    @Override
    public void extraInit(IInvocationContext context, ITestInvocationListener listener) throws DeviceNotAvailableException {
        super.extraInit(context, listener);
        for (ITestDevice device : this.getRealDevices()) {
            this.startTraceOnDevice(device);
        }
    }

    @Override
    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) throws DeviceNotAvailableException {
        for (ITestDevice device : this.getRealDevices()) {
            this.collectTraceFileFromDevice(device, "testRunEnded");
        }
        this.logTraceFiles();
    }

    private void startTraceOnDevice(ITestDevice device) {
        this.mTraceCountMap.put(device, this.mTraceCountMap.getOrDefault(device, 0) + 1);
        try {
            LinkedHashMap<String, String> extraConfigs = new LinkedHashMap<String, String>();
            if (this.mInstrumentationPkgName != null) {
                extraConfigs.put("atrace_apps", String.format("\"%s\"", this.mInstrumentationPkgName));
            }
            this.mPerfettoTraceRecorder.startTrace(device, extraConfigs);
        }
        catch (IOException e) {
            LogUtil.CLog.d("Failed to start perfetto trace on %s trace-count:%d with error: %s", device.getSerialNumber(), this.mTraceCountMap.get(device), e.getMessage());
        }
    }

    private void collectTraceFileFromDevice(ITestDevice device, String eventName) {
        File traceFile = this.mPerfettoTraceRecorder.stopTrace(device);
        if (traceFile == null) {
            LogUtil.CLog.d("Failed to collect device trace from %s on event:%s trace-count:%d.", device.getSerialNumber(), eventName, this.mTraceCountMap.get(device));
            return;
        }
        LogUtil.CLog.d("Collected device trace from %s on event:%s. trace-count:%d. size:%d", device.getSerialNumber(), eventName, this.mTraceCountMap.get(device), traceFile.length());
        String name = String.format(NAME_FORMAT, device.getSerialNumber(), this.mTraceCountMap.get(device), eventName);
        this.mTraceFilesMap.put(traceFile, name);
    }

    private void logTraceFiles() {
        for (Map.Entry<File, String> entry : this.mTraceFilesMap.entrySet()) {
            try (FileInputStreamSource source = new FileInputStreamSource(entry.getKey(), true);){
                super.testLog(entry.getValue(), LogDataType.PERFETTO, source);
            }
        }
    }

    public void setInstrumentationPkgName(String packageName) {
        this.mInstrumentationPkgName = packageName;
    }

    @Override
    public void rebootStarted(ITestDevice device) throws DeviceNotAvailableException {
        super.rebootStarted(device);
        this.collectTraceFileFromDevice(device, "rebootStarted");
    }

    @Override
    public void rebootEnded(ITestDevice device) throws DeviceNotAvailableException {
        super.rebootEnded(device);
        this.startTraceOnDevice(device);
    }
}

