/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmulatorMemoryCpuCapturer {
    private static final Pattern PSS_PATTERN = Pattern.compile("Pss:\\s+(\\d+)");
    private final long mPid;

    public EmulatorMemoryCpuCapturer(ITestDevice device) {
        IManagedTestDevice managedTestDevice = (IManagedTestDevice)device;
        Preconditions.checkArgument(managedTestDevice.getIDevice().isEmulator(), String.format("device %s is not an emulator", managedTestDevice.getIDevice().getSerialNumber()));
        this.mPid = managedTestDevice.getEmulatorProcess().pid();
    }

    @VisibleForTesting
    EmulatorMemoryCpuCapturer(long pid) {
        this.mPid = pid;
    }

    public long getPssMemory() {
        try {
            String s = FileUtil.readStringFromFile(new File(String.format("/proc/%d/smaps", this.mPid)));
            return EmulatorMemoryCpuCapturer.parsePssMemory(s);
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to read /proc/x/smaps", e);
            return 0L;
        }
    }

    static long parsePssMemory(String procSmapsContent) {
        Matcher m = PSS_PATTERN.matcher(procSmapsContent);
        ArrayList<Integer> allPss = new ArrayList<Integer>();
        while (m.find()) {
            allPss.add(Integer.parseInt(m.group(1)));
        }
        return allPss.stream().mapToInt(Integer::intValue).sum();
    }

    public float getCpuUsage() {
        CommandResult result = this.getRunUtil().runTimedCmd(20000L, "ps", "-o", "%cpu", "-p", Long.toString(this.mPid));
        if (result.getStatus() == CommandStatus.SUCCESS) {
            return EmulatorMemoryCpuCapturer.parseCpuUsage(result.getStdout());
        }
        LogUtil.CLog.e("Failed to run ps %s", result.toString());
        return 0.0f;
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    static float parseCpuUsage(String psContents) {
        return Float.parseFloat(psContents.replace("%CPU\n", "").trim());
    }
}

