/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ZipUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class FilePullerDeviceMetricCollector
extends BaseDeviceMetricCollector {
    @Option(name="pull-pattern-keys", description="The pattern key name to be pull from the device as a file. Can be repeated.")
    private Set<String> mKeys = new HashSet<String>();
    @Option(name="directory-keys", description="Path to the directory on the device that contains the metrics.")
    protected Set<String> mDirectoryKeys = new HashSet<String>();
    @Option(name="compress-directories", description="Compress multiple files in the matching directory into zip file")
    private boolean mCompressDirectory = false;
    @Option(name="clean-up", description="Whether to delete the file from the device after pulling it or not.")
    private boolean mCleanUp = true;
    @Option(name="collect-on-run-ended-only", description="Attempt to collect the files on test run end only instead of on both test cases and test run ended. This is safer since test case level collection isn't synchronous.")
    private boolean mCollectOnRunEndedOnly = true;
    public Map<String, String> mTestCaseMetrics = new HashMap<String, String>();

    @Override
    public void onTestEnd(DeviceMetricData testData, Map<String, MetricMeasurement.Metric> currentTestCaseMetrics) throws DeviceNotAvailableException {
        if (this.mCollectOnRunEndedOnly) {
            this.mTestCaseMetrics.putAll(TfMetricProtoUtil.compatibleConvert(currentTestCaseMetrics));
            return;
        }
        this.processMetricRequest(testData, currentTestCaseMetrics);
    }

    @Override
    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) throws DeviceNotAvailableException {
        this.processMetricRequest(runData, currentRunMetrics);
        this.mTestCaseMetrics = new HashMap<String, String>();
    }

    protected void addKeys(String ... keys) {
        this.mKeys.addAll(Arrays.asList(keys));
    }

    public abstract void processMetricFile(String var1, File var2, DeviceMetricData var3);

    public abstract void processMetricDirectory(String var1, File var2, DeviceMetricData var3);

    private void processMetricRequest(DeviceMetricData data, Map<String, MetricMeasurement.Metric> metrics) throws DeviceNotAvailableException {
        Map.Entry<String, File> pulledMetrics;
        Map<String, String> currentMetrics = TfMetricProtoUtil.compatibleConvert(metrics);
        currentMetrics.putAll(this.mTestCaseMetrics);
        if (this.mKeys.isEmpty() && this.mDirectoryKeys.isEmpty()) {
            return;
        }
        HashMap<ITestDevice, Integer> deviceUsers = new HashMap<ITestDevice, Integer>();
        if (!this.mKeys.isEmpty()) {
            for (ITestDevice device : this.getRealDevices()) {
                if (!TestDeviceState.ONLINE.equals((Object)device.getDeviceState())) {
                    LogUtil.CLog.d("Device '%s' is in state '%s' skipping file puller", new Object[]{device.getSerialNumber(), device.getDeviceState()});
                    return;
                }
                deviceUsers.put(device, device.getCurrentUser());
            }
        }
        for (String key : this.mKeys) {
            pulledMetrics = this.pullMetricFile(key, currentMetrics, deviceUsers);
            for (Map.Entry<String, File> entry : pulledMetrics.entrySet()) {
                this.processMetricFile(entry.getKey(), entry.getValue(), data);
            }
        }
        for (String key : this.mDirectoryKeys) {
            pulledMetrics = this.pullMetricDirectory(key);
            if (pulledMetrics == null) continue;
            if (this.mCompressDirectory) {
                File pulledDirectory = (File)pulledMetrics.getValue();
                if (!pulledDirectory.isDirectory()) continue;
                try {
                    File compressedFile = ZipUtil.createZip(pulledDirectory, this.getFileName(key));
                    this.processMetricFile(key, compressedFile, data);
                }
                catch (IOException e) {
                    LogUtil.CLog.e("Unable to compress the directory.");
                }
                FileUtil.recursiveDelete(pulledDirectory);
                continue;
            }
            this.processMetricDirectory((String)pulledMetrics.getKey(), (File)pulledMetrics.getValue(), data);
        }
    }

    private String getFileName(String key) {
        return key.substring(key.lastIndexOf("/") + 1);
    }

    private Map<String, File> pullMetricFile(String pattern, Map<String, String> currentMetrics, Map<ITestDevice, Integer> deviceUsers) throws DeviceNotAvailableException {
        HashMap<String, File> matchedFiles = new HashMap<String, File>();
        Pattern p = Pattern.compile(pattern);
        for (Map.Entry<String, String> entry : currentMetrics.entrySet()) {
            if (!p.matcher(entry.getKey()).find()) continue;
            for (ITestDevice device : this.getRealDevices()) {
                if (!this.shouldCollect(device)) continue;
                try {
                    File attemptPull = this.retrieveFile(device, entry.getValue(), deviceUsers.get(device));
                    if (attemptPull == null) continue;
                    if (this.mCleanUp) {
                        device.deleteFile(entry.getValue());
                    }
                    matchedFiles.put(entry.getKey(), attemptPull);
                }
                catch (RuntimeException e) {
                    LogUtil.CLog.e("Exception when pulling metric file '%s' from %s", entry.getValue(), device.getSerialNumber());
                    LogUtil.CLog.e(e);
                }
            }
        }
        if (matchedFiles.isEmpty()) {
            LogUtil.CLog.d("Could not find a device file associated to pattern '%s'.", pattern);
        }
        return matchedFiles;
    }

    protected File retrieveFile(ITestDevice device, String remoteFilePath, int userId) throws DeviceNotAvailableException {
        return device.pullFile(remoteFilePath, userId);
    }

    private Map.Entry<String, File> pullMetricDirectory(String keyDirectory) throws DeviceNotAvailableException {
        try {
            File tmpDestDir = FileUtil.createTempDir("metric_tmp", CurrentInvocation.getWorkFolder());
            for (ITestDevice device : this.getRealDevices()) {
                if (!this.shouldCollect(device)) continue;
                try {
                    if (!device.pullDir(keyDirectory, tmpDestDir)) continue;
                    if (this.mCleanUp) {
                        device.deleteFile(keyDirectory);
                    }
                    return new AbstractMap.SimpleEntry<String, File>(keyDirectory, tmpDestDir);
                }
                catch (RuntimeException e) {
                    LogUtil.CLog.e("Exception when pulling directory '%s' from %s", keyDirectory, device.getSerialNumber());
                    LogUtil.CLog.e(e);
                }
            }
        }
        catch (IOException ioe) {
            LogUtil.CLog.e("Exception while creating the local directory");
            LogUtil.CLog.e(ioe);
        }
        LogUtil.CLog.e("Could not find a device directory associated to path '%s'.", keyDirectory);
        return null;
    }

    private boolean shouldCollect(ITestDevice device) {
        TestDeviceState state = device.getDeviceState();
        if (!TestDeviceState.ONLINE.equals((Object)state)) {
            LogUtil.CLog.d("Skip %s device is in state '%s'", new Object[]{this, state});
            return false;
        }
        return true;
    }
}

