/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.FilePullerDeviceMetricCollector;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.FileUtil;
import java.io.File;

@OptionClass(alias="file-puller-log-collector")
public class FilePullerLogCollector
extends FilePullerDeviceMetricCollector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void processMetricFile(String key, File metricFile, DeviceMetricData runData) {
        try {
            this.postProcessMetricFile(key, metricFile, runData);
        }
        finally {
            try (FileInputStreamSource source = new FileInputStreamSource(metricFile, true);){
                LogDataType type = LogDataType.TEXT;
                String ext = FileUtil.getExtension(metricFile.getName()).toLowerCase();
                if (".hprof".equals(ext)) {
                    type = LogDataType.HPROF;
                } else if (".mp4".equals(ext)) {
                    type = LogDataType.MP4;
                } else if (".pb".equals(ext)) {
                    type = LogDataType.PB;
                } else if (".png".equals(ext)) {
                    type = LogDataType.PNG;
                } else if (".perfetto-trace".equals(ext)) {
                    type = LogDataType.PERFETTO;
                } else if (".zip".equals(ext)) {
                    type = LogDataType.ZIP;
                } else if (".uix".equals(ext)) {
                    type = LogDataType.UIX;
                } else if (".textproto".equals(ext) && FileUtil.getBaseName(metricFile.getName()).contains("_goldResult")) {
                    type = LogDataType.GOLDEN_RESULT_PROTO;
                }
                this.testLog(FileUtil.getBaseName(metricFile.getName()), type, source);
            }
        }
    }

    @Override
    public void processMetricDirectory(String key, File metricDirectory, DeviceMetricData runData) {
        for (File file2 : metricDirectory.listFiles()) {
            if (file2.isDirectory()) {
                this.processMetricDirectory(key, file2, runData);
                continue;
            }
            this.processMetricFile(key, file2, runData);
        }
        FileUtil.recursiveDelete(metricDirectory);
    }

    protected void postProcessMetricFile(String key, File metricFile, DeviceMetricData runData) {
    }
}

