/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.AdbRootElevator;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.NativeCodeCoverageFlusher;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.TarUtil;
import com.android.tradefed.util.ZipUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public final class GcovCodeCoverageCollector
extends BaseDeviceMetricCollector
implements IConfigurationReceiver {
    private static final String NATIVE_COVERAGE_DEVICE_PATH = "/data/misc/trace";
    private static final String COVERAGE_TAR_PATH = String.format("%s/coverage.tar", "/data/misc/trace");
    private static final String ZIP_COVERAGE_FILES_COMMAND = String.format("find %s -name '*.gcda' | tar -cvf %s -T -", "/data/misc/trace", COVERAGE_TAR_PATH);
    private static final String DELETE_COVERAGE_FILES_COMMAND = String.format("find %s -name '*.gcda' -delete", "/data/misc/trace");
    private NativeCodeCoverageFlusher mFlusher;
    private boolean mCollectCoverageOnTestEnd = true;
    private IConfiguration mConfiguration;
    private IRunUtil mRunUtil = RunUtil.getDefault();

    @Override
    public void extraInit(IInvocationContext context, ITestInvocationListener listener) throws DeviceNotAvailableException {
        super.extraInit(context, listener);
        if (this.isGcovCoverageEnabled()) {
            for (ITestDevice device : this.getRealDevices()) {
                try (AdbRootElevator adbRoot = new AdbRootElevator(device);){
                    this.getCoverageFlusher(device).resetCoverage();
                }
            }
        }
    }

    @VisibleForTesting
    void setRunUtil(IRunUtil runUtil) {
        this.mRunUtil = runUtil;
        if (this.mFlusher != null) {
            this.mFlusher.setRunUtil(runUtil);
        }
    }

    @Override
    public void setConfiguration(IConfiguration config) {
        this.mConfiguration = config;
    }

    private boolean isGcovCoverageEnabled() {
        return this.mConfiguration != null && this.mConfiguration.getCoverageOptions().isCoverageEnabled() && this.mConfiguration.getCoverageOptions().getCoverageToolchains().contains((Object)CoverageOptions.Toolchain.GCOV);
    }

    private NativeCodeCoverageFlusher getCoverageFlusher(ITestDevice device) {
        if (this.mFlusher == null) {
            this.mFlusher = new NativeCodeCoverageFlusher(device, this.mConfiguration.getCoverageOptions().getCoverageProcesses());
            this.mFlusher.setRunUtil(this.mRunUtil);
        }
        return this.mFlusher;
    }

    public void setCollectOnTestEnd(boolean collect) {
        this.mCollectCoverageOnTestEnd = collect;
    }

    @Override
    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> runMetrics) throws DeviceNotAvailableException {
        if (!this.isGcovCoverageEnabled()) {
            return;
        }
        if (this.mCollectCoverageOnTestEnd) {
            for (ITestDevice device : this.getRealDevices()) {
                this.logCoverageMeasurements(device, this.getRunName());
            }
        }
    }

    public void logCoverageMeasurements(ITestDevice device, String runName) throws DeviceNotAvailableException {
        File coverageTar = null;
        File coverageZip = null;
        try (AdbRootElevator adbRoot = new AdbRootElevator(device);){
            if (this.mConfiguration.getCoverageOptions().isCoverageFlushEnabled()) {
                this.getCoverageFlusher(device).forceCoverageFlush();
            }
            device.executeShellCommand(ZIP_COVERAGE_FILES_COMMAND);
            coverageTar = device.pullFile(COVERAGE_TAR_PATH);
            Verify.verifyNotNull(coverageTar, "Failed to pull the native code coverage file %s", COVERAGE_TAR_PATH);
            device.deleteFile(COVERAGE_TAR_PATH);
            coverageZip = this.convertTarToZip(coverageTar);
            try (FileInputStreamSource source = new FileInputStreamSource(coverageZip, true);){
                this.testLog(runName + "_native_runtime_coverage", LogDataType.NATIVE_COVERAGE, source);
            }
            device.executeShellCommand(DELETE_COVERAGE_FILES_COMMAND);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.deleteFile(coverageTar);
                FileUtil.deleteFile(coverageZip);
                throw throwable;
            }
        }
        FileUtil.deleteFile(coverageTar);
        FileUtil.deleteFile(coverageZip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File convertTarToZip(File tar) throws IOException {
        File untarDir = null;
        try {
            untarDir = FileUtil.createTempDir("gcov_coverage");
            TarUtil.unTar(tar, untarDir);
            File file2 = ZipUtil.createZip(Arrays.asList(untarDir.listFiles()), "native_coverage");
            return file2;
        }
        finally {
            FileUtil.recursiveDelete(untarDir);
        }
    }
}

