/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceRuntimeException;
import com.android.tradefed.device.INativeDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.AdbRootElevator;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.io.File;
import java.util.Map;

public final class GcovKernelCodeCoverageCollector
extends BaseDeviceMetricCollector
implements IConfigurationReceiver {
    public static final String DEBUGFS_PATH = "/sys/kernel/debug";
    public static final String CHECK_DEBUGFS_MNT_COMMAND = String.format("mountpoint -q %s", "/sys/kernel/debug");
    public static final String MOUNT_DEBUGFS_COMMAND = String.format("mount -t debugfs debugfs %s", "/sys/kernel/debug");
    public static final String UNMOUNT_DEBUGFS_COMMAND = String.format("umount %s", "/sys/kernel/debug");
    public static final String RESET_GCOV_COUNTS_COMMAND = String.format("echo 1 > %s/gcov/reset", "/sys/kernel/debug");
    public static final String MAKE_TEMP_DIR_COMMAND = "mktemp -d -p /data/local/tmp/";
    public static final String MAKE_GCDA_TEMP_DIR_COMMAND_FMT = "mkdir -p %s";
    public static final String COPY_GCOV_DATA_COMMAND_FMT = "cp -rf %s/* %s";
    public static final String TAR_GCOV_DATA_COMMAND_FMT = "tar -czf %s -C %s %s";
    private IConfiguration mConfiguration;
    private boolean mTestRunStartFail;
    private int mTestCount;

    public GcovKernelCodeCoverageCollector() {
        this.setDisableReceiver(false);
    }

    @Override
    public void setConfiguration(IConfiguration config) {
        this.mConfiguration = config;
    }

    private boolean isGcovKernelCoverageEnabled() {
        return this.mConfiguration != null && this.mConfiguration.getCoverageOptions().isCoverageEnabled() && this.mConfiguration.getCoverageOptions().getCoverageToolchains().contains((Object)CoverageOptions.Toolchain.GCOV_KERNEL);
    }

    @Override
    public void onTestRunStart(DeviceMetricData runData, int testCount) throws DeviceNotAvailableException {
        this.mTestCount = testCount;
        if (!this.isGcovKernelCoverageEnabled()) {
            return;
        }
        if (this.mTestCount == 0) {
            LogUtil.CLog.i("No tests in test run, not collecting coverage for %s.", this.getTarBasename());
            return;
        }
        try {
            for (ITestDevice device : this.getRealDevices()) {
                this.mountDebugfs(device);
                this.resetGcovCounts(device);
            }
        }
        catch (Throwable t) {
            this.mTestRunStartFail = true;
            throw t;
        }
        this.mTestRunStartFail = false;
    }

    @Override
    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) throws DeviceNotAvailableException {
        if (!this.isGcovKernelCoverageEnabled() || this.mTestCount == 0) {
            return;
        }
        if (this.mTestRunStartFail) {
            LogUtil.CLog.e("onTestRunStart failed, not collecting coverage for %s.", this.getTarBasename());
            return;
        }
        for (ITestDevice device : this.getRealDevices()) {
            this.collectGcovDebugfsCoverage(device, this.getTarBasename());
            this.unmountDebugfs(device);
        }
    }

    @Override
    public void rebootStarted(ITestDevice device) throws DeviceNotAvailableException {
        super.rebootStarted(device);
        this.collectGcovDebugfsCoverage(device, this.getTarBasename());
    }

    @Override
    public void rebootEnded(ITestDevice device) throws DeviceNotAvailableException {
        super.rebootEnded(device);
        this.mountDebugfs(device);
    }

    private String getTarBasename() {
        String collectionFilename = this.getModuleName();
        return Strings.isNullOrEmpty(collectionFilename) ? this.getRunName() : collectionFilename;
    }

    private boolean isDebugfsMounted(INativeDevice device) throws DeviceNotAvailableException {
        try (AdbRootElevator adbRoot = new AdbRootElevator(device);){
            boolean bl = device.executeShellV2Command(CHECK_DEBUGFS_MNT_COMMAND).getStatus() == CommandStatus.SUCCESS;
            return bl;
        }
    }

    private void mountDebugfs(INativeDevice device) throws DeviceNotAvailableException {
        try (AdbRootElevator adbRoot = new AdbRootElevator(device);){
            if (this.isDebugfsMounted(device)) {
                LogUtil.CLog.w("debugfs already mounted for %s.", this.getTarBasename());
                return;
            }
            CommandResult result = device.executeShellV2Command(MOUNT_DEBUGFS_COMMAND);
            if (result.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e("Failed to mount debugfs. %s", result);
                throw new DeviceRuntimeException("'" + MOUNT_DEBUGFS_COMMAND + "' has failed: " + result, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
            }
        }
    }

    private void unmountDebugfs(ITestDevice device) throws DeviceNotAvailableException {
        try (AdbRootElevator adbRoot = new AdbRootElevator(device);){
            if (!this.isDebugfsMounted(device)) {
                LogUtil.CLog.w("debugfs not mounted to unmount for %s.", this.getTarBasename());
                return;
            }
            CommandResult result = device.executeShellV2Command(UNMOUNT_DEBUGFS_COMMAND);
            if (result.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e("Failed to unmount debugfs for %s. %s", this.getTarBasename(), result);
            }
        }
    }

    private void resetGcovCounts(ITestDevice device) throws DeviceNotAvailableException {
        try (AdbRootElevator adbRoot = new AdbRootElevator(device);){
            CommandResult result = device.executeShellV2Command(RESET_GCOV_COUNTS_COMMAND);
            if (result.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e("Failed to reset gcov counts for %s. %s", this.getTarBasename(), result);
                throw new DeviceRuntimeException("'" + RESET_GCOV_COUNTS_COMMAND + "' has failed: " + result, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectGcovDebugfsCoverage(INativeDevice device, String name) throws DeviceNotAvailableException {
        try (AdbRootElevator adbRoot = new AdbRootElevator(device);){
            if (!this.isDebugfsMounted(device)) {
                String errorMessage = String.format("debugfs not mounted, unable to collect for %s.", name);
                LogUtil.CLog.e(errorMessage);
                throw new DeviceRuntimeException(errorMessage, DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            CommandResult result = device.executeShellV2Command(MAKE_TEMP_DIR_COMMAND);
            if (result.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e("Failed to create temp dir for %s. %s", name, result);
                throw new DeviceRuntimeException("'mktemp -d -p /data/local/tmp/' has failed: " + result, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
            }
            String tempDir = result.getStdout().strip();
            String gcda = "/d/gcov";
            String gcdaTempDir = tempDir + gcda;
            String makeGcdaTempDirCommand = String.format(MAKE_GCDA_TEMP_DIR_COMMAND_FMT, gcdaTempDir);
            result = device.executeShellV2Command(makeGcdaTempDirCommand);
            if (result.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e("Failed to create gcda temp directory %s. %s", gcdaTempDir, result);
                throw new DeviceRuntimeException("'" + makeGcdaTempDirCommand + "' has failed: " + result, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
            }
            String tarName = String.format("%s.tar.gz", name);
            String tarFullPath = String.format("%s/%s", tempDir, tarName);
            String copyGcovDataCommand = String.format(COPY_GCOV_DATA_COMMAND_FMT, gcda, gcdaTempDir);
            result = device.executeShellV2Command(copyGcovDataCommand);
            if (result.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e("Failed to collect coverage files for %s. %s", name, result);
                throw new DeviceRuntimeException("'" + copyGcovDataCommand + "' has failed: " + result, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
            }
            String tarCommand = String.format(TAR_GCOV_DATA_COMMAND_FMT, tarFullPath, tempDir, gcda.substring(1));
            result = device.executeShellV2Command(tarCommand);
            if (result.getStatus() != CommandStatus.SUCCESS) {
                LogUtil.CLog.e("Failed to tar collected files for %s. %s", name, result);
                throw new DeviceRuntimeException("'" + tarCommand + "' has failed: " + result, DeviceErrorIdentifier.SHELL_COMMAND_ERROR);
            }
            try {
                File coverageTar = device.pullFile(tarFullPath, 0);
                Verify.verifyNotNull(coverageTar, "Failed to pull the native kernel coverage file %s for %s", tarFullPath, name);
                try (FileInputStreamSource source = new FileInputStreamSource(coverageTar, true);){
                    String fileName = String.format("%s_%d_kernel_coverage", name, System.currentTimeMillis());
                    this.testLog(fileName, LogDataType.GCOV_KERNEL_COVERAGE, source);
                }
                finally {
                    FileUtil.deleteFile(coverageTar);
                }
            }
            finally {
                device.deleteFile(tempDir);
            }
        }
    }
}

