/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.AdbRootElevator;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.JavaCodeCoverageFlusher;
import com.android.tradefed.util.ProcessInfo;
import com.android.tradefed.util.PsParser;
import com.android.tradefed.util.TarUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jacoco.core.tools.ExecFileLoader;

public final class JavaCodeCoverageCollector
extends BaseDeviceMetricCollector
implements IConfigurationReceiver {
    public static final String MERGE_COVERAGE_MEASUREMENTS_TEST_NAME = "mergeCoverageMeasurements";
    public static final String COVERAGE_MEASUREMENT_KEY = "coverageFilePath";
    public static final String COVERAGE_DIRECTORY = "/data/misc/trace";
    public static final String FIND_COVERAGE_FILES = String.format("find %s -name '*.ec'", "/data/misc/trace");
    public static final String COMPRESS_COVERAGE_FILES = String.format("%s | tar -czf - -T - 2>/dev/null", FIND_COVERAGE_FILES);
    private ExecFileLoader mExecFileLoader;
    private JavaCodeCoverageFlusher mFlusher;
    private IConfiguration mConfiguration;
    private long mTimeoutMilli = 1200000L;

    @Override
    public void extraInit(IInvocationContext context, ITestInvocationListener listener) throws DeviceNotAvailableException {
        super.extraInit(context, listener);
        Verify.verifyNotNull(this.mConfiguration);
        this.setCoverageOptions(this.mConfiguration.getCoverageOptions());
        if (this.isJavaCoverageEnabled() && this.mConfiguration.getCoverageOptions().shouldResetCoverageBeforeTest()) {
            for (ITestDevice device : this.getRealDevices()) {
                try (AdbRootElevator adbRoot = new AdbRootElevator(device);){
                    this.getCoverageFlusher(device).resetCoverage();
                }
            }
        }
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    private JavaCodeCoverageFlusher getCoverageFlusher(ITestDevice device) {
        if (this.mFlusher == null) {
            this.mFlusher = new JavaCodeCoverageFlusher(device, this.mConfiguration.getCoverageOptions().getCoverageProcesses());
        }
        return this.mFlusher;
    }

    @VisibleForTesting
    void setCoverageFlusher(JavaCodeCoverageFlusher flusher) {
        this.mFlusher = flusher;
    }

    @Override
    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> runMetrics) throws DeviceNotAvailableException {
        if (!this.isJavaCoverageEnabled()) {
            return;
        }
        String testCoveragePath = null;
        MetricMeasurement.Metric devicePathMetric = runMetrics.get(COVERAGE_MEASUREMENT_KEY);
        if (devicePathMetric == null) {
            LogUtil.CLog.d("No Java code coverage measurement.");
        } else {
            testCoveragePath = devicePathMetric.getMeasurements().getSingleString();
            if (testCoveragePath == null) {
                LogUtil.CLog.d("No Java code coverage measurement.");
            }
        }
        for (ITestDevice device : this.getRealDevices()) {
            File testCoverage = null;
            File coverageTarGz = null;
            File untarDir = null;
            try (AdbRootElevator adbRoot = new AdbRootElevator(device);){
                if (this.mConfiguration.getCoverageOptions().isCoverageFlushEnabled()) {
                    this.getCoverageFlusher(device).forceCoverageFlush();
                }
                if (testCoveragePath != null) {
                    if (!new File(testCoveragePath).isAbsolute()) {
                        testCoveragePath = "/sdcard/googletest/internal_use/" + testCoveragePath;
                    }
                    if ((testCoverage = device.pullFile(testCoveragePath)) == null) {
                        LogUtil.CLog.w("Failed to pull test coverage file %s from the device.", testCoveragePath);
                    } else {
                        this.saveCoverageMeasurement(testCoverage);
                    }
                }
                coverageTarGz = FileUtil.createTempFile("java_coverage", ".tar.gz");
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(coverageTarGz));){
                    CommandResult result = device.executeShellV2Command(COMPRESS_COVERAGE_FILES, null, out, this.mTimeoutMilli, TimeUnit.MILLISECONDS, 1);
                    if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                        LogUtil.CLog.e("Failed to stream coverage data from the device: %s", result.toString());
                    }
                }
                untarDir = TarUtil.extractTarGzipToTemp(coverageTarGz, "java_coverage");
                for (String coveragePath : FileUtil.findFiles(untarDir, ".*\\.ec")) {
                    this.saveCoverageMeasurement(new File(coveragePath));
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    FileUtil.deleteFile(testCoverage);
                    FileUtil.deleteFile(coverageTarGz);
                    FileUtil.recursiveDelete(untarDir);
                    this.cleanUpDeviceCoverageFiles(device);
                    throw throwable;
                }
            }
            FileUtil.deleteFile(testCoverage);
            FileUtil.deleteFile(coverageTarGz);
            FileUtil.recursiveDelete(untarDir);
            this.cleanUpDeviceCoverageFiles(device);
        }
        if (this.shouldMergeCoverage() && this.mExecFileLoader != null) {
            File mergedCoverage = null;
            try {
                mergedCoverage = FileUtil.createTempFile("merged_java_coverage", ".ec");
                this.mExecFileLoader.save(mergedCoverage, false);
                this.logCoverageMeasurement(mergedCoverage);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.mExecFileLoader = null;
                FileUtil.deleteFile(mergedCoverage);
            }
        }
    }

    private void saveCoverageMeasurement(File coverageFile) throws IOException {
        if (this.shouldMergeCoverage()) {
            if (this.mExecFileLoader == null) {
                this.mExecFileLoader = new ExecFileLoader();
            }
            this.mExecFileLoader.load(coverageFile);
        } else {
            this.logCoverageMeasurement(coverageFile);
        }
    }

    private void logCoverageMeasurement(File coverageFile) {
        try (FileInputStreamSource source = new FileInputStreamSource(coverageFile, true);){
            this.testLog(this.generateMeasurementFileName(coverageFile), LogDataType.COVERAGE, source);
        }
    }

    private String generateMeasurementFileName(File coverageFile) {
        String moduleName = Strings.nullToEmpty(this.getModuleName());
        if (moduleName.length() > 0) {
            moduleName = moduleName + "_MODULE_";
        }
        return moduleName + this.getRunName() + "_" + Files.getNameWithoutExtension(coverageFile.getName()) + "_runtime_coverage";
    }

    private void cleanUpDeviceCoverageFiles(ITestDevice device) throws DeviceNotAvailableException {
        try (AdbRootElevator root = new AdbRootElevator(device);){
            List<Integer> activePids = this.getRunningProcessIds(device);
            String fileList = device.executeShellCommand(FIND_COVERAGE_FILES);
            for (String devicePath : Splitter.on('\n').omitEmptyStrings().split(fileList)) {
                if (devicePath.endsWith(".mm.ec")) {
                    int end;
                    int start = devicePath.indexOf(45) + 1;
                    int pid = Integer.parseInt(devicePath.substring(start, end = devicePath.indexOf(46)));
                    if (activePids.contains(pid)) continue;
                    device.deleteFile(devicePath);
                    continue;
                }
                device.deleteFile(devicePath);
            }
        }
    }

    private List<Integer> getRunningProcessIds(ITestDevice device) throws DeviceNotAvailableException {
        List<ProcessInfo> processes = PsParser.getProcesses(device.executeShellCommand("ps -e"));
        ArrayList<Integer> pids = new ArrayList<Integer>();
        for (ProcessInfo process : processes) {
            pids.add(process.getPid());
        }
        return pids;
    }

    private boolean isJavaCoverageEnabled() {
        return this.mConfiguration != null && this.mConfiguration.getCoverageOptions().isCoverageEnabled() && this.mConfiguration.getCoverageOptions().getCoverageToolchains().contains((Object)CoverageOptions.Toolchain.JACOCO);
    }

    private boolean shouldMergeCoverage() {
        return this.mConfiguration != null && this.mConfiguration.getCoverageOptions().shouldMergeCoverage();
    }

    private void setCoverageOptions(CoverageOptions coverageOptions) {
        this.mTimeoutMilli = coverageOptions.getPullTimeout();
    }
}

