/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.device.CollectingByteOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ILogcatReceiver;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.LogcatReceiver;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.util.HashMap;
import java.util.Map;

public class LogcatOnFailureCollector
extends BaseDeviceMetricCollector {
    private static final int MAX_LOGAT_SIZE_BYTES = 0x400000;
    private static final int OFFSET_CORRECTION = 10000;
    private static final String NAME_FORMAT = "%s-%s-logcat-on-failure";
    private static final String LOGCAT_COLLECT_CMD = "logcat -b all -T 150";
    private static final String LOGCAT_COLLECT_CMD_LEGACY = "logcat -b all -t 5000";
    private static final int API_LIMIT = 20;
    private static final int THROTTLE_LIMIT_PER_RUN = 10;
    private Map<ITestDevice, ILogcatReceiver> mLogcatReceivers = new HashMap<ITestDevice, ILogcatReceiver>();
    private Map<ITestDevice, Integer> mOffset = new HashMap<ITestDevice, Integer>();
    private int mCurrentCount = 0;
    private boolean mFirstThrottle = true;

    @Override
    public void onTestRunStart(DeviceMetricData runData) {
        this.mCurrentCount = 0;
        this.mFirstThrottle = true;
        for (ITestDevice device : this.getRealDevices()) {
            if (this.getApiLevelNoThrow(device) < 20) continue;
            this.initReceiver(device);
            InputStreamSource data = this.mLogcatReceivers.get(device).getLogcatData();
            try {
                int offset = (int)data.size();
                if (offset > 10000) {
                    offset -= 10000;
                }
                this.mOffset.put(device, offset);
            }
            finally {
                if (data == null) continue;
                data.close();
            }
        }
    }

    @Override
    public void onTestStart(DeviceMetricData testData) {
    }

    @Override
    public void onTestFail(DeviceMetricData testData, TestDescription test) throws DeviceNotAvailableException {
        if (this.mCurrentCount > 10) {
            if (this.mFirstThrottle) {
                LogUtil.CLog.w("Throttle capture of logcat-on-failure due to too many failures.");
                this.mFirstThrottle = false;
            }
            return;
        }
        this.getRunUtil().sleep(100L);
        this.collectAndLog(test.toString(), 0x400000);
        ++this.mCurrentCount;
    }

    @Override
    public void onTestRunFailed(DeviceMetricData testData, FailureDescription failure) throws DeviceNotAvailableException {
        this.getRunUtil().sleep(100L);
        this.collectAndLog("run-failure", 0x400000);
    }

    @Override
    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) {
        this.clearReceivers();
    }

    ILogcatReceiver createLogcatReceiver(ITestDevice device) {
        return new LogcatReceiver(device, LOGCAT_COLLECT_CMD, device.getOptions().getMaxLogcatDataSize(), 0);
    }

    CollectingByteOutputReceiver createLegacyCollectingReceiver() {
        return new CollectingByteOutputReceiver();
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    protected void collectAndLog(String testName, int size) throws DeviceNotAvailableException {
        for (ITestDevice device : this.getRealDevices()) {
            boolean isDeviceOnline = this.isDeviceOnline(device);
            ILogcatReceiver receiver = this.mLogcatReceivers.get(device);
            if (receiver == null) {
                if (isDeviceOnline) {
                    this.legacyCollection(device, testName);
                    continue;
                }
                LogUtil.CLog.w("Skip legacy LogcatOnFailureCollector device is offline.");
                continue;
            }
            this.saveLogcatSource(testName, receiver.getLogcatData(size, this.mOffset.get(device)), device.getSerialNumber());
        }
    }

    private void initReceiver(ITestDevice device) {
        if (this.mLogcatReceivers.get(device) == null) {
            ILogcatReceiver receiver = this.createLogcatReceiver(device);
            this.mLogcatReceivers.put(device, receiver);
            receiver.start();
        }
    }

    private void clearReceivers() {
        for (ILogcatReceiver receiver : this.mLogcatReceivers.values()) {
            receiver.stop();
            receiver.clear();
        }
        this.mLogcatReceivers.clear();
        this.mOffset.clear();
    }

    private int getApiLevelNoThrow(ITestDevice device) {
        try {
            return device.getApiLevel();
        }
        catch (DeviceNotAvailableException e) {
            return 1;
        }
    }

    private void legacyCollection(ITestDevice device, String testName) throws DeviceNotAvailableException {
        CollectingByteOutputReceiver outputReceiver = this.createLegacyCollectingReceiver();
        device.executeShellCommand(LOGCAT_COLLECT_CMD_LEGACY, outputReceiver);
        this.saveLogcatSource(testName, new ByteArrayInputStreamSource(outputReceiver.getOutput()), device.getSerialNumber());
        outputReceiver.cancel();
    }

    private void saveLogcatSource(String testName, InputStreamSource source, String serial) {
        if (source == null) {
            return;
        }
        try (InputStreamSource logcatSource = source;){
            if (logcatSource.size() < 75L) {
                LogUtil.CLog.e("Discarding logcat on failure (size=%s): it failed to collect something relevant likely due to timings.", logcatSource.size());
                return;
            }
            String name = String.format(NAME_FORMAT, testName, serial);
            super.testLog(name, LogDataType.LOGCAT, logcatSource);
        }
    }

    private boolean isDeviceOnline(ITestDevice device) {
        TestDeviceState state = device.getDeviceState();
        return TestDeviceState.ONLINE.equals((Object)state);
    }
}

