/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.LargeOutputReceiver;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.FilePullerDeviceMetricCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.Pair;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.ZipUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="perfetto-metric-collector")
public class PerfettoPullerMetricCollector
extends FilePullerDeviceMetricCollector {
    private static final String LINE_SEPARATOR = "\\r?\\n";
    private static final char KEY_VALUE_SEPARATOR = ':';
    private static final String EXTRACTOR_STATUS = "trace_extractor_status";
    private static final String PROCESSOR_STATUS = "trace_processor_status";
    private static final String STATUS_SUCCESS = "1";
    private static final String STATUS_FAILURE = "0";
    private static final String EXTRACTOR_RUNTIME = "trace_extractor_runtime";
    private static final String PROCESSOR_RUNTIME = "trace_processor_runtime";
    private static final String RAW_TRACE_FILE_SIZE = "perfetto_trace_file_size_bytes";
    private static final String NSS_CACHE_ERROR = "base/nsscache-inl.h failed to lookup";
    @Option(name="compress-perfetto", description="If enabled retrieves the perfetto compressed content,decompress for processing and upload the compressed file. Ifthis flag is not enabled uncompressed version of perfetto file ispulled, processed and uploaded.")
    private boolean mCompressPerfetto = false;
    @Option(name="max-compressed-file-size", description="Max size of the compressed perfetto file. If the compressed file size exceeds the max then post processing and uploading the compressed file will not happen.")
    private long mMaxCompressedFileSize = 10485760000L;
    @Option(name="compressed-trace-shell-timeout", description="Timeout for retrieving compressed trace content through shell", isTimeVal=true)
    private long mCompressedTimeoutMs = TimeUnit.MINUTES.toMillis(20L);
    @Option(name="compress-response-timeout", description="Timeout to receive the shell response when running the gzip command.", isTimeVal=true)
    private long mCompressResponseTimeoutMs = TimeUnit.SECONDS.toMillis(30L);
    @Option(name="decompress-perfetto-timeout", description="Timeout to decompress perfetto compressed file.", isTimeVal=true)
    private long mDecompressTimeoutMs = TimeUnit.MINUTES.toMillis(20L);
    @Option(name="perfetto-binary-path", description="Path to the script files used to analyze the trace files.Used for collecting the key value metrics from the perfettotrace file.")
    @Deprecated
    private List<File> mScriptFiles = new ArrayList<File>();
    @Option(name="perfetto-binary-args", description="Extra arguments to be passed to the binaries.")
    @Deprecated
    private List<String> mPerfettoBinaryArgs = new ArrayList<String>();
    @Option(name="perfetto-metric-prefix", description="Prefix to be used with the metrics collected from perfetto.")
    @Deprecated
    private String mMetricPrefix = "perfetto";
    @Option(name="process-name", description="Process names to be passed in perfetto script.")
    @Deprecated
    private Collection<String> mProcessNames = new ArrayList<String>();
    @Option(name="perfetto-script-timeout", description="Timeout for the perfetto script.", isTimeVal=true)
    @Deprecated
    private long mScriptTimeoutMs = TimeUnit.MINUTES.toMillis(5L);
    @Option(name="convert-metric-file", description="Convert the raw trace file to perfetto metric file.")
    private boolean mConvertToMetricFile = true;
    @Option(name="collect-perfetto-file-size", description="Set it to true to collect the perfetto file size as part of the metrics.")
    private boolean mCollectPerfettoFileSize = false;
    @Option(name="trace-processor-binary", description="Path to the trace processor shell. This will override the trace-processor-name which is used to  lookup in build artifacts. Used for converting the raw trace into perfetto metric file.")
    private File mTraceProcessorBinary = null;
    @Option(name="trace-processor-name", description="Trace processor name to look up from the test artifacts or module artifacts.")
    private String mTraceProcessorName = "trace_processor_shell";
    @Option(name="trace-processor-run-metrics", description="Comma separated list of metrics to extract from raw trace file. For example android_mem.")
    private String mTraceProcessorMetrics = "android_mem";
    @Option(name="trace-processor-output-format", description="Trace processor output format. [binary|text|json]")
    private METRIC_FILE_FORMAT mTraceProcessorOutputFormat = METRIC_FILE_FORMAT.text;
    @Option(name="trace-processor-timeout", description="Timeout to convert the raw trace file to metric proto file.", isTimeVal=true)
    private long mTraceConversionTimeout = TimeUnit.MINUTES.toMillis(20L);

    @Override
    public void processMetricFile(String key, File metricFile, DeviceMetricData data) {
        File processSrcFile = metricFile;
        if (this.mCompressPerfetto) {
            processSrcFile = this.decompressFile(metricFile);
        }
        if (processSrcFile != null && this.mCollectPerfettoFileSize) {
            double perfettoFileSizeInBytes = processSrcFile.length();
            MetricMeasurement.Metric.Builder metricDurationBuilder = MetricMeasurement.Metric.newBuilder();
            metricDurationBuilder.getMeasurementsBuilder().setSingleDouble(perfettoFileSizeInBytes);
            data.addMetric(RAW_TRACE_FILE_SIZE, metricDurationBuilder.setType(MetricMeasurement.DataType.RAW));
        }
        if (this.mConvertToMetricFile) {
            TraceProcessorResult result = this.convertToMetricProto(processSrcFile);
            File convertedMetricFile = result.file;
            if (convertedMetricFile != null) {
                try (FileInputStreamSource source = new FileInputStreamSource(convertedMetricFile, true);){
                    this.testLog(convertedMetricFile.getName(), this.getLogDataType(), source);
                }
            }
            MetricMeasurement.Metric.Builder processorRuntimeBuilder = MetricMeasurement.Metric.newBuilder();
            processorRuntimeBuilder.getMeasurementsBuilder().setSingleDouble(result.runtime);
            data.addMetric(String.format("%s_%s", this.mMetricPrefix, PROCESSOR_RUNTIME), processorRuntimeBuilder.setType(MetricMeasurement.DataType.RAW));
            MetricMeasurement.Metric.Builder processorStatusBuilder = MetricMeasurement.Metric.newBuilder();
            processorStatusBuilder.getMeasurementsBuilder().setSingleString(result.status);
            data.addMetric(String.format("%s_%s", this.mMetricPrefix, PROCESSOR_STATUS), processorStatusBuilder.setType(MetricMeasurement.DataType.RAW));
        }
        if (processSrcFile != null) {
            for (File scriptFile : this.mScriptFiles) {
                FileUtil.chmodGroupRWX(scriptFile);
                ArrayList<String> commandArgsList = new ArrayList<String>();
                commandArgsList.add(scriptFile.getAbsolutePath());
                commandArgsList.addAll(this.mPerfettoBinaryArgs);
                commandArgsList.add("-trace_file");
                commandArgsList.add(processSrcFile.getAbsolutePath());
                if (!this.mProcessNames.isEmpty()) {
                    commandArgsList.add("-process_names");
                    commandArgsList.add(String.join((CharSequence)",", this.mProcessNames));
                }
                String traceExtractorStatus = STATUS_SUCCESS;
                double scriptDuration = 0.0;
                double scriptStartTime = System.currentTimeMillis();
                CommandResult cr = this.runHostCommand(this.mScriptTimeoutMs, commandArgsList.toArray(new String[commandArgsList.size()]), null, null);
                scriptDuration = (double)System.currentTimeMillis() - scriptStartTime;
                MetricMeasurement.Metric.Builder metricDurationBuilder = MetricMeasurement.Metric.newBuilder();
                metricDurationBuilder.getMeasurementsBuilder().setSingleDouble(scriptDuration);
                data.addMetric(String.format("%s_%s", this.mMetricPrefix, EXTRACTOR_RUNTIME), metricDurationBuilder.setType(MetricMeasurement.DataType.RAW));
                if (CommandStatus.SUCCESS.equals((Object)cr.getStatus()) || CommandStatus.FAILED.equals((Object)cr.getStatus()) && cr.getStdout().contains(NSS_CACHE_ERROR)) {
                    String[] metrics = cr.getStdout().split(LINE_SEPARATOR);
                    boolean isMetricStarted = false;
                    for (String metric : metrics) {
                        if (!isMetricStarted && !metric.contains("trace-duration-ms")) continue;
                        isMetricStarted = true;
                        Pair<String, String> kv = PerfettoPullerMetricCollector.splitKeyValue(metric);
                        if (kv != null) {
                            MetricMeasurement.Metric.Builder metricBuilder = MetricMeasurement.Metric.newBuilder();
                            metricBuilder.getMeasurementsBuilder().setSingleString((String)kv.second);
                            data.addMetric(String.format("%s_%s", this.mMetricPrefix, kv.first), metricBuilder.setType(MetricMeasurement.DataType.RAW));
                            continue;
                        }
                        LogUtil.CLog.e("Output %s not in the expected format.", metric);
                    }
                    LogUtil.CLog.i(cr.getStdout());
                } else {
                    traceExtractorStatus = STATUS_FAILURE;
                    LogUtil.CLog.e("Unable to parse the trace file %s due to %s - Status - %s ", new Object[]{processSrcFile.getName(), cr.getStderr(), cr.getStatus()});
                }
                if (this.mCompressPerfetto) {
                    processSrcFile.delete();
                }
                MetricMeasurement.Metric.Builder metricStatusBuilder = MetricMeasurement.Metric.newBuilder();
                metricStatusBuilder.getMeasurementsBuilder().setSingleString(traceExtractorStatus);
                data.addMetric(String.format("%s_%s", this.mMetricPrefix, EXTRACTOR_STATUS), metricStatusBuilder.setType(MetricMeasurement.DataType.RAW));
            }
        }
        try (FileInputStreamSource source = new FileInputStreamSource(metricFile, true);){
            if (this.mCompressPerfetto) {
                if (processSrcFile != null) {
                    this.testLog(metricFile.getName(), LogDataType.GZIP, source);
                } else {
                    metricFile.delete();
                }
            } else {
                this.testLog(metricFile.getName(), LogDataType.PERFETTO, source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraceProcessorResult convertToMetricProto(File perfettoRawTraceFile) {
        long runtime;
        File metricOutputFile;
        block27: {
            if (this.mTraceProcessorBinary == null) {
                this.mTraceProcessorBinary = this.getFileFromTestArtifacts(this.mTraceProcessorName);
            }
            metricOutputFile = null;
            runtime = -1L;
            if (this.mTraceProcessorBinary == null) {
                LogUtil.CLog.e("Failed to locate the trace processor shell binary file.");
                return new TraceProcessorResult(metricOutputFile, runtime, STATUS_FAILURE);
            }
            FileUtil.chmodGroupRWX(this.mTraceProcessorBinary);
            ArrayList<String> commandArgsList = new ArrayList<String>();
            commandArgsList.add(this.mTraceProcessorBinary.getAbsolutePath());
            if (!this.mTraceProcessorMetrics.isEmpty()) {
                commandArgsList.add("--run-metrics");
                commandArgsList.add(this.mTraceProcessorMetrics);
            }
            commandArgsList.add("--metrics-output=" + (Object)((Object)this.mTraceProcessorOutputFormat));
            commandArgsList.add(perfettoRawTraceFile.getAbsolutePath());
            try {
                metricOutputFile = FileUtil.createTempFile("metric_" + this.getRawTraceFileName(perfettoRawTraceFile.getName()), "");
            }
            catch (IOException e) {
                LogUtil.CLog.e("Not able to create metric perfetto output file.");
                LogUtil.CLog.e(e);
                return new TraceProcessorResult(null, runtime, STATUS_FAILURE);
            }
            LogUtil.CLog.i("Run the trace convertor.");
            boolean isConversionSuccess = true;
            try (FileOutputStream outStream = new FileOutputStream(metricOutputFile);
                 ByteArrayOutputStream errStream = new ByteArrayOutputStream();){
                long startTime = System.currentTimeMillis();
                CommandResult conversionResult = this.runHostCommand(this.mTraceConversionTimeout, commandArgsList.toArray(new String[commandArgsList.size()]), outStream, errStream);
                runtime = System.currentTimeMillis() - startTime;
                if (!CommandStatus.SUCCESS.equals((Object)conversionResult.getStatus())) {
                    LogUtil.CLog.e("Unable to convert the raw trace - %s to metric file due to %s - Status - %s ", new Object[]{perfettoRawTraceFile.getName(), errStream.toString(), conversionResult.getStatus()});
                    isConversionSuccess = false;
                } else if (this.mTraceProcessorOutputFormat.equals((Object)METRIC_FILE_FORMAT.text) || this.mTraceProcessorOutputFormat.equals((Object)METRIC_FILE_FORMAT.json)) {
                    File compressedFile = this.getCompressedFile(metricOutputFile);
                    metricOutputFile.delete();
                    TraceProcessorResult traceProcessorResult = new TraceProcessorResult(compressedFile, runtime, STATUS_SUCCESS);
                    return traceProcessorResult;
                }
            }
            catch (FileNotFoundException e) {
                LogUtil.CLog.e("Not able to find the result metric file to write the metric output.");
                LogUtil.CLog.e(e);
                isConversionSuccess = false;
                return isConversionSuccess;
            }
            catch (IOException e1) {
                LogUtil.CLog.e("Unable to close the streams.");
                LogUtil.CLog.e(e1);
                isConversionSuccess = false;
                return isConversionSuccess;
            }
            finally {
                if (isConversionSuccess) break block27;
                metricOutputFile.delete();
                return new TraceProcessorResult(null, runtime, STATUS_FAILURE);
            }
        }
        return new TraceProcessorResult(metricOutputFile, runtime, STATUS_SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File retrieveFile(ITestDevice device, String remoteFilePath, int userId) throws DeviceNotAvailableException {
        if (!this.mCompressPerfetto) {
            return super.retrieveFile(device, remoteFilePath, userId);
        }
        File perfettoCompressedFile = null;
        String filePathInDevice = remoteFilePath;
        LogUtil.CLog.i("Retrieving the compressed perfetto trace content from device.");
        LargeOutputReceiver compressedOutputReceiver = new LargeOutputReceiver("perfetto_compressed_temp", device.getSerialNumber(), this.mMaxCompressedFileSize);
        device.executeShellCommand(String.format("gzip -c %s", filePathInDevice), compressedOutputReceiver, this.mCompressedTimeoutMs, this.mCompressResponseTimeoutMs, TimeUnit.MILLISECONDS, 1);
        compressedOutputReceiver.flush();
        compressedOutputReceiver.cancel();
        try (InputStreamSource largeStreamSrc = compressedOutputReceiver.getData();
             InputStream inputStream = largeStreamSrc.createInputStream();){
            perfettoCompressedFile = FileUtil.createTempFile("perfetto_compressed", ".gz");
            FileOutputStream outStream = new FileOutputStream(perfettoCompressedFile);
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) > -1) {
                outStream.write(buffer, 0, bytesRead);
            }
            StreamUtil.close(outStream);
            LogUtil.CLog.i("Successfully copied the compressed content from device to host.");
        }
        catch (IOException e) {
            if (perfettoCompressedFile != null) {
                perfettoCompressedFile.delete();
            }
            LogUtil.CLog.e("Failed to copy compressed perfetto to temporary file.");
            LogUtil.CLog.e(e);
        }
        finally {
            compressedOutputReceiver.delete();
        }
        return perfettoCompressedFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File decompressFile(File compressedFile) {
        File decompressedFile = null;
        try {
            decompressedFile = FileUtil.createTempFile("perfetto_decompressed", ".pb");
        }
        catch (IOException e) {
            LogUtil.CLog.e("Not able to create decompressed perfetto file.");
            LogUtil.CLog.e(e);
            return null;
        }
        ArrayList<String> decompressArgsList = new ArrayList<String>();
        decompressArgsList.add("gzip");
        decompressArgsList.add("-k");
        decompressArgsList.add("-c");
        decompressArgsList.add("-d");
        decompressArgsList.add(compressedFile.getAbsolutePath());
        LogUtil.CLog.i("Start decompressing the perfetto trace file.");
        try (FileOutputStream outStream = new FileOutputStream(decompressedFile);
             ByteArrayOutputStream errStream = new ByteArrayOutputStream();){
            CommandResult decompressResult = this.runHostCommand(this.mDecompressTimeoutMs, decompressArgsList.toArray(new String[decompressArgsList.size()]), outStream, errStream);
            if (!CommandStatus.SUCCESS.equals((Object)decompressResult.getStatus())) {
                LogUtil.CLog.e("Unable decompress the metric file %s due to %s - Status - %s ", new Object[]{compressedFile.getName(), errStream.toString(), decompressResult.getStatus()});
                decompressedFile.delete();
                File file2 = null;
                return file2;
            }
        }
        catch (FileNotFoundException e) {
            LogUtil.CLog.e("Not able to find the decompressed file to copy the decompressed contents.");
            LogUtil.CLog.e(e);
            return null;
        }
        catch (IOException e1) {
            LogUtil.CLog.e("Unable to close the streams.");
            LogUtil.CLog.e(e1);
        }
        LogUtil.CLog.i("Successfully decompressed the perfetto trace file.");
        return decompressedFile;
    }

    @Override
    public void processMetricDirectory(String key, File metricDirectory, DeviceMetricData runData) {
    }

    CommandResult runHostCommand(long timeOut, String[] commandArgs, OutputStream stdout, OutputStream stderr) {
        if (stdout != null && stderr != null) {
            return RunUtil.getDefault().runTimedCmd(timeOut, stdout, stderr, commandArgs);
        }
        return RunUtil.getDefault().runTimedCmd(timeOut, commandArgs);
    }

    static Pair<String, String> splitKeyValue(String s) {
        int separatorIdx = s.lastIndexOf(58);
        if (separatorIdx > 0 && separatorIdx + 1 < s.length()) {
            return new Pair<String, String>(s.substring(0, separatorIdx), s.substring(separatorIdx + 1));
        }
        return null;
    }

    private LogDataType getLogDataType() {
        if (this.mTraceProcessorOutputFormat.equals((Object)METRIC_FILE_FORMAT.text)) {
            return LogDataType.ZIP;
        }
        if (this.mTraceProcessorOutputFormat.equals((Object)METRIC_FILE_FORMAT.binary)) {
            return LogDataType.PB;
        }
        return LogDataType.TEXT;
    }

    private String getRawTraceFileName(String rawTraceFileName) {
        int lastIndex = rawTraceFileName.lastIndexOf("_");
        if (lastIndex != -1) {
            return rawTraceFileName.substring(0, lastIndex + 1);
        }
        return rawTraceFileName;
    }

    IBuildInfo getCurrentBuildInfo() {
        return this.getBuildInfos().get(0);
    }

    File getCompressedFile(File metricOutputFile) throws IOException {
        return ZipUtil.createZip(metricOutputFile, metricOutputFile.getName());
    }

    public static enum METRIC_FILE_FORMAT {
        text,
        binary,
        json;

    }

    private static class TraceProcessorResult {
        public final File file;
        public final long runtime;
        public final String status;

        public TraceProcessorResult(File file2, long runtime, String status) {
            this.file = file2;
            this.runtime = runtime;
            this.status = status;
        }
    }
}

