/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;

public class ScreenshotOnFailureCollector
extends BaseDeviceMetricCollector {
    private static final String NAME_FORMAT = "%s-%s-screenshot-on-failure";
    private static final int THROTTLE_LIMIT_PER_RUN = 10;
    private int mCurrentCount = 0;
    private boolean mFirstThrottle = true;

    @Override
    public void onTestRunStart(DeviceMetricData runData) {
        this.mCurrentCount = 0;
        this.mFirstThrottle = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTestFail(DeviceMetricData testData, TestDescription test) throws DeviceNotAvailableException {
        if (this.mCurrentCount > 10) {
            if (this.mFirstThrottle) {
                LogUtil.CLog.w("Throttle capture of screenshot-on-failure due to too many failures.");
                this.mFirstThrottle = false;
            }
            return;
        }
        for (ITestDevice device : this.getRealDevices()) {
            if (!this.shouldCollect(device)) continue;
            ITestDevice.RecoveryMode mode = device.getRecoveryMode();
            device.setRecoveryMode(ITestDevice.RecoveryMode.NONE);
            try {
                InputStreamSource screenSource = device.getScreenshot();
                try {
                    super.testLog(String.format(NAME_FORMAT, test.toString(), device.getSerialNumber()), LogDataType.PNG, screenSource);
                }
                finally {
                    if (screenSource == null) continue;
                    screenSource.close();
                }
            }
            finally {
                device.setRecoveryMode(mode);
            }
        }
        ++this.mCurrentCount;
    }

    private boolean shouldCollect(ITestDevice device) {
        TestDeviceState state = device.getDeviceState();
        if (!TestDeviceState.ONLINE.equals((Object)state)) {
            LogUtil.CLog.d("Skip ScreenshotOnFailureCollector device is in state '%s'", new Object[]{state});
            return false;
        }
        return true;
    }
}

