/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.FilePullerDeviceMetricCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@OptionClass(alias="showmap-metric-collector")
public class ShowmapPullerMetricCollector
extends FilePullerDeviceMetricCollector {
    private static final String PROCESS_NAME_REGEX = "(>>>\\s)(\\S+)(\\s.*<<<)";
    private static final String METRIC_START_END_TEXT = "------";
    private static final String METRIC_VALUE_SEPARATOR = "_";
    private static final String METRIC_UNIT = "bytes";
    private static final Set<String> SKIP_COLUMNS = ImmutableSet.of("flags", "object", "locked");
    private Boolean processFound = false;
    private String processName = null;
    private Map<String, Long> mGranularInfo = new HashMap<String, Long>();
    private Set<String> mProcessObjInfo = new HashSet<String>();
    private Map<String, Integer> mColumnNameToColumnIndex = new HashMap<String, Integer>();
    @Option(name="showmap-metric-prefix", description="Prefix to be used with the metrics collected from showmap.")
    private String mMetricPrefix = "showmap_granular";
    @Option(name="showmap-process-name", description="Process names to be parsed in showmap file.")
    private Collection<String> mProcessNames = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMetricFile(String key, File metricFile, DeviceMetricData data) {
        Boolean metricFound = false;
        if (metricFile != null) {
            ArrayList<String> headerList = new ArrayList<String>();
            try (BufferedReader mBufferReader = new BufferedReader(new FileReader(metricFile));){
                String line;
                while ((line = mBufferReader.readLine()) != null) {
                    if (!this.processFound.booleanValue()) {
                        this.processFound = this.isProcessFound(line);
                        continue;
                    }
                    Boolean bl = metricFound = metricFound != false ? this.computeGranularMetrics(line, this.processName) : this.isMetricParsingStartEnd(line);
                    if (!this.mColumnNameToColumnIndex.isEmpty()) continue;
                    if (!metricFound.booleanValue()) {
                        headerList.add(line);
                        continue;
                    }
                    if (!metricFound.booleanValue()) continue;
                    this.extractHeaders(line, headerList);
                }
            }
            catch (IOException e) {
                LogUtil.CLog.e("Error parsing showmap granular metrics");
                LogUtil.CLog.e(e);
            }
            finally {
                this.writeGranularMetricData(data);
                this.uploadMetricFile(metricFile);
            }
        }
    }

    @Override
    public void processMetricDirectory(String key, File metricDirectory, DeviceMetricData runData) {
    }

    private String getShowmapFileName(String showmapFileName) {
        int lastIndex = showmapFileName.lastIndexOf(METRIC_VALUE_SEPARATOR);
        if (lastIndex != -1) {
            return showmapFileName.substring(0, lastIndex + 1);
        }
        return showmapFileName;
    }

    private Boolean computeGranularMetrics(String line, String processName) {
        String objectName;
        if (this.isMetricParsingStartEnd(line).booleanValue()) {
            this.computeObjectsPerProcess(processName);
            this.processFound = false;
            return false;
        }
        String[] metricLine = line.trim().split("\\s+");
        try {
            objectName = metricLine[this.mColumnNameToColumnIndex.get("object")];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LogUtil.CLog.e("Error parsing granular metrics for %s", processName);
            this.computeObjectsPerProcess(processName);
            this.processFound = false;
            return false;
        }
        for (Map.Entry<String, Integer> entry : this.mColumnNameToColumnIndex.entrySet()) {
            long mGranularValue;
            String memName = entry.getKey();
            if (SKIP_COLUMNS.contains(memName)) continue;
            try {
                mGranularValue = Long.parseLong(metricLine[this.mColumnNameToColumnIndex.get(memName)]) * 1024L;
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.e("Error parsing granular metrics for %s", processName);
                this.computeObjectsPerProcess(processName);
                this.processFound = false;
                return false;
            }
            String completeGranularMetric = String.join((CharSequence)METRIC_VALUE_SEPARATOR, this.mMetricPrefix, memName, METRIC_UNIT, processName, objectName);
            long metricCounter = this.mGranularInfo.containsKey(completeGranularMetric) ? this.mGranularInfo.get(completeGranularMetric) : 0L;
            this.mGranularInfo.put(completeGranularMetric, metricCounter + mGranularValue);
        }
        this.mProcessObjInfo.add(objectName);
        return true;
    }

    private void writeGranularMetricData(DeviceMetricData data) {
        for (Map.Entry<String, Long> granularData : this.mGranularInfo.entrySet()) {
            MetricMeasurement.Metric.Builder metricBuilder = MetricMeasurement.Metric.newBuilder();
            metricBuilder.getMeasurementsBuilder().setSingleInt(granularData.getValue());
            data.addMetric(String.format("%s", granularData.getKey()), metricBuilder.setType(MetricMeasurement.DataType.RAW));
        }
    }

    private void uploadMetricFile(File uploadFile) {
        try (FileInputStreamSource source = new FileInputStreamSource(uploadFile, true);){
            this.testLog(this.getShowmapFileName(uploadFile.getName()), LogDataType.TEXT, source);
        }
    }

    private void extractHeaders(String hyphens, List<String> headerList) {
        List steps = Stream.of(hyphens.trim().split("\\s")).map(s -> s.length()).collect(Collectors.toList());
        int columnStart = 0;
        for (int i = 0; i < steps.size(); ++i) {
            int columnEnd = columnStart + (Integer)steps.get(i) + 1;
            String header = "";
            for (String row : headerList) {
                String h;
                header = header.concat(h.substring(columnStart > (h = row.toLowerCase()).length() ? h.length() : columnStart, columnEnd > h.length() ? h.length() : columnEnd).trim());
            }
            columnStart = columnEnd;
            this.mColumnNameToColumnIndex.put(header, i);
        }
    }

    private Boolean isMetricParsingStartEnd(String line) {
        if (line.contains(METRIC_START_END_TEXT)) {
            return true;
        }
        return false;
    }

    private Boolean isProcessFound(String line) {
        if (this.mProcessNames.isEmpty()) {
            return false;
        }
        Pattern psPattern = Pattern.compile(PROCESS_NAME_REGEX);
        Matcher psMatcher = psPattern.matcher(line);
        if (psMatcher.find()) {
            this.processName = psMatcher.group(2);
            boolean psResult = this.mProcessNames.contains(this.processName);
            return psResult;
        }
        return false;
    }

    private void computeObjectsPerProcess(String processName) {
        String objCounterMetric = String.join((CharSequence)METRIC_VALUE_SEPARATOR, this.mMetricPrefix, processName, "total_object_count");
        if (this.mProcessObjInfo.size() > 0) {
            this.mGranularInfo.put(objCounterMetric, Long.valueOf(this.mProcessObjInfo.size()));
            this.mProcessObjInfo.clear();
        }
    }
}

