/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.ddmlib.NullOutputReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.AtraceCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.LogDataType;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="trace-cmd")
public class TraceCmdCollector
extends AtraceCollector {
    @Option(name="trace-cmd-binary", description="The path on the device of the trace-cmd binary to use")
    private String mTraceCmdBinary = null;
    @Option(name="trace-cmd-recording-args", description="The flags to pass to 'trace-cmd record'")
    private String mTraceCmdRecordArgs = "-e sched:sched_waking -e sched:sched_wakeup -e sched:sched_wakeup_new -e sched:sched_switch -e power:cpu_idle -e power:cpu_frequency -e power:cpu_frequency_limits -e power:suspend_resume -e power:clock_set_rate -e power:clock_enable -e power:clock_disable -b 12000 -C boot -s 10000000 ";

    @Override
    protected LogDataType getLogType() {
        return LogDataType.KERNEL_TRACE;
    }

    @Override
    protected void startTracing(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mTraceCmdBinary == null) {
            LogUtil.CLog.w("--trace-cmd-binary was not set, skipping trace metric collection");
            return;
        }
        super.startTracing(device);
        StringBuilder traceCmd = new StringBuilder(100);
        traceCmd.append("nohup ");
        traceCmd.append(this.mTraceCmdBinary);
        traceCmd.append(" record -o ");
        traceCmd.append(this.fullLogPath());
        traceCmd.append(" ");
        traceCmd.append(this.mTraceCmdRecordArgs);
        traceCmd.append(" > /dev/null 2>&1 &");
        LogUtil.CLog.i("Issuing trace-cmd: %s ", traceCmd.toString());
        CollectingOutputReceiver c = new CollectingOutputReceiver();
        device.executeShellCommand("chmod +x " + this.mTraceCmdBinary, c, 1L, TimeUnit.SECONDS, 1);
        device.executeShellCommand(traceCmd.toString(), c, 1L, TimeUnit.SECONDS, 1);
    }

    @Override
    protected void stopTracing(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mTraceCmdBinary == null) {
            LogUtil.CLog.w("trace-cmd was not set, skipping attempt to stop trace collection");
            return;
        }
        LogUtil.CLog.i("Collecting trace-cmd log from device: " + device.getSerialNumber());
        device.executeShellCommand("for PID in $(pidof trace-cmd); do while kill -s sigint $PID; do sleep 0.3; done; done;", new NullOutputReceiver(), 60L, TimeUnit.SECONDS, 1);
    }
}

