/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.recovery;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.recovery.RunConfigDeviceRecovery;

@OptionClass(alias="battery-level-recovery")
public class BatteryRechargeDeviceRecovery
extends RunConfigDeviceRecovery {
    @Option(name="min-battery", description="only run this test on a device whose battery level is lower than the given amount. Scale: 0-100")
    private Integer mMinBattery = null;

    @Override
    public boolean shouldSkip(IManagedTestDevice device) {
        if (this.mMinBattery == null) {
            return true;
        }
        TestDeviceState state = device.getDeviceState();
        if (TestDeviceState.FASTBOOT.equals((Object)state) || TestDeviceState.FASTBOOTD.equals((Object)state)) {
            return true;
        }
        Integer level = device.getBattery();
        return level == null || level == 0 || level >= this.mMinBattery;
    }
}

