/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.recovery;

import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.FreeDeviceState;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.IMultiDeviceRecovery;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.QuotationAwareTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class RunConfigDeviceRecovery
implements IMultiDeviceRecovery {
    @Option(name="disable", description="Completely disable the recoverer.")
    private boolean mDisable = false;
    @Option(name="recovery-config-name", description="The configuration to be used on the device to recover.", mandatory=true)
    private String mRecoveryConfigName = null;
    @Option(name="extra-arg", description="Extra arguments to be passed to the recovery invocation.")
    private List<String> mExtraArgs = new ArrayList<String>();

    @Override
    public void recoverDevices(List<IManagedTestDevice> managedDevices) {
        if (this.mDisable) {
            return;
        }
        for (IManagedTestDevice device : managedDevices) {
            if (DeviceAllocationState.Allocated.equals(device.getAllocationState()) || device.getIDevice() instanceof StubDevice && !(device.getIDevice() instanceof DeviceManager.FastbootDevice) || this.shouldSkip(device)) continue;
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(this.mRecoveryConfigName);
            List<String> deviceExtraArgs = this.getExtraArguments(device);
            if (deviceExtraArgs == null) {
                LogUtil.CLog.w("Something went wrong recovery cannot be attempted.");
                continue;
            }
            argList.addAll(deviceExtraArgs);
            for (String args : this.mExtraArgs) {
                String[] extraArgs = QuotationAwareTokenizer.tokenizeLine(args);
                if (extraArgs.length == 0) continue;
                argList.addAll(Arrays.asList(extraArgs));
            }
            String serial = device.getSerialNumber();
            ITestDevice deviceToRecover = this.getDeviceManager().forceAllocateDevice(serial);
            if (deviceToRecover == null) {
                LogUtil.CLog.e("Fail to force allocate '%s'", serial);
                continue;
            }
            LogUtil.CLog.d("Triggering recovery invocation on '%s' with '%s'", serial, argList);
            try {
                this.getCommandScheduler().execCommand((ICommandScheduler.IScheduledInvocationListener)new FreeDeviceHandler(this.getDeviceManager()), deviceToRecover, argList.toArray(new String[0]));
            }
            catch (ConfigurationException e) {
                LogUtil.CLog.e("Failed to execute the recovery config");
                LogUtil.CLog.e(e);
                this.getDeviceManager().freeDevice(device, FreeDeviceState.UNAVAILABLE);
                return;
            }
        }
    }

    public List<String> getExtraArguments(ITestDevice device) {
        return new ArrayList<String>();
    }

    public boolean shouldSkip(IManagedTestDevice device) {
        return false;
    }

    protected IDeviceManager getDeviceManager() {
        return GlobalConfiguration.getInstance().getDeviceManager();
    }

    protected ICommandScheduler getCommandScheduler() {
        return GlobalConfiguration.getInstance().getCommandScheduler();
    }

    private class FreeDeviceHandler
    implements ICommandScheduler.IScheduledInvocationListener {
        private final IDeviceManager mDeviceManager;

        FreeDeviceHandler(IDeviceManager deviceManager) {
            this.mDeviceManager = deviceManager;
        }

        @Override
        public void invocationComplete(IInvocationContext context, Map<ITestDevice, FreeDeviceState> devicesStates) {
            for (ITestDevice device : context.getDevices()) {
                this.mDeviceManager.freeDevice(device, devicesStates.get(device));
                if (!(device instanceof IManagedTestDevice)) continue;
                ((IManagedTestDevice)device).setFastbootPath(this.mDeviceManager.getFastbootPath());
            }
        }
    }
}

