/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.recovery;

import com.android.ddmlib.IDevice;
import com.android.helper.aoa.UsbDevice;
import com.android.helper.aoa.UsbException;
import com.android.helper.aoa.UsbHelper;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.DeviceManager;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.FastbootHelper;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.IMultiDeviceRecovery;
import com.android.tradefed.device.INativeDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Set;

@OptionClass(alias="usb-recovery")
public class UsbResetMultiDeviceRecovery
implements IMultiDeviceRecovery {
    @Option(name="disable", description="Disable the device recoverer.")
    private boolean mDisable = false;
    @Option(name="only-reset-unmanaged", description="Only reset the device that are not currently managed by Tradefed.")
    private boolean mOnlyResetUnmanaged = false;
    private String mFastbootPath = "fastboot";

    @Override
    public void setFastbootPath(String fastbootPath) {
        this.mFastbootPath = fastbootPath;
    }

    @Override
    public void recoverDevices(List<IManagedTestDevice> devices) {
        if (this.mDisable) {
            return;
        }
        ImmutableMap managedDeviceMap = Maps.uniqueIndex(devices, INativeDevice::getSerialNumber);
        try (UsbHelper usb = this.getUsbHelper();){
            Set<String> deviceSerials = usb.getSerialNumbers(true);
            FastbootHelper fastboot = this.getFastbootHelper();
            Set<String> fastbootSerials = fastboot.getBootloaderAndFastbootdDevices().keySet();
            deviceSerials.addAll(fastbootSerials);
            for (IManagedTestDevice device : devices) {
                if (this.shouldReset(device)) continue;
                deviceSerials.remove(device.getSerialNumber());
            }
            for (String serial : deviceSerials) {
                UsbDevice device = usb.getDevice(serial);
                try {
                    if (this.mOnlyResetUnmanaged && managedDeviceMap.containsKey(serial)) continue;
                    if (device == null) {
                        LogUtil.CLog.w("Device '%s' not found during USB reset.", serial);
                        continue;
                    }
                    LogUtil.CLog.d("Resetting USB port for device '%s'", serial);
                    device.reset();
                    if (!managedDeviceMap.containsKey(serial)) continue;
                    this.tryReboot((IManagedTestDevice)managedDeviceMap.get(serial));
                }
                finally {
                    if (device == null) continue;
                    device.close();
                }
            }
        }
        catch (UsbException e) {
            LogUtil.CLog.w("Failed to reset USB ports.");
            LogUtil.CLog.e(e);
        }
    }

    private boolean shouldReset(IManagedTestDevice device) {
        IDevice iDevice = device.getIDevice();
        if (iDevice instanceof StubDevice && !(iDevice instanceof DeviceManager.FastbootDevice)) {
            return false;
        }
        DeviceAllocationState state = device.getAllocationState();
        return !DeviceAllocationState.Allocated.equals(state) && !DeviceAllocationState.Available.equals(state);
    }

    private void tryReboot(IManagedTestDevice device) {
        try {
            device.reboot();
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.w("Device '%s' did not come back online after USB reset.", device.getSerialNumber());
            LogUtil.CLog.e(e);
        }
    }

    @VisibleForTesting
    FastbootHelper getFastbootHelper() {
        return new FastbootHelper(RunUtil.getDefault(), this.mFastbootPath);
    }

    @VisibleForTesting
    UsbHelper getUsbHelper() {
        return new UsbHelper();
    }
}

