/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.recovery;

import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceAllocationState;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.recovery.RunConfigDeviceRecovery;
import java.util.HashSet;
import java.util.Set;

@OptionClass(alias="usb-reset-recovery")
public class UsbResetRunConfigRecovery
extends RunConfigDeviceRecovery {
    private Set<String> mLastInvoked = new HashSet<String>();

    @Override
    public boolean shouldSkip(IManagedTestDevice device) {
        if (TestDeviceState.RECOVERY.equals((Object)device.getDeviceState())) {
            return true;
        }
        boolean res = device.isStateBootloaderOrFastbootd();
        if (!res && DeviceAllocationState.Available.equals(device.getAllocationState())) {
            res = true;
        }
        if (!res) {
            return this.checkRanBefore(device);
        }
        return true;
    }

    private boolean checkRanBefore(IManagedTestDevice device) {
        String serial = device.getSerialNumber();
        if (!this.mLastInvoked.add(serial)) {
            this.mLastInvoked.remove(serial);
            return true;
        }
        return false;
    }
}

