/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.error;

import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.result.error.ErrorIdentifier;

public class HarnessException
extends Exception
implements IHarnessException {
    static final long serialVersionUID = 100L;
    private String mOrigin;
    private ErrorIdentifier mErrorId;

    public HarnessException(ErrorIdentifier errorId) {
        this.mErrorId = errorId;
        this.setCallerClass(StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass());
    }

    public HarnessException(String message2, ErrorIdentifier errorId) {
        super(message2);
        this.mErrorId = errorId;
        this.setCallerClass(StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass());
    }

    public HarnessException(Throwable cause, ErrorIdentifier errorId) {
        super(cause);
        this.mErrorId = errorId;
        this.setCallerClass(StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass());
    }

    public HarnessException(String message2, Throwable cause, ErrorIdentifier errorId) {
        super(message2, cause);
        this.mErrorId = errorId;
        if (this.mErrorId == null && cause != null && cause instanceof IHarnessException) {
            this.mErrorId = ((IHarnessException)((Object)cause)).getErrorId();
        }
        this.setCallerClass(StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass());
    }

    @Override
    public ErrorIdentifier getErrorId() {
        return this.mErrorId;
    }

    @Override
    public String getOrigin() {
        return this.mOrigin;
    }

    protected final void setCallerClass(Class<?> clazz) {
        if (clazz != null) {
            this.mOrigin = clazz.getCanonicalName();
        }
    }

    protected final void setCallerClass(String clazz) {
        if (clazz != null && this.mOrigin == null) {
            this.mOrigin = clazz;
        }
    }

    @Override
    public String toString() {
        String message2;
        String s = this.getClass().getName();
        if (this.mErrorId != null) {
            s = s + "[" + this.mErrorId.name() + "|" + this.mErrorId.code() + "|" + this.mErrorId.status() + "]";
        }
        return (message2 = this.getLocalizedMessage()) != null ? s + ": " + message2 : s;
    }
}

