/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.host;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.RunInterruptedException;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;

@OptionClass(alias="host_options", global_namespace=false)
public class HostOptions
implements IHostOptions {
    @Option(name="concurrent-flasher-limit", description="The maximum number of concurrent flashers (may be useful to avoid memory constraints)")
    private Integer mConcurrentFlasherLimit = 1;
    @Option(name="concurrent-download-limit", description="The maximum number of concurrent downloads (may be useful to avoid network constraints)")
    private Integer mConcurrentDownloadLimit = null;
    @Option(name="concurrent-virtual-device-startup-limit", description="The maximum number of concurrent virtual device startup to avoid resource contentions depending on factors such as network, CPU, I/O etc.")
    private Integer mConcurrentVirtualDeviceStartupLimit = null;
    @Option(name="concurrent-limits", description="The maximum number of concurrent actions of a given type.")
    private Map<IHostOptions.PermitLimitType, Integer> mConcurrentLimit = new HashMap<IHostOptions.PermitLimitType, Integer>();
    @Option(name="fastboot-tmpdir", description="The location of temporary directory used by fastboot")
    private File mFastbootTmpDir = null;
    @Option(name="enable-fastbootd-mode", description="Feature flag to enable the support for fastbootd.")
    private boolean mEnableFastbootdMode = true;
    @Option(name="download-cache-dir", description="the directory for caching downloaded flashing files. Should be on the same filesystem as java.io.tmpdir.  Consider changing the java.io.tmpdir property if you want to move downloads to a different filesystem.")
    private File mDownloadCacheDir = new File(System.getProperty("java.io.tmpdir"), "lc_cache");
    @Option(name="use-sso-client", description="Use a SingleSignOn client for HTTP requests.")
    private Boolean mUseSsoClient = true;
    @Option(name="service-account-json-key-file", description="Specify a service account json key file, and a String key name to identify it.")
    private Map<String, File> mJsonServiceAccountMap = new HashMap<String, File>();
    @Option(name="label", description="Labels to describe the host.")
    private List<String> mLabels = new ArrayList<String>();
    @Option(name="known-tcp-device-ip-pool", description="known remote device available via ip associated with the tcp-device placeholder.")
    private Set<String> mKnownTcpDeviceIpPool = new HashSet<String>();
    @Option(name="known-gce-device-ip-pool", description="known remote device available via ip associated with the gce-device placeholder.")
    private Set<String> mKnownGceDeviceIpPool = new HashSet<String>();
    @Option(name="known-remote-device-ip-pool", description="known remote device available via ip associated with the remote-device placeholder.")
    private Set<String> mKnownRemoteDeviceIpPool = new HashSet<String>();
    @Option(name="use-zip64-in-partial-download", description="Whether to use zip64 format in partial download.")
    private boolean mUseZip64InPartialDownload = true;
    @Option(name="use-network-interface", description="The network interface used to connect to test devices.")
    private String mNetworkInterface = null;
    @Option(name="preconfigured-virtual-device-pool", description="Preconfigured virtual device pool. (Value format: $hostname:$user.)")
    private List<String> mPreconfiguredVirtualDevicePool = new ArrayList<String>();
    @Option(name="flash-with-fuse-zip", description="Use `fastboot flashall` on a folder of fuse mounted device image zip instead of `fastboot update` with zip")
    private boolean mFlashWithFuseZip = false;
    @Option(name="cache-size-limit", description="The maximum allowed size(bytes) of the local file cache. (default: 15GB)")
    private Long mCacheSizeLimit = 0x3C0000000L;
    @Option(name="test-phase-timeout", description="the maximum time to wait for test phase to finish before attempting to forcestop it. A value of zero will indicate no timeout.", isTimeVal=true)
    private long mTestPhaseTimeout = 0L;
    @Option(name="enable-flashstation", description="Feature flag to enable the support for flashstation.")
    private boolean mEnableFlashstation = false;
    @Option(name="cl-flashstation", description="cl_flashstation script stored in remote GCS bucket.")
    private File mClFlashstation = new File("/tradefed/cl_flashstation");
    @Option(name="enable-incremental-flashing", description="Feature flag to enable incremental flashing on one host.")
    private boolean mEnableIncrementalFlashing = false;
    @Option(name="opt-out-incremental-flashing", description="Allows an host to fully opt-out of incremental flashing.")
    private boolean mOptOutFromIncrementalFlashing = false;
    @Option(name="disable-host-metric-reporting", description="Feature flag to disable the support for host metric reporting.")
    private boolean mDisableHostMetricReporting = false;
    private Map<IHostOptions.PermitLimitType, Semaphore> mConcurrentLocks = new HashMap<IHostOptions.PermitLimitType, Semaphore>();
    private Map<IHostOptions.PermitLimitType, Integer> mInternalConcurrentLimits = new HashMap<IHostOptions.PermitLimitType, Integer>();

    @Override
    public Long getCacheSizeLimit() {
        return this.mCacheSizeLimit;
    }

    @Override
    public Integer getConcurrentFlasherLimit() {
        return this.mConcurrentFlasherLimit;
    }

    @Override
    public Integer getConcurrentDownloadLimit() {
        return this.mConcurrentDownloadLimit;
    }

    @Override
    public Integer getConcurrentVirtualDeviceStartupLimit() {
        return this.mConcurrentVirtualDeviceStartupLimit;
    }

    @Override
    public File getFastbootTmpDir() {
        if (this.mFastbootTmpDir != null) {
            if (!this.mFastbootTmpDir.exists() || !this.mFastbootTmpDir.isDirectory()) {
                throw new HarnessRuntimeException(String.format("Fastboot tmp dir '%s' is missing and was expected.", this.mFastbootTmpDir), InfraErrorIdentifier.LAB_HOST_FILESYSTEM_ERROR);
            }
            return this.mFastbootTmpDir;
        }
        return null;
    }

    @Override
    public boolean isFastbootdEnable() {
        return this.mEnableFastbootdMode;
    }

    @Override
    public File getDownloadCacheDir() {
        return this.mDownloadCacheDir;
    }

    @Override
    public Boolean shouldUseSsoClient() {
        return this.mUseSsoClient;
    }

    @Override
    public Map<String, File> getServiceAccountJsonKeyFiles() {
        return new HashMap<String, File>(this.mJsonServiceAccountMap);
    }

    @Override
    public void validateOptions() throws ConfigurationException {
    }

    @Override
    public List<String> getLabels() {
        return new ArrayList<String>(this.mLabels);
    }

    @Override
    public Set<String> getKnownTcpDeviceIpPool() {
        return new HashSet<String>(this.mKnownTcpDeviceIpPool);
    }

    @Override
    public Set<String> getKnownGceDeviceIpPool() {
        return new HashSet<String>(this.mKnownGceDeviceIpPool);
    }

    @Override
    public Set<String> getKnownRemoteDeviceIpPool() {
        return new HashSet<String>(this.mKnownRemoteDeviceIpPool);
    }

    @Override
    public List<String> getKnownPreconfigureVirtualDevicePool() {
        return new ArrayList<String>(this.mPreconfiguredVirtualDevicePool);
    }

    @Override
    public boolean getUseZip64InPartialDownload() {
        return this.mUseZip64InPartialDownload;
    }

    @Override
    public String getNetworkInterface() {
        if (this.mNetworkInterface != null) {
            return this.mNetworkInterface;
        }
        try {
            Enumeration<NetworkInterface> enNetI = NetworkInterface.getNetworkInterfaces();
            while (enNetI.hasMoreElements()) {
                NetworkInterface netI = enNetI.nextElement();
                if (!netI.isUp()) continue;
                Enumeration<InetAddress> enumIpAddr = netI.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isAnyLocalAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isMulticastAddress()) continue;
                    this.mNetworkInterface = netI.getName();
                    return this.mNetworkInterface;
                }
            }
        }
        catch (SocketException e) {
            LogUtil.CLog.w("Failed to get host's active interface");
            LogUtil.CLog.w(e);
        }
        return null;
    }

    @Override
    public long getTestPhaseTimeout() {
        return this.mTestPhaseTimeout;
    }

    @Override
    public void initConcurrentLocks() {
        if (!this.mConcurrentLocks.isEmpty()) {
            return;
        }
        this.mInternalConcurrentLimits.putAll(this.mConcurrentLimit);
        if (!this.mInternalConcurrentLimits.containsKey((Object)IHostOptions.PermitLimitType.CONCURRENT_FLASHER)) {
            this.mInternalConcurrentLimits.put(IHostOptions.PermitLimitType.CONCURRENT_FLASHER, this.mConcurrentFlasherLimit);
        }
        if (!this.mInternalConcurrentLimits.containsKey((Object)IHostOptions.PermitLimitType.CONCURRENT_DOWNLOAD)) {
            this.mInternalConcurrentLimits.put(IHostOptions.PermitLimitType.CONCURRENT_DOWNLOAD, this.mConcurrentDownloadLimit);
        }
        if (!this.mInternalConcurrentLimits.containsKey((Object)IHostOptions.PermitLimitType.CONCURRENT_VIRTUAL_DEVICE_STARTUP)) {
            this.mInternalConcurrentLimits.put(IHostOptions.PermitLimitType.CONCURRENT_VIRTUAL_DEVICE_STARTUP, this.mConcurrentVirtualDeviceStartupLimit);
        }
        for (Map.Entry<IHostOptions.PermitLimitType, Integer> limits : this.mInternalConcurrentLimits.entrySet()) {
            if (limits.getValue() == null) continue;
            this.mConcurrentLocks.put(limits.getKey(), new Semaphore(limits.getValue(), true));
        }
    }

    @Override
    public void takePermit(IHostOptions.PermitLimitType type) {
        if (!this.mConcurrentLocks.containsKey((Object)type)) {
            return;
        }
        LogUtil.CLog.i("Requesting a '%s' permit out of the max limit of %s. Current queue length: %s", new Object[]{type, this.mInternalConcurrentLimits.get((Object)type), this.mConcurrentLocks.get((Object)type).getQueueLength()});
        try {
            this.mConcurrentLocks.get((Object)type).acquire();
        }
        catch (InterruptedException e) {
            throw new RunInterruptedException(e.getMessage(), e, InfraErrorIdentifier.UNDETERMINED);
        }
    }

    @Override
    public void returnPermit(IHostOptions.PermitLimitType type) {
        if (!this.mConcurrentLocks.containsKey((Object)type)) {
            return;
        }
        this.mConcurrentLocks.get((Object)type).release();
    }

    @Override
    public Integer getAvailablePermits(IHostOptions.PermitLimitType type) {
        if (!this.mConcurrentLocks.containsKey((Object)type)) {
            return Integer.MAX_VALUE;
        }
        return this.mConcurrentLocks.get((Object)type).availablePermits();
    }

    @Override
    public int getInUsePermits(IHostOptions.PermitLimitType type) {
        if (!this.mConcurrentLocks.containsKey((Object)type)) {
            return 0;
        }
        return this.mInternalConcurrentLimits.get((Object)type) - this.mConcurrentLocks.get((Object)type).availablePermits();
    }

    @Override
    public boolean shouldFlashWithFuseZip() {
        return this.mFlashWithFuseZip;
    }

    @Override
    public boolean isFlashstationEnabled() {
        return this.mEnableFlashstation;
    }

    @Override
    public File getClFlashstation() {
        return this.mClFlashstation;
    }

    @Override
    public boolean isIncrementalFlashingEnabled() {
        return this.mEnableIncrementalFlashing;
    }

    @Override
    public boolean isOptOutOfIncrementalFlashing() {
        return this.mOptOutFromIncrementalFlashing;
    }

    @Override
    public boolean isHostMetricReportingDisabled() {
        return this.mDisableHostMetricReporting;
    }
}

