/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.host;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.host.IHostResourceManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

@OptionClass(alias="local-hrm", global_namespace=false)
public class LocalHostResourceManager
implements IHostResourceManager {
    @Option(name="host-resource", description="The host resources to download for the current host.")
    private Map<String, String> mHostResources = new HashMap<String, String>();
    @Option(name="disable", description="Disable the host resource manager or not.")
    private boolean mDisable = false;
    private Map<String, File> mDownloadedHostResources = new HashMap<String, File>();

    @Override
    public void setup() throws ConfigurationException {
        if (this.mDisable) {
            return;
        }
        for (Map.Entry<String, String> entry : this.mHostResources.entrySet()) {
            File localFile = this.fetchHostResource(entry.getKey(), entry.getValue());
            this.mDownloadedHostResources.put(entry.getKey(), localFile);
        }
    }

    @Override
    public File getFile(String name) {
        return this.mDownloadedHostResources.get(name);
    }

    @Override
    public void cleanup() {
        if (this.mDisable) {
            return;
        }
        for (Map.Entry<String, File> entry : this.mDownloadedHostResources.entrySet()) {
            this.clearHostResource(entry.getKey(), entry.getValue());
        }
    }

    protected void clearHostResource(String name, File localFile) {
    }

    protected File fetchHostResource(String name, String value) throws ConfigurationException {
        File localFile = new File(value);
        if (!localFile.exists()) {
            throw new ConfigurationException(String.format("File %s doesn't exist.", value));
        }
        return localFile;
    }
}

