/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.host.gcs;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.FileDownloadCacheWrapper;
import com.android.tradefed.build.IFileDownloader;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.host.IHostOptions;
import com.android.tradefed.host.LocalHostResourceManager;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.GCSFileDownloader;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;

@OptionClass(alias="gcs-hrm", global_namespace=false)
public class GCSHostResourceManager
extends LocalHostResourceManager {
    private IFileDownloader mFileDownloader = null;

    @Override
    protected File fetchHostResource(String name, String value) throws ConfigurationException {
        try {
            return this.getGCSFileDownloader().downloadFile(value);
        }
        catch (BuildRetrievalError e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    protected void clearHostResource(String name, File localFile) {
        FileUtil.recursiveDelete(localFile);
    }

    @VisibleForTesting
    IFileDownloader getGCSFileDownloader() {
        if (this.mFileDownloader == null) {
            this.mFileDownloader = new FileDownloadCacheWrapper(this.getHostOptions().getDownloadCacheDir(), new GCSFileDownloader());
        }
        return this.mFileDownloader;
    }

    private IHostOptions getHostOptions() {
        return GlobalConfiguration.getInstance().getHostOptions();
    }
}

