/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.internal.protobuf;

import com.android.tradefed.internal.protobuf.Descriptors;
import com.android.tradefed.internal.protobuf.InvalidProtocolBufferException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class TypeRegistry {
    private static final Logger logger = Logger.getLogger(TypeRegistry.class.getName());
    private final Map<String, Descriptors.Descriptor> types;

    public static TypeRegistry getEmptyTypeRegistry() {
        return EmptyTypeRegistryHolder.EMPTY;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Descriptors.Descriptor find(String name) {
        return this.types.get(name);
    }

    public final Descriptors.Descriptor getDescriptorForTypeUrl(String typeUrl) throws InvalidProtocolBufferException {
        return this.find(TypeRegistry.getTypeName(typeUrl));
    }

    TypeRegistry(Map<String, Descriptors.Descriptor> types) {
        this.types = types;
    }

    private static String getTypeName(String typeUrl) throws InvalidProtocolBufferException {
        String[] parts = typeUrl.split("/");
        if (parts.length == 1) {
            throw new InvalidProtocolBufferException("Invalid type url found: " + typeUrl);
        }
        return parts[parts.length - 1];
    }

    private static class EmptyTypeRegistryHolder {
        private static final TypeRegistry EMPTY = new TypeRegistry(Collections.emptyMap());

        private EmptyTypeRegistryHolder() {
        }
    }

    public static final class Builder {
        private final Set<String> files = new HashSet<String>();
        private Map<String, Descriptors.Descriptor> types = new HashMap<String, Descriptors.Descriptor>();

        private Builder() {
        }

        public Builder add(Descriptors.Descriptor messageType) {
            if (this.types == null) {
                throw new IllegalStateException("A TypeRegistry.Builder can only be used once.");
            }
            this.addFile(messageType.getFile());
            return this;
        }

        public Builder add(Iterable<Descriptors.Descriptor> messageTypes) {
            if (this.types == null) {
                throw new IllegalStateException("A TypeRegistry.Builder can only be used once.");
            }
            for (Descriptors.Descriptor type : messageTypes) {
                this.addFile(type.getFile());
            }
            return this;
        }

        public TypeRegistry build() {
            TypeRegistry result = new TypeRegistry(this.types);
            this.types = null;
            return result;
        }

        private void addFile(Descriptors.FileDescriptor file2) {
            if (!this.files.add(file2.getFullName())) {
                return;
            }
            for (Descriptors.FileDescriptor dependency : file2.getDependencies()) {
                this.addFile(dependency);
            }
            for (Descriptors.Descriptor message2 : file2.getMessageTypes()) {
                this.addMessage(message2);
            }
        }

        private void addMessage(Descriptors.Descriptor message2) {
            for (Descriptors.Descriptor nestedType : message2.getNestedTypes()) {
                this.addMessage(nestedType);
            }
            if (this.types.containsKey(message2.getFullName())) {
                logger.warning("Type " + message2.getFullName() + " is added multiple times.");
                return;
            }
            this.types.put(message2.getFullName(), message2);
        }
    }
}

