/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.proxy.TradefedDelegator;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.InvocationExecution;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.result.proto.StreamProtoReceiver;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.SubprocessExceptionParser;
import com.android.tradefed.util.SystemUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;

public class DelegatedInvocationExecution
extends InvocationExecution {
    public static final String DELEGATED_MODE_VAR = "DELEGATED_MODE";
    private static final long EVENT_THREAD_JOIN_TIMEOUT_MS = 30000L;
    private File mTmpDelegatedDir = null;
    private File mGlobalConfig = null;
    private File mStdoutFile = null;
    private File mStderrFile = null;
    private OutputStream mStderr = null;
    private OutputStream mStdout = null;

    @Override
    public void reportLogs(ITestDevice device, ITestLogger logger, TestInvocation.Stage stage) {
    }

    @Override
    public boolean shardConfig(IConfiguration config, TestInformation testInfo, IRescheduler rescheduler, ITestLogger logger) {
        return false;
    }

    @Override
    public void doSetup(TestInformation testInfo, IConfiguration config, ITestLogger listener) throws TargetSetupError, BuildError, DeviceNotAvailableException {
    }

    @Override
    public void runDevicePreInvocationSetup(IInvocationContext context, IConfiguration config, ITestLogger logger) throws DeviceNotAvailableException, TargetSetupError {
    }

    @Override
    public void runDevicePostInvocationTearDown(IInvocationContext context, IConfiguration config, Throwable exception) {
    }

    @Override
    public void doTeardown(TestInformation testInfo, IConfiguration config, ITestLogger logger, Throwable exception) throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTests(TestInformation info, IConfiguration config, ITestInvocationListener listener) throws Throwable {
        File dumpConfig = FileUtil.createTempFile("delegated-config", ".xml");
        try (PrintWriter pw = new PrintWriter(dumpConfig);){
            config.dumpXml(pw);
        }
        this.logAndCleanFile(dumpConfig, LogDataType.HARNESS_CONFIG, listener);
        if (config.getConfigurationObject("DELEGATE") == null) {
            throw new ConfigurationException("Delegate object should not be null in DelegatedInvocation");
        }
        TradefedDelegator delegator = (TradefedDelegator)config.getConfigurationObject("DELEGATE");
        if (!delegator.getTfRootDir().exists() || !delegator.getTfRootDir().isDirectory()) {
            throw new ConfigurationException(String.format("delegated-tf was misconfigured and doesn't point to a valid location: %s", delegator.getTfRootDir()), (ErrorIdentifier)InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(SystemUtil.getRunningJavaBinaryPath().getAbsolutePath());
        this.mTmpDelegatedDir = FileUtil.createTempDir("delegated-invocation", CurrentInvocation.getWorkFolder());
        commandLine.add(String.format("-Djava.io.tmpdir=%s", this.mTmpDelegatedDir.getAbsolutePath()));
        commandLine.add("-cp");
        commandLine.add(delegator.createClasspath());
        commandLine.add(String.format("-DTF_JAR_DIR=%s", delegator.getTfRootDir().getAbsolutePath()));
        commandLine.add("com.android.tradefed.command.CommandRunner");
        commandLine.addAll(Arrays.asList(delegator.getCommandLine()));
        try (StreamProtoReceiver receiver = this.createReceiver(listener, info.getContext());){
            String stderrText;
            this.mStdoutFile = FileUtil.createTempFile("stdout_delegate_", ".log", this.mTmpDelegatedDir);
            this.mStderrFile = FileUtil.createTempFile("stderr_delegate_", ".log", this.mTmpDelegatedDir);
            this.mStderr = new FileOutputStream(this.mStderrFile);
            this.mStdout = new FileOutputStream(this.mStdoutFile);
            IRunUtil runUtil = this.createRunUtil(receiver.getSocketServerPort(), config);
            CommandResult result = null;
            RuntimeException runtimeException = null;
            LogUtil.CLog.d("Command line: %s", commandLine);
            try {
                result = runUtil.runTimedCmd(config.getCommandOptions().getInvocationTimeout(), this.mStdout, this.mStderr, commandLine.toArray(new String[0]));
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Delegated runtimedCmd threw an exception");
                LogUtil.CLog.e(e);
                runtimeException = e;
                result = new CommandResult(CommandStatus.EXCEPTION);
                result.setStdout(StreamUtil.getStackTrace(e));
            }
            boolean failedStatus = false;
            try {
                stderrText = FileUtil.readStringFromFile(this.mStderrFile);
            }
            catch (IOException e) {
                stderrText = "Could not read the stderr output from process.";
            }
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                failedStatus = true;
                result.setStderr(stderrText);
            }
            boolean joinResult = receiver.joinReceiver(30000L);
            if (runtimeException != null) {
                throw runtimeException;
            }
            if (!joinResult) {
                if (!failedStatus) {
                    result.setStatus(CommandStatus.EXCEPTION);
                }
                result.setStderr(String.format("Event receiver thread did not complete.:\n%s", stderrText));
            }
            receiver.completeModuleEvents();
            if (result.getStatus().equals((Object)CommandStatus.TIMED_OUT)) {
                throw new HarnessRuntimeException("Delegated invocation timed out.", InfraErrorIdentifier.INVOCATION_TIMEOUT);
            }
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                LogUtil.CLog.e("Sandbox finished with status: %s and exit code: %s", new Object[]{result.getStatus(), result.getExitCode()});
                SubprocessExceptionParser.handleStderrException(result);
            }
        }
        finally {
            StreamUtil.close(this.mStderr);
            StreamUtil.close(this.mStdout);
            this.logAndCleanFile(this.mStdoutFile, LogDataType.HARNESS_STD_LOG, listener);
            this.logAndCleanFile(this.mStderrFile, LogDataType.HARNESS_STD_LOG, listener);
            this.logAndCleanFile(this.mGlobalConfig, LogDataType.HARNESS_CONFIG, listener);
        }
    }

    @Override
    public void doCleanUp(IInvocationContext context, IConfiguration config, Throwable exception) {
        super.doCleanUp(context, config, exception);
        FileUtil.recursiveDelete(this.mTmpDelegatedDir);
        FileUtil.deleteFile(this.mGlobalConfig);
    }

    private IRunUtil createRunUtil(int port, IConfiguration config) throws IOException {
        RunUtil runUtil = new RunUtil();
        runUtil.unsetEnvVariable("TF_GLOBAL_CONFIG");
        runUtil.unsetEnvVariable("TF_GLOBAL_CONFIG_SERVER_CONFIG");
        runUtil.setEnvVariablePriority(IRunUtil.EnvPriority.SET);
        this.mGlobalConfig = this.createGlobalConfig();
        runUtil.setEnvVariable("TF_GLOBAL_CONFIG", this.mGlobalConfig.getAbsolutePath());
        runUtil.setEnvVariable("PROTO_REPORTING_PORT", Integer.toString(port));
        runUtil.setEnvVariable(DELEGATED_MODE_VAR, "1");
        runUtil.setEnvVariable("START_FEATURE_SERVER", "1");
        ServerSocket s = new ServerSocket(0);
        s.setReuseAddress(true);
        int servicePort = s.getLocalPort();
        s.close();
        runUtil.setEnvVariable("TF_SERVICE_PORT", Integer.toString(servicePort));
        return runUtil;
    }

    private StreamProtoReceiver createReceiver(ITestInvocationListener listener, IInvocationContext mainContext) throws IOException {
        StreamProtoReceiver receiver = new StreamProtoReceiver(listener, mainContext, false, false, false, "");
        return receiver;
    }

    private File createGlobalConfig() throws IOException {
        String[] configList = new String[]{"device_manager", "key_store", "host_options", "sandbox_factory", "android-build"};
        File filteredGlobalConfig = GlobalConfiguration.getInstance().cloneConfigWithFilter(configList);
        return filteredGlobalConfig;
    }

    private void logAndCleanFile(File fileToExport, LogDataType type, ITestInvocationListener listener) {
        if (fileToExport == null) {
            return;
        }
        try (FileInputStreamSource inputStream = new FileInputStreamSource(fileToExport, true);){
            listener.testLog(fileToExport.getName(), type, inputStream);
        }
    }
}

