/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;

public final class DeviceUnavailableMonitor
implements ITestInvocationListener {
    private boolean mInvocationFailed = false;
    private DeviceNotAvailableException mUnavailableException = null;
    private String mSerial = null;

    @Override
    public void invocationStarted(IInvocationContext context) {
        for (ITestDevice device : context.getDevices()) {
            if (device.getIDevice() instanceof StubDevice) continue;
            this.mSerial = device.getSerialNumber();
        }
    }

    @Override
    public void testRunFailed(FailureDescription failure) {
        if (this.mUnavailableException != null || this.mInvocationFailed) {
            return;
        }
        this.mUnavailableException = this.analyzeFailure(failure);
    }

    @Override
    public void testFailed(TestDescription test, FailureDescription failure) {
        if (this.mUnavailableException != null || this.mInvocationFailed) {
            return;
        }
        this.mUnavailableException = this.analyzeFailure(failure);
    }

    @Override
    public void invocationFailed(FailureDescription failure) {
        this.mInvocationFailed = true;
        if (this.mUnavailableException != null) {
            return;
        }
        this.mUnavailableException = this.analyzeFailure(failure);
    }

    @Override
    public void invocationFailed(Throwable cause) {
        this.mInvocationFailed = true;
    }

    public DeviceNotAvailableException getUnavailableException() {
        return this.mUnavailableException;
    }

    private DeviceNotAvailableException analyzeFailure(FailureDescription failure) {
        if (failure.getCause() != null && failure.getCause() instanceof DeviceNotAvailableException) {
            return (DeviceNotAvailableException)failure.getCause();
        }
        if (failure.getFailureStatus() != null && TestRecordProto.FailureStatus.LOST_SYSTEM_UNDER_TEST.equals(failure.getFailureStatus())) {
            return new DeviceNotAvailableException(failure.getErrorMessage(), this.mSerial);
        }
        if (failure.getErrorIdentifier() != null) {
            if (DeviceErrorIdentifier.DEVICE_UNAVAILABLE.equals(failure.getErrorIdentifier())) {
                return new DeviceNotAvailableException(failure.getErrorMessage(), this.mSerial);
            }
            if (DeviceErrorIdentifier.DEVICE_UNRESPONSIVE.equals(failure.getErrorIdentifier())) {
                return new DeviceUnresponsiveException(failure.getErrorMessage(), this.mSerial);
            }
        }
        return null;
    }
}

