/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class ExecutionFiles {
    private final ConcurrentMap<String, File> mFiles = new ConcurrentHashMap<String, File>();
    private final ConcurrentSkipListSet<String> mShouldNotDelete = new ConcurrentSkipListSet();

    ExecutionFiles() {
    }

    public File put(String key, File value) {
        return this.mFiles.put(key, value);
    }

    public File put(FilesKey key, File value) {
        return this.mFiles.put(key.toString(), value);
    }

    public File put(FilesKey key, File value, boolean shouldNotDelete) {
        File f = this.mFiles.put(key.toString(), value);
        if (shouldNotDelete) {
            this.mShouldNotDelete.add(key.toString());
        } else {
            this.mShouldNotDelete.remove(key.toString());
        }
        if (f != null) {
            LogUtil.CLog.w("Replaced key '%s' with value '%s' by '%s'", new Object[]{key, f, value});
        }
        return f;
    }

    public File putIfAbsent(String key, File value) {
        return this.mFiles.putIfAbsent(key, value);
    }

    public ExecutionFiles putAll(Map<String, File> properties) {
        this.mFiles.putAll(properties);
        return this;
    }

    public ExecutionFiles putAll(ExecutionFiles copyFrom) {
        this.mFiles.putAll(copyFrom.getAll());
        this.mShouldNotDelete.addAll(copyFrom.mShouldNotDelete);
        return this;
    }

    public boolean isEmpty() {
        return this.mFiles.isEmpty();
    }

    public File get(String key) {
        return (File)this.mFiles.get(key);
    }

    public File get(FilesKey key) {
        return (File)this.mFiles.get(key.toString());
    }

    public boolean containsKey(String key) {
        return this.mFiles.containsKey(key);
    }

    public ImmutableMap<String, File> getAll() {
        return ImmutableMap.copyOf(this.mFiles);
    }

    public File remove(String key) {
        return (File)this.mFiles.remove(key);
    }

    public void clearFiles() {
        for (String key : this.mFiles.keySet()) {
            if (this.mShouldNotDelete.contains(key)) continue;
            FileUtil.recursiveDelete((File)this.mFiles.get(key));
            this.mFiles.remove(key);
        }
    }

    public static enum FilesKey {
        ADB_BINARY,
        TESTS_DIRECTORY,
        TARGET_TESTS_DIRECTORY,
        HOST_TESTS_DIRECTORY;

    }
}

