/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.proto.BuildInformation;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.proto.ConfigurationDescription;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.logger.TfObjectTracker;
import com.android.tradefed.invoker.proto.InvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.UniqueMultiMap;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InvocationContext
implements IInvocationContext {
    private static final long serialVersionUID = 1L;
    private transient Map<ITestDevice, IBuildInfo> mAllocatedDeviceAndBuildMap;
    private transient Map<String, ITestDevice> mNameAndDeviceMap;
    private Map<String, IBuildInfo> mNameAndBuildinfoMap;
    private final UniqueMultiMap<String, String> mInvocationAttributes = new UniqueMultiMap();
    private String mTestTag;
    private ConfigurationDescriptor mConfigurationDescriptor;
    private IInvocationContext mModuleContext;
    private Map<Integer, List<String>> mShardSerials;
    private boolean mLocked;
    private boolean mReleasedEarly = false;

    public InvocationContext() {
        this.mAllocatedDeviceAndBuildMap = new LinkedHashMap<ITestDevice, IBuildInfo>();
        this.mNameAndDeviceMap = new LinkedHashMap<String, ITestDevice>();
        this.mNameAndBuildinfoMap = new LinkedHashMap<String, IBuildInfo>();
        this.mShardSerials = new LinkedHashMap<Integer, List<String>>();
    }

    @Override
    public String getInvocationId() {
        List values2 = this.mInvocationAttributes.get("invocation-id");
        return values2 == null || values2.isEmpty() ? null : (String)values2.get(0);
    }

    @Override
    public int getNumDevicesAllocated() {
        return this.mAllocatedDeviceAndBuildMap.size();
    }

    @Override
    public void addAllocatedDevice(String devicename, ITestDevice testDevice) {
        this.mNameAndDeviceMap.put(devicename, testDevice);
        if (this.mNameAndBuildinfoMap.get(devicename) != null) {
            this.mAllocatedDeviceAndBuildMap.put(testDevice, this.mNameAndBuildinfoMap.get(devicename));
        }
    }

    @Override
    public void addAllocatedDevice(Map<String, ITestDevice> deviceWithName) {
        this.mNameAndDeviceMap.putAll(deviceWithName);
        for (Map.Entry<String, ITestDevice> entry : deviceWithName.entrySet()) {
            if (this.mNameAndBuildinfoMap.get(entry.getKey()) == null) continue;
            this.mAllocatedDeviceAndBuildMap.put(entry.getValue(), this.mNameAndBuildinfoMap.get(entry.getKey()));
        }
    }

    @Override
    public Map<ITestDevice, IBuildInfo> getDeviceBuildMap() {
        return this.mAllocatedDeviceAndBuildMap;
    }

    @Override
    public List<ITestDevice> getDevices() {
        return new ArrayList<ITestDevice>(this.mNameAndDeviceMap.values());
    }

    @Override
    public List<IBuildInfo> getBuildInfos() {
        return new ArrayList<IBuildInfo>(this.mNameAndBuildinfoMap.values());
    }

    @Override
    public List<String> getSerials() {
        ArrayList<String> listSerials = new ArrayList<String>();
        for (ITestDevice testDevice : this.mNameAndDeviceMap.values()) {
            listSerials.add(testDevice.getSerialNumber());
        }
        return listSerials;
    }

    @Override
    public List<String> getDeviceConfigNames() {
        ArrayList<String> listNames = new ArrayList<String>();
        listNames.addAll(this.mNameAndDeviceMap.keySet());
        return listNames;
    }

    @Override
    public ITestDevice getDevice(String deviceName) {
        return this.mNameAndDeviceMap.get(deviceName);
    }

    @Override
    public IBuildInfo getBuildInfo(String deviceName) {
        return this.mNameAndBuildinfoMap.get(deviceName);
    }

    @Override
    public IBuildInfo getBuildInfo(ITestDevice testDevice) {
        return this.mAllocatedDeviceAndBuildMap.get(testDevice);
    }

    @Override
    public void addDeviceBuildInfo(String deviceName, IBuildInfo buildinfo) {
        this.mNameAndBuildinfoMap.put(deviceName, buildinfo);
        this.mAllocatedDeviceAndBuildMap.put(this.getDevice(deviceName), buildinfo);
    }

    @Override
    public void addInvocationAttribute(String attributeName, String attributeValue) {
        if (this.mLocked) {
            throw new IllegalStateException("Attempting to add invocation attribute during a test.");
        }
        this.mInvocationAttributes.put(attributeName, attributeValue);
    }

    @Override
    public void addInvocationAttributes(MultiMap<String, String> attributesMap) {
        if (this.mLocked) {
            throw new IllegalStateException("Attempting to add invocation attribute during a test.");
        }
        this.mInvocationAttributes.putAll(attributesMap);
    }

    @Override
    public MultiMap<String, String> getAttributes() {
        UniqueMultiMap<String, String> copy = new UniqueMultiMap<String, String>();
        copy.putAll(this.mInvocationAttributes);
        return copy;
    }

    @Override
    public ITestDevice getDeviceBySerial(String serial) {
        for (ITestDevice testDevice : this.mNameAndDeviceMap.values()) {
            if (!testDevice.getSerialNumber().equals(serial)) continue;
            return testDevice;
        }
        LogUtil.CLog.d("Device with serial '%s', not found in the metadata", serial);
        return null;
    }

    @Override
    public String getDeviceName(ITestDevice device) {
        for (String name : this.mNameAndDeviceMap.keySet()) {
            if (!device.equals(this.getDevice(name))) continue;
            return name;
        }
        LogUtil.CLog.d("Device with serial '%s' doesn't match a name in the metadata", device.getSerialNumber());
        return null;
    }

    @Override
    public String getBuildInfoName(IBuildInfo info) {
        for (String name : this.mNameAndBuildinfoMap.keySet()) {
            if (!info.equals(this.getBuildInfo(name))) continue;
            return name;
        }
        LogUtil.CLog.d("Build info doesn't match a name in the metadata");
        return null;
    }

    @Override
    public String getTestTag() {
        return this.mTestTag;
    }

    @Override
    public void setTestTag(String testTag) {
        this.mTestTag = testTag;
    }

    @Override
    public boolean wasReleasedEarly() {
        return this.mReleasedEarly;
    }

    @Override
    public void markReleasedEarly() {
        this.mReleasedEarly = true;
    }

    @Override
    public void setRecoveryModeForAllDevices(ITestDevice.RecoveryMode mode) {
        for (ITestDevice device : this.getDevices()) {
            device.setRecoveryMode(mode);
        }
    }

    @Override
    public void setConfigurationDescriptor(ConfigurationDescriptor configurationDescriptor) {
        this.mConfigurationDescriptor = configurationDescriptor;
    }

    @Override
    public ConfigurationDescriptor getConfigurationDescriptor() {
        return this.mConfigurationDescriptor;
    }

    @Override
    public void setModuleInvocationContext(IInvocationContext invocationContext) {
        this.mModuleContext = invocationContext;
    }

    @Override
    public IInvocationContext getModuleInvocationContext() {
        return this.mModuleContext;
    }

    public void lockAttributes() {
        this.mLocked = true;
    }

    private void unlock() {
        this.mLocked = false;
    }

    public void logInvocationMetrics() {
        Map<String, Long> usage;
        Map<String, String> metrics = InvocationMetricLogger.getInvocationMetrics();
        if (!metrics.isEmpty()) {
            this.mInvocationAttributes.putAll(new MultiMap<String, String>(metrics));
        }
        if (!(usage = TfObjectTracker.getUsage()).isEmpty()) {
            this.mInvocationAttributes.put("tf_objects_tracking", Joiner.on(",").join(usage.entrySet()));
        }
    }

    @Override
    public void addSerialsFromShard(Integer index, List<String> serials) {
        if (this.mLocked) {
            throw new IllegalStateException("Attempting to add serial from shard attribute during a test.");
        }
        this.mShardSerials.put(index, serials);
    }

    @Override
    public Map<Integer, List<String>> getShardsSerials() {
        return new LinkedHashMap<Integer, List<String>>(this.mShardSerials);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mAllocatedDeviceAndBuildMap = new LinkedHashMap<ITestDevice, IBuildInfo>();
        this.mNameAndDeviceMap = new LinkedHashMap<String, ITestDevice>();
    }

    @Override
    public InvocationContext.Context toProto() {
        InvocationContext.Context.Builder contextBuilder = InvocationContext.Context.newBuilder();
        if (this.mTestTag != null) {
            contextBuilder.setTestTag(this.mTestTag);
        }
        LinkedHashMap<String, BuildInformation.BuildInfo> mapBuild = new LinkedHashMap<String, BuildInformation.BuildInfo>();
        for (String name : this.mNameAndBuildinfoMap.keySet()) {
            mapBuild.put(name, this.mNameAndBuildinfoMap.get(name).toProto());
        }
        contextBuilder.putAllNameBuildInfo(mapBuild);
        ArrayList<ConfigurationDescription.Metadata> metadatas = new ArrayList<ConfigurationDescription.Metadata>();
        for (String key : this.mInvocationAttributes.keySet()) {
            if (this.mInvocationAttributes.get(key) != null) {
                try {
                    ConfigurationDescription.Metadata value = ConfigurationDescription.Metadata.newBuilder().setKey(key).addAllValue(this.mInvocationAttributes.get(key)).build();
                    metadatas.add(value);
                }
                catch (RuntimeException e) {
                    LogUtil.CLog.e("Invocation attribute key '%s' raised exception. values: %s", key, this.mInvocationAttributes.get(key));
                    LogUtil.CLog.e(e);
                }
                continue;
            }
            LogUtil.CLog.e("Invocation attribute Key '%s' has null value.", key);
        }
        contextBuilder.addAllMetadata(metadatas);
        if (this.mConfigurationDescriptor != null) {
            contextBuilder.setConfigurationDescription(this.mConfigurationDescriptor.toProto());
        }
        if (this.mModuleContext != null) {
            contextBuilder.setModuleContext(this.mModuleContext.toProto());
        }
        return contextBuilder.build();
    }

    public static InvocationContext fromProto(InvocationContext.Context protoContext) {
        InvocationContext context = new InvocationContext();
        context.mTestTag = protoContext.getTestTag();
        for (String key : protoContext.getNameBuildInfoMap().keySet()) {
            context.mNameAndBuildinfoMap.put(key, BuildInfo.fromProto(protoContext.getNameBuildInfoMap().get(key)));
        }
        for (ConfigurationDescription.Metadata meta : protoContext.getMetadataList()) {
            for (String value : meta.getValueList()) {
                context.mInvocationAttributes.put(meta.getKey(), value);
            }
        }
        context.mConfigurationDescriptor = ConfigurationDescriptor.fromProto(protoContext.getConfigurationDescription());
        if (protoContext.hasModuleContext()) {
            context.mModuleContext = InvocationContext.fromProto(protoContext.getModuleContext());
        }
        return context;
    }
}

