/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.build.IDeviceBuildProvider;
import com.android.tradefed.command.ICommandOptions;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.filter.GetPreviousPassedHelper;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NativeDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.cloud.GceManager;
import com.android.tradefed.device.metric.AutoLogCollector;
import com.android.tradefed.device.metric.CollectorHelper;
import com.android.tradefed.device.metric.CountTestCasesCollector;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.device.metric.IMetricCollectorReceiver;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.IInvocationExecution;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.invoker.UnexecutedTestReporterThread;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.logger.TfObjectTracker;
import com.android.tradefed.invoker.shard.IShardHelper;
import com.android.tradefed.invoker.shard.TestsPoolPoller;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.retry.IRetryDecision;
import com.android.tradefed.retry.RetryLogSaverResultForwarder;
import com.android.tradefed.retry.RetryStatistics;
import com.android.tradefed.retry.RetryStrategy;
import com.android.tradefed.suite.checker.ISystemStatusCheckerReceiver;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.IHostCleaner;
import com.android.tradefed.targetprep.ILabPreparer;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.multi.IMultiTargetPreparer;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.retry.IAutoRetriableTest;
import com.android.tradefed.testtype.suite.BaseTestSuite;
import com.android.tradefed.testtype.suite.ITestSuite;
import com.android.tradefed.testtype.suite.ModuleListener;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.PrettyPrintDelimiter;
import com.android.tradefed.util.RunInterruptedException;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.TimeUtil;
import com.android.tradefed.util.executor.ParallelDeviceExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class InvocationExecution
implements IInvocationExecution {
    public static final String ADB_VERSION_KEY = "adb_version";
    public static final String JAVA_VERSION_KEY = "java_version";
    public static final String JAVA_CLASSPATH_KEY = "java_classpath";
    private Set<IMultiTargetPreparer> mTrackMultiPreparers = null;
    private Map<String, Set<ITargetPreparer>> mTrackLabPreparers = null;
    private Map<String, Set<ITargetPreparer>> mTrackTargetPreparers = null;

    @Override
    public boolean fetchBuild(TestInformation testInfo, IConfiguration config, IRescheduler rescheduler, ITestInvocationListener listener) throws DeviceNotAvailableException, BuildRetrievalError {
        String currentDeviceName = null;
        IBuildInfo buildReplicat = null;
        try {
            for (int i = 0; i < testInfo.getContext().getDeviceConfigNames().size(); ++i) {
                currentDeviceName = testInfo.getContext().getDeviceConfigNames().get(i);
                if (buildReplicat != null) {
                    testInfo.getContext().addDeviceBuildInfo(currentDeviceName, buildReplicat);
                    continue;
                }
                IBuildInfo info = null;
                ITestDevice device = testInfo.getContext().getDevice(currentDeviceName);
                IDeviceConfiguration deviceConfig = config.getDeviceConfigByName(currentDeviceName);
                IBuildProvider provider = deviceConfig.getBuildProvider();
                TfObjectTracker.countWithParents(provider.getClass());
                if (provider instanceof IInvocationContextReceiver) {
                    ((IInvocationContextReceiver)((Object)provider)).setInvocationContext(testInfo.getContext());
                }
                if ((info = provider instanceof IDeviceBuildProvider ? ((IDeviceBuildProvider)provider).getBuild(device) : provider.getBuild()) == null) {
                    LogUtil.CLog.logAndDisplay(Log.LogLevel.WARN, "No build found to test for device: %s", device.getSerialNumber());
                    BuildInfo notFoundStub = new BuildInfo();
                    this.updateBuild(notFoundStub, config);
                    testInfo.getContext().addDeviceBuildInfo(currentDeviceName, notFoundStub);
                    return false;
                }
                info.setDeviceSerial(device.getSerialNumber());
                testInfo.getContext().addDeviceBuildInfo(currentDeviceName, info);
                device.setRecovery(deviceConfig.getDeviceRecovery());
                this.updateBuild(info, config);
                this.linkExternalDirs(info, testInfo);
                if (!config.getCommandOptions().shouldUseReplicateSetup()) continue;
                buildReplicat = info;
            }
        }
        catch (BuildRetrievalError e) {
            LogUtil.CLog.e(e);
            if (currentDeviceName != null) {
                IBuildInfo errorBuild = e.getBuildInfo();
                this.updateBuild(errorBuild, config);
                testInfo.getContext().addDeviceBuildInfo(currentDeviceName, errorBuild);
            }
            throw e;
        }
        catch (RuntimeException re) {
            if (currentDeviceName != null) {
                IBuildInfo errorBuild = TestInvocation.backFillBuildInfoForReporting(config.getCommandLine());
                this.updateBuild(errorBuild, config);
                testInfo.getContext().addDeviceBuildInfo(currentDeviceName, errorBuild);
            }
            throw re;
        }
        this.setBinariesVersion(testInfo.getContext());
        this.copyRemoteFiles(config.getCommandOptions(), testInfo.getBuildInfo());
        return true;
    }

    @Override
    public void cleanUpBuilds(IInvocationContext context, IConfiguration config) {
        for (String cleanUpDevice : context.getDeviceConfigNames()) {
            if (context.getBuildInfo(cleanUpDevice) == null) continue;
            try {
                config.getDeviceConfigByName(cleanUpDevice).getBuildProvider().cleanUp(context.getBuildInfo(cleanUpDevice));
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public boolean shardConfig(IConfiguration config, TestInformation testInfo, IRescheduler rescheduler, ITestLogger logger) {
        IShardHelper helper = this.createShardHelper();
        LogUtil.CLog.d("IShardHelper selected: %s", helper);
        return helper.shardConfig(config, testInfo, rescheduler, logger);
    }

    @VisibleForTesting
    protected IShardHelper createShardHelper() {
        return GlobalConfiguration.getInstance().getShardingStrategy();
    }

    protected List<ITargetPreparer> getTargetPreparersToRun(IConfiguration config, String deviceName) {
        ArrayList<ITargetPreparer> preparersToRun = new ArrayList<ITargetPreparer>();
        preparersToRun.addAll(config.getDeviceConfigByName(deviceName).getTargetPreparers());
        return preparersToRun;
    }

    protected List<ITargetPreparer> getLabPreparersToRun(IConfiguration config, String deviceName) {
        ArrayList<ITargetPreparer> preparersToRun = new ArrayList<ITargetPreparer>();
        preparersToRun.addAll(config.getDeviceConfigByName(deviceName).getLabPreparers());
        return preparersToRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSetup(TestInformation testInfo, IConfiguration config, ITestLogger listener) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        long start = System.currentTimeMillis();
        this.mTrackLabPreparers = new ConcurrentHashMap<String, Set<ITargetPreparer>>();
        this.mTrackTargetPreparers = new ConcurrentHashMap<String, Set<ITargetPreparer>>();
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.SETUP_START, start);
        for (String deviceName : testInfo.getContext().getDeviceConfigNames()) {
            ITestDevice device = testInfo.getContext().getDevice(deviceName);
            LogUtil.CLog.d("Starting setup for device: '%s'", device.getSerialNumber());
            if (device instanceof ITestLoggerReceiver) {
                ((ITestLoggerReceiver)((Object)testInfo.getContext().getDevice(deviceName))).setTestLogger(listener);
            }
            this.mTrackLabPreparers.put(deviceName, new HashSet());
            this.mTrackTargetPreparers.put(deviceName, new HashSet());
        }
        try (CloseableTraceScope ignored = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.pre_multi_preparer.name());){
            this.runMultiTargetPreparers(config.getMultiPreTargetPreparers(), listener, testInfo, "multi pre target preparer setup");
        }
        finally {
            long end = System.currentTimeMillis();
            InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.TEST_SETUP_PAIR, start, end);
        }
        start = System.currentTimeMillis();
        try (CloseableTraceScope ignored = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.lab_setup.name());){
            this.runLabPreparersSetup(testInfo, config, listener);
        }
        finally {
            long end = System.currentTimeMillis();
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.SETUP_END, end);
            InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.SETUP_PAIR, start, end);
        }
        long startPreparer = System.currentTimeMillis();
        try (CloseableTraceScope ignored = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.test_setup.name());){
            this.runPreparersSetup(testInfo, config, listener);
            this.runMultiTargetPreparers(config.getMultiTargetPreparers(), listener, testInfo, "multi target preparer setup");
            this.collectAutoInfo(config, testInfo);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.TEST_SETUP_PAIR, startPreparer, end);
            long setupDuration = end - start;
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.SETUP, setupDuration);
            LogUtil.CLog.d("Total setup duration: %s'", TimeUtil.formatElapsedTime(setupDuration));
            for (ITestDevice device : testInfo.getDevices()) {
                this.reportLogs(device, listener, TestInvocation.Stage.SETUP);
            }
            throw throwable;
        }
        long end = System.currentTimeMillis();
        InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.TEST_SETUP_PAIR, startPreparer, end);
        long setupDuration = end - start;
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.SETUP, setupDuration);
        LogUtil.CLog.d("Total setup duration: %s'", TimeUtil.formatElapsedTime(setupDuration));
        for (ITestDevice device : testInfo.getDevices()) {
            this.reportLogs(device, listener, TestInvocation.Stage.SETUP);
        }
    }

    private void runLabPreparersSetup(TestInformation testInfo, IConfiguration config, ITestLogger listener) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        int index = 0;
        if ((config.getCommandOptions().shouldUseParallelSetup() || config.getCommandOptions().shouldUseReplicateSetup()) && config.getDeviceConfig().size() > 1) {
            List<Throwable> errors;
            Iterator<Throwable> iterator2;
            LogUtil.CLog.d("Using parallel setup.");
            ParallelDeviceExecutor executor = new ParallelDeviceExecutor(testInfo.getContext().getDevices().size());
            ArrayList callableTasks = new ArrayList();
            for (String deviceName : testInfo.getContext().getDeviceConfigNames()) {
                int deviceIndex = index++;
                TestInformation replicated = TestInformation.createModuleTestInfo(testInfo, testInfo.getContext());
                Callable<Boolean> callableTask = () -> {
                    this.runLabPreparationOnDevice(replicated, deviceName, deviceIndex, this.getLabPreparersToRun(config, deviceName), this.mTrackLabPreparers.get(deviceName), listener);
                    return true;
                };
                callableTasks.add(callableTask);
            }
            Duration timeout = config.getCommandOptions().getParallelSetupTimeout();
            executor.invokeAll(callableTasks, timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (executor.hasErrors() && (iterator2 = (errors = executor.getErrors()).iterator()).hasNext()) {
                Throwable error = iterator2.next();
                if (error instanceof TargetSetupError) {
                    throw (TargetSetupError)error;
                }
                if (error instanceof BuildError) {
                    throw (BuildError)error;
                }
                if (error instanceof DeviceNotAvailableException) {
                    throw (DeviceNotAvailableException)error;
                }
                throw new RuntimeException(error);
            }
        } else {
            for (String deviceName : testInfo.getContext().getDeviceConfigNames()) {
                this.runLabPreparationOnDevice(testInfo, deviceName, index, this.getLabPreparersToRun(config, deviceName), this.mTrackLabPreparers.get(deviceName), listener);
                ++index;
            }
        }
    }

    private void runPreparersSetup(TestInformation testInfo, IConfiguration config, ITestLogger listener) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        int index = 0;
        if ((config.getCommandOptions().shouldUseParallelSetup() || config.getCommandOptions().shouldUseReplicateSetup()) && config.getDeviceConfig().size() > 1) {
            List<Throwable> errors;
            Iterator<Throwable> iterator2;
            LogUtil.CLog.d("Using parallel setup.");
            ParallelDeviceExecutor executor = new ParallelDeviceExecutor(testInfo.getContext().getDevices().size());
            ArrayList callableTasks = new ArrayList();
            for (String deviceName : testInfo.getContext().getDeviceConfigNames()) {
                int deviceIndex = index++;
                TestInformation replicated = TestInformation.createModuleTestInfo(testInfo, testInfo.getContext());
                Callable<Boolean> callableTask = () -> {
                    this.runPreparationOnDevice(replicated, deviceName, deviceIndex, this.getTargetPreparersToRun(config, deviceName), this.mTrackTargetPreparers.get(deviceName), listener);
                    return true;
                };
                callableTasks.add(callableTask);
            }
            Duration timeout = config.getCommandOptions().getParallelSetupTimeout();
            executor.invokeAll(callableTasks, timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (executor.hasErrors() && (iterator2 = (errors = executor.getErrors()).iterator()).hasNext()) {
                Throwable error = iterator2.next();
                if (error instanceof TargetSetupError) {
                    throw (TargetSetupError)error;
                }
                if (error instanceof BuildError) {
                    throw (BuildError)error;
                }
                if (error instanceof DeviceNotAvailableException) {
                    throw (DeviceNotAvailableException)error;
                }
                throw new RuntimeException(error);
            }
        } else {
            for (String deviceName : testInfo.getContext().getDeviceConfigNames()) {
                this.runPreparationOnDevice(testInfo, deviceName, index, this.getTargetPreparersToRun(config, deviceName), this.mTrackTargetPreparers.get(deviceName), listener);
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLabPreparationOnDevice(TestInformation testInfo, String deviceName, int index, List<ITargetPreparer> labPreparersToRun, Set<ITargetPreparer> trackLabPreparers, ITestLogger logger) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getContext().getDevice(deviceName);
        for (ITargetPreparer preparer : labPreparersToRun) {
            if (preparer.isDisabled()) {
                LogUtil.CLog.d("%s has been disabled. skipping.", preparer);
                continue;
            }
            if (!(preparer instanceof ILabPreparer)) {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.LAB_PREPARER_NOT_ILAB, preparer.getClass().getCanonicalName());
            }
            TfObjectTracker.countWithParents(preparer.getClass());
            if (preparer instanceof ITestLoggerReceiver) {
                ((ITestLoggerReceiver)((Object)preparer)).setTestLogger(logger);
            }
            long startTime = System.currentTimeMillis();
            LogUtil.CLog.d("starting lab preparer '%s' on device: '%s'", preparer, device.getSerialNumber());
            try {
                try (CloseableTraceScope ignore = new CloseableTraceScope(preparer.getClass().getSimpleName());){
                    testInfo.setActiveDeviceIndex(index);
                    preparer.setUp(testInfo);
                }
                testInfo.setActiveDeviceIndex(0);
            }
            catch (Throwable throwable) {
                testInfo.setActiveDeviceIndex(0);
                long elapsedTime = System.currentTimeMillis() - startTime;
                LogUtil.CLog.d("done with lab preparer '%s' on device: '%s' in %s", preparer, device.getSerialNumber(), TimeUtil.formatElapsedTime(elapsedTime));
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationGroupMetricKey.LAB_PREPARER_SETUP_LATENCY, preparer.getClass().getName(), elapsedTime);
                throw throwable;
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogUtil.CLog.d("done with lab preparer '%s' on device: '%s' in %s", preparer, device.getSerialNumber(), TimeUtil.formatElapsedTime(elapsedTime));
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationGroupMetricKey.LAB_PREPARER_SETUP_LATENCY, preparer.getClass().getName(), elapsedTime);
            trackLabPreparers.add(preparer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPreparationOnDevice(TestInformation testInfo, String deviceName, int index, List<ITargetPreparer> targetPreparersToRun, Set<ITargetPreparer> trackPreparers, ITestLogger logger) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getContext().getDevice(deviceName);
        for (ITargetPreparer preparer : targetPreparersToRun) {
            if (preparer.isDisabled()) {
                LogUtil.CLog.d("%s has been disabled. skipping.", preparer);
                continue;
            }
            if (preparer instanceof ILabPreparer) {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.TARGET_PREPARER_IS_ILAB, preparer.getClass().getCanonicalName());
            }
            TfObjectTracker.countWithParents(preparer.getClass());
            if (preparer instanceof ITestLoggerReceiver) {
                ((ITestLoggerReceiver)((Object)preparer)).setTestLogger(logger);
            }
            long startTime = System.currentTimeMillis();
            LogUtil.CLog.d("starting preparer '%s' on device: '%s'", preparer, device.getSerialNumber());
            try (CloseableTraceScope ignore = new CloseableTraceScope(preparer.getClass().getSimpleName());){
                testInfo.setActiveDeviceIndex(index);
                preparer.setUp(testInfo);
            }
            finally {
                testInfo.setActiveDeviceIndex(0);
            }
            trackPreparers.add(preparer);
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogUtil.CLog.d("done with preparer '%s' on device: '%s' in %s", preparer, device.getSerialNumber(), TimeUtil.formatElapsedTime(elapsedTime));
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationGroupMetricKey.TARGET_PREPARER_SETUP_LATENCY, preparer.getClass().getName(), elapsedTime);
        }
        LogUtil.CLog.d("Done with setup of device: '%s'", device.getSerialNumber());
    }

    @Override
    public void runDevicePreInvocationSetup(IInvocationContext context, IConfiguration config, ITestLogger logger) throws DeviceNotAvailableException, TargetSetupError {
        CloseableTraceScope ignore;
        if (config.getCommandOptions().shouldDisableInvocationSetupAndTeardown()) {
            LogUtil.CLog.i("--disable-invocation-setup-and-teardown, skipping pre-invocation setup.");
            return;
        }
        long start = System.currentTimeMillis();
        this.customizeDevicePreInvocation(config, context);
        Integer multiDeviceCount = config.getCommandOptions().getMultiDeviceCount();
        boolean allVirtualDevices = true;
        for (IDeviceConfiguration deviceConfig : config.getDeviceConfig()) {
            if (deviceConfig.getDeviceRequirements().gceDeviceRequested()) continue;
            allVirtualDevices = false;
            break;
        }
        if (multiDeviceCount != null && multiDeviceCount != 1 && allVirtualDevices) {
            ignore = new CloseableTraceScope("runMultiVirtualDevicesPreInvocationSetup");
            try {
                this.runMultiVirtualDevicesPreInvocationSetup(context, config, logger);
            }
            finally {
                ignore.close();
            }
        }
        ignore = new CloseableTraceScope("device_pre_invocation_setup");
        try {
            for (String deviceName : context.getDeviceConfigNames()) {
                IDeviceConfiguration deviceConfig;
                ITestDevice device = context.getDevice(deviceName);
                LogUtil.CLog.d("Starting device pre invocation setup for : '%s'", device.getSerialNumber());
                if (device instanceof ITestLoggerReceiver) {
                    ((ITestLoggerReceiver)((Object)context.getDevice(deviceName))).setTestLogger(logger);
                }
                if ((deviceConfig = config.getDeviceConfigByName(deviceName)) != null && deviceConfig.isFake()) {
                    LogUtil.CLog.d("Skip preInvocationSetup on fake device %s", device);
                    continue;
                }
                device.preInvocationSetup(context.getBuildInfo(deviceName), context.getAttributes());
            }
        }
        finally {
            ignore.close();
        }
        InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.SETUP_PAIR, start, System.currentTimeMillis());
    }

    private void runMultiVirtualDevicesPreInvocationSetup(IInvocationContext context, IConfiguration config, ITestLogger logger) throws TargetSetupError, DeviceNotAvailableException {
        String firstDeviceName = context.getDeviceConfigNames().get(0);
        ITestDevice firstDevice = context.getDevice(firstDeviceName);
        GceManager multiDeviceRequester = new GceManager(firstDevice.getDeviceDescriptor(), firstDevice.getOptions(), context.getBuildInfo(firstDeviceName));
        List<ITestDevice> devices = context.getDevices();
        List<IBuildInfo> buildInfos = context.getBuildInfos();
        for (ITestDevice device : devices) {
            if (!(device instanceof ITestLoggerReceiver)) continue;
            ((ITestLoggerReceiver)((Object)device)).setTestLogger(logger);
        }
        List<GceAvdInfo> gceAvdInfoList = multiDeviceRequester.startMultiDevicesGce(buildInfos, context.getAttributes());
        for (int i = 0; i < devices.size(); ++i) {
            LogUtil.CLog.d("Starting device pre invocation launched device setup with GceAvdInfo %s for : '%s'", gceAvdInfoList.get(i), devices.get(i).getSerialNumber());
            NativeDevice device = (NativeDevice)devices.get(i);
            device.setConnectionAvdInfo(gceAvdInfoList.get(i));
            device.preInvocationSetup(buildInfos.get(i), context.getAttributes());
            if (i == devices.size() - 1) continue;
            LogUtil.CLog.d("Set device %s to skip tear down because only the last device in the device group will be responsible for tearing down the whole device group", device.getSerialNumber());
            device.getOptions().setSkipTearDown(true);
        }
    }

    protected void customizeDevicePreInvocation(IConfiguration config, IInvocationContext context) {
    }

    @Override
    public void runDevicePostInvocationTearDown(IInvocationContext context, IConfiguration config, Throwable exception) {
        if (config.getCommandOptions().shouldDisableInvocationSetupAndTeardown()) {
            LogUtil.CLog.i("--disable-invocation-setup-and-teardown, skipping post-invocation teardown.");
            return;
        }
        for (String deviceName : context.getDeviceConfigNames()) {
            ITestDevice device = context.getDevice(deviceName);
            IDeviceConfiguration deviceConfig = config.getDeviceConfigByName(deviceName);
            if (deviceConfig != null && deviceConfig.isFake()) {
                LogUtil.CLog.d("Skip postInvocationTearDown on fake device %s", device);
                continue;
            }
            device.postInvocationTearDown(exception);
        }
    }

    private void runMultiTargetPreparers(List<IMultiTargetPreparer> multiPreparers, ITestLogger logger, TestInformation testInfo, String description) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mTrackMultiPreparers == null) {
            this.mTrackMultiPreparers = new HashSet<IMultiTargetPreparer>();
        }
        for (IMultiTargetPreparer multiPreparer : multiPreparers) {
            if (multiPreparer.isDisabled()) {
                LogUtil.CLog.d("%s has been disabled. skipping.", multiPreparer);
                continue;
            }
            TfObjectTracker.countWithParents(multiPreparer.getClass());
            if (multiPreparer instanceof ITestLoggerReceiver) {
                ((ITestLoggerReceiver)((Object)multiPreparer)).setTestLogger(logger);
            }
            long startTime = System.currentTimeMillis();
            try (CloseableTraceScope ignore = new CloseableTraceScope(multiPreparer.getClass().getSimpleName());){
                LogUtil.CLog.d("Starting %s '%s'", description, multiPreparer);
                multiPreparer.setUp(testInfo);
                this.mTrackMultiPreparers.add(multiPreparer);
                long elapsedTime = System.currentTimeMillis() - startTime;
                LogUtil.CLog.d("Done with %s '%s' in %s", description, multiPreparer, TimeUtil.formatElapsedTime(elapsedTime));
            }
        }
    }

    private Throwable runMultiTargetPreparersTearDown(List<IMultiTargetPreparer> multiPreparers, TestInformation testInfo, ITestLogger logger, Throwable throwable, String description) throws Throwable {
        ListIterator<IMultiTargetPreparer> iterator2 = multiPreparers.listIterator(multiPreparers.size());
        Throwable deferredThrowable = null;
        while (iterator2.hasPrevious()) {
            long startTime;
            IMultiTargetPreparer multipreparer;
            block11: {
                multipreparer = iterator2.previous();
                if (multipreparer.isDisabled() || multipreparer.isTearDownDisabled()) {
                    LogUtil.CLog.d("%s has been disabled. skipping.", multipreparer);
                    continue;
                }
                if (this.mTrackMultiPreparers == null || !this.mTrackMultiPreparers.contains(multipreparer)) {
                    LogUtil.CLog.d("%s didn't run setUp, skipping tearDown.", multipreparer);
                    continue;
                }
                if (multipreparer instanceof ITestLoggerReceiver) {
                    ((ITestLoggerReceiver)((Object)multipreparer)).setTestLogger(logger);
                }
                startTime = System.currentTimeMillis();
                LogUtil.CLog.d("Starting %s '%s'", description, multipreparer);
                try (CloseableTraceScope ignore = new CloseableTraceScope(multipreparer.getClass().getSimpleName());){
                    multipreparer.tearDown(testInfo, throwable);
                }
                catch (Throwable t) {
                    LogUtil.CLog.e("Deferring throw for:");
                    LogUtil.CLog.e(t);
                    if (deferredThrowable != null) break block11;
                    deferredThrowable = t;
                }
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            LogUtil.CLog.d("Done with %s '%s' in %s", description, multipreparer, TimeUtil.formatElapsedTime(elapsedTime));
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationGroupMetricKey.MULTI_TARGET_PREPARER_TEARDOWN_LATENCY, multipreparer.getClass().getName(), elapsedTime);
        }
        return deferredThrowable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTeardown(TestInformation testInfo, IConfiguration config, ITestLogger logger, Throwable exception) throws Throwable {
        Throwable deferredThrowable;
        IInvocationContext context = testInfo.getContext();
        long start = System.currentTimeMillis();
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.TEARDOWN_START, start);
        try {
            int deviceIndex = 0;
            try {
                List<IMultiTargetPreparer> multiPreparers = config.getMultiTargetPreparers();
                deferredThrowable = this.runMultiTargetPreparersTearDown(multiPreparers, testInfo, logger, exception, "multi target preparer teardown");
                for (String deviceName : context.getDeviceConfigNames()) {
                    ITestDevice device = context.getDevice(deviceName);
                    device.clearLastConnectedWifiNetwork();
                    List<ITargetPreparer> targetPreparersToRun = this.getTargetPreparersToRun(config, deviceName);
                    Throwable firstLocalThrowable = this.runPreparersTearDown(testInfo, device, deviceName, deviceIndex, logger, exception, targetPreparersToRun, this.mTrackTargetPreparers);
                    if (deferredThrowable == null) {
                        deferredThrowable = firstLocalThrowable;
                    }
                    ++deviceIndex;
                }
                if (exception == null) {
                    exception = deferredThrowable;
                }
            }
            finally {
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.TEST_TEARDOWN_PAIR, start, System.currentTimeMillis());
            }
            start = System.currentTimeMillis();
            try {
                deviceIndex = 0;
                for (String deviceName : context.getDeviceConfigNames()) {
                    ITestDevice device = context.getDevice(deviceName);
                    List<ITargetPreparer> labPreparersToRun = this.getLabPreparersToRun(config, deviceName);
                    Throwable secondLocalThrowable = this.runPreparersTearDown(testInfo, device, deviceName, deviceIndex, logger, exception, labPreparersToRun, this.mTrackLabPreparers);
                    if (deferredThrowable == null) {
                        deferredThrowable = secondLocalThrowable;
                    }
                    ++deviceIndex;
                }
                if (exception == null) {
                    exception = deferredThrowable;
                }
                this.runDevicePostInvocationTearDown(context, config, exception);
                List<IMultiTargetPreparer> multiPrePreparers = config.getMultiPreTargetPreparers();
                Throwable preTargetTearDownException = this.runMultiTargetPreparersTearDown(multiPrePreparers, testInfo, logger, exception, "multi pre target preparer teardown");
                if (deferredThrowable == null) {
                    deferredThrowable = preTargetTearDownException;
                }
            }
            finally {
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.TEARDOWN_PAIR, start, System.currentTimeMillis());
            }
        }
        finally {
            this.logHostAdb(config, logger);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.TEARDOWN_END, System.currentTimeMillis());
        }
        if (deferredThrowable != null) {
            throw deferredThrowable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Throwable runPreparersTearDown(TestInformation testInfo, ITestDevice device, String deviceName, int deviceIndex, ITestLogger logger, Throwable exception, List<ITargetPreparer> preparersToRun, Map<String, Set<ITargetPreparer>> trackPreparersMap) {
        Throwable deferredThrowable = null;
        ListIterator<ITargetPreparer> itr = preparersToRun.listIterator(preparersToRun.size());
        while (itr.hasPrevious()) {
            long elapsedTime;
            ITargetPreparer preparer = itr.previous();
            if (preparer.isDisabled() || preparer.isTearDownDisabled()) {
                LogUtil.CLog.d("%s has been disabled. skipping.", preparer);
                continue;
            }
            if (trackPreparersMap == null || !trackPreparersMap.containsKey(deviceName) || !trackPreparersMap.get(deviceName).contains(preparer)) {
                LogUtil.CLog.d("%s didn't run setUp, skipping tearDown.", preparer);
                continue;
            }
            if (preparer instanceof ITestLoggerReceiver) {
                ((ITestLoggerReceiver)((Object)preparer)).setTestLogger(logger);
            }
            long startTime = System.currentTimeMillis();
            try {
                try (CloseableTraceScope remoteTest = new CloseableTraceScope(preparer.getClass().getSimpleName());){
                    LogUtil.CLog.d("starting tearDown '%s' on device: '%s'", preparer, device.getSerialNumber());
                    testInfo.setActiveDeviceIndex(deviceIndex);
                    Throwable tearDownException = exception;
                    if (exception == null && deferredThrowable != null) {
                        tearDownException = deferredThrowable;
                    }
                    preparer.tearDown(testInfo, tearDownException);
                }
                testInfo.setActiveDeviceIndex(0);
            }
            catch (Throwable e) {
                try {
                    LogUtil.CLog.e("Deferring throw for:");
                    LogUtil.CLog.e(e);
                    if (deferredThrowable == null) {
                        deferredThrowable = e;
                    }
                    testInfo.setActiveDeviceIndex(0);
                }
                catch (Throwable throwable) {
                    testInfo.setActiveDeviceIndex(0);
                    long elapsedTime2 = System.currentTimeMillis() - startTime;
                    LogUtil.CLog.d("done with tearDown '%s' on device: '%s' in %s", preparer, device.getSerialNumber(), TimeUtil.formatElapsedTime(elapsedTime2));
                    InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationGroupMetricKey.TARGET_PREPARER_TEARDOWN_LATENCY, preparer.getClass().getName(), elapsedTime2);
                    throw throwable;
                }
                elapsedTime = System.currentTimeMillis() - startTime;
                LogUtil.CLog.d("done with tearDown '%s' on device: '%s' in %s", preparer, device.getSerialNumber(), TimeUtil.formatElapsedTime(elapsedTime));
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationGroupMetricKey.TARGET_PREPARER_TEARDOWN_LATENCY, preparer.getClass().getName(), elapsedTime);
                continue;
            }
            elapsedTime = System.currentTimeMillis() - startTime;
            LogUtil.CLog.d("done with tearDown '%s' on device: '%s' in %s", preparer, device.getSerialNumber(), TimeUtil.formatElapsedTime(elapsedTime));
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationGroupMetricKey.TARGET_PREPARER_TEARDOWN_LATENCY, preparer.getClass().getName(), elapsedTime);
        }
        return deferredThrowable;
    }

    @Override
    public void doCleanUp(IInvocationContext context, IConfiguration config, Throwable exception) {
        for (String deviceName : context.getDeviceConfigNames()) {
            List<ITargetPreparer> targetPreparers = this.getTargetPreparersToRun(config, deviceName);
            ListIterator<ITargetPreparer> itr = targetPreparers.listIterator(targetPreparers.size());
            while (itr.hasPrevious()) {
                ITargetPreparer preparer = itr.previous();
                if (!(preparer instanceof IHostCleaner)) continue;
                IHostCleaner cleaner = (IHostCleaner)((Object)preparer);
                if (preparer.isDisabled() || preparer.isTearDownDisabled()) {
                    LogUtil.CLog.d("%s has been disabled. skipping.", cleaner);
                    continue;
                }
                cleaner.cleanUp(context.getBuildInfo(deviceName), exception);
            }
            List<ITargetPreparer> labPreparers = this.getLabPreparersToRun(config, deviceName);
            itr = labPreparers.listIterator(labPreparers.size());
            while (itr.hasPrevious()) {
                ITargetPreparer preparer = itr.previous();
                if (!(preparer instanceof IHostCleaner)) continue;
                IHostCleaner cleaner = (IHostCleaner)((Object)preparer);
                if (preparer.isDisabled() || preparer.isTearDownDisabled()) {
                    LogUtil.CLog.d("%s has been disabled. skipping.", cleaner);
                    continue;
                }
                cleaner.cleanUp(context.getBuildInfo(deviceName), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTests(TestInformation info, IConfiguration config, ITestInvocationListener listener) throws Throwable {
        Timer testPhaseTimer = new Timer(true);
        long remainingTestPhaseTime = GlobalConfiguration.getInstance().getHostOptions().getTestPhaseTimeout();
        boolean testPhaseTimeoutNeeded = remainingTestPhaseTime > 0L;
        long invocationTimeout = config.getCommandOptions().getInvocationTimeout();
        if (testPhaseTimeoutNeeded && invocationTimeout > 0L) {
            remainingTestPhaseTime = Math.min(remainingTestPhaseTime, invocationTimeout);
        }
        ArrayList<IRemoteTest> remainingTests = new ArrayList<IRemoteTest>(config.getTests());
        UnexecutedTestReporterThread reporterThread = new UnexecutedTestReporterThread(listener, remainingTests);
        Runtime.getRuntime().addShutdownHook(reporterThread);
        TestInvocation.printStageDelimiter(TestInvocation.Stage.TEST, false);
        long start = System.currentTimeMillis();
        try (CloseableTraceScope ignored = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.test_execution.name());){
            GetPreviousPassedHelper previousPassHelper = new GetPreviousPassedHelper();
            Set<String> previousPassedFilters = previousPassHelper.getPreviousPassedFilters(config);
            config.getGlobalFilters().addPreviousPassedTests(previousPassedFilters);
            for (IRemoteTest test : config.getTests()) {
                try (CloseableTraceScope remoteTest = new CloseableTraceScope(test.getClass().getSimpleName());){
                    RetryStatistics retryStats;
                    TfObjectTracker.countWithParents(test.getClass());
                    if (test instanceof IDeviceTest) {
                        ((IDeviceTest)((Object)test)).setDevice(info.getDevice());
                    }
                    if (test instanceof IBuildReceiver) {
                        ((IBuildReceiver)((Object)test)).setBuild(info.getBuildInfo());
                    }
                    if (test instanceof ISystemStatusCheckerReceiver) {
                        ((ISystemStatusCheckerReceiver)((Object)test)).setSystemStatusChecker(config.getSystemStatusCheckers());
                    }
                    if (test instanceof IInvocationContextReceiver) {
                        ((IInvocationContextReceiver)((Object)test)).setInvocationContext(info.getContext());
                    }
                    this.updateAutoCollectors(config);
                    IRetryDecision decision = config.getRetryDecision();
                    if (test instanceof ITestFilterReceiver) {
                        config.getGlobalFilters().applyFiltersToTest((ITestFilterReceiver)((Object)test));
                    } else if (test instanceof BaseTestSuite) {
                        config.getGlobalFilters().applyFiltersToTest((BaseTestSuite)test);
                    }
                    if (!decision.isAutoRetryEnabled() || RetryStrategy.NO_RETRY.equals((Object)decision.getRetryStrategy()) || test instanceof ITestSuite || test instanceof TestsPoolPoller || !(test instanceof ITestFilterReceiver) && !(test instanceof IAutoRetriableTest) && !RetryStrategy.ITERATIONS.equals((Object)decision.getRetryStrategy())) {
                        try {
                            long timeSpentOnTest = this.runTest(config, info, listener, test, testPhaseTimer, remainingTestPhaseTime, testPhaseTimeoutNeeded);
                            remainingTestPhaseTime -= timeSpentOnTest;
                        }
                        finally {
                            CurrentInvocation.setRunIsolation(CurrentInvocation.IsolationGrade.NOT_ISOLATED);
                            CurrentInvocation.setModuleIsolation(CurrentInvocation.IsolationGrade.NOT_ISOLATED);
                            if (test instanceof BaseTestSuite) {
                                ((BaseTestSuite)test).cleanUpSuiteSetup();
                            }
                        }
                        remainingTests.remove(test);
                        continue;
                    }
                    LogUtil.CLog.d("Using RetryLogSaverResultForwarder to forward results.");
                    ModuleListener mainGranularRunListener = new ModuleListener(null, info.getContext());
                    RetryLogSaverResultForwarder runListener = this.initializeListeners(config, listener, mainGranularRunListener);
                    mainGranularRunListener.setAttemptIsolation(CurrentInvocation.runCurrentIsolation());
                    try {
                        long timeSpentOnTest = this.runTest(config, info, runListener, test, testPhaseTimer, remainingTestPhaseTime, testPhaseTimeoutNeeded);
                        remainingTestPhaseTime -= timeSpentOnTest;
                    }
                    finally {
                        CurrentInvocation.setRunIsolation(CurrentInvocation.IsolationGrade.NOT_ISOLATED);
                        CurrentInvocation.setModuleIsolation(CurrentInvocation.IsolationGrade.NOT_ISOLATED);
                    }
                    remainingTests.remove(test);
                    runListener.incrementAttempt();
                    if (!decision.shouldRetry(test, 0, mainGranularRunListener.getTestRunForAttempts(0))) continue;
                    boolean firstCheck = true;
                    long startTime = System.currentTimeMillis();
                    try {
                        PrettyPrintDelimiter.printStageDelimiter("Starting auto-retry");
                        for (int attemptNumber = 1; attemptNumber < decision.getMaxRetryCount(); ++attemptNumber) {
                            boolean retry;
                            if (!firstCheck && !(retry = decision.shouldRetry(test, attemptNumber - 1, mainGranularRunListener.getTestRunForAttempts(attemptNumber - 1)))) continue;
                            firstCheck = false;
                            LogUtil.CLog.d("auto-retry attempt number '%s'", attemptNumber);
                            mainGranularRunListener.setAttemptIsolation(CurrentInvocation.runCurrentIsolation());
                            try {
                                long timeSpent = this.runTest(config, info, runListener, test, testPhaseTimer, remainingTestPhaseTime, testPhaseTimeoutNeeded);
                                remainingTestPhaseTime -= timeSpent;
                            }
                            finally {
                                CurrentInvocation.setRunIsolation(CurrentInvocation.IsolationGrade.NOT_ISOLATED);
                                CurrentInvocation.setModuleIsolation(CurrentInvocation.IsolationGrade.NOT_ISOLATED);
                            }
                            runListener.incrementAttempt();
                        }
                        decision.addLastAttempt(mainGranularRunListener.getTestRunForAttempts(decision.getMaxRetryCount() - 1));
                        retryStats = decision.getRetryStatistics();
                    }
                    catch (Throwable throwable) {
                        RetryStatistics retryStats2 = decision.getRetryStatistics();
                        retryStats2.mRetryTime = System.currentTimeMillis() - startTime;
                        this.addRetryTime(retryStats2.mRetryTime);
                        throw throwable;
                    }
                    retryStats.mRetryTime = System.currentTimeMillis() - startTime;
                    this.addRetryTime(retryStats.mRetryTime);
                }
            }
        }
        finally {
            testPhaseTimer.cancel();
            TestInvocation.printStageDelimiter(TestInvocation.Stage.TEST, true);
            try {
                Runtime.getRuntime().removeShutdownHook(reporterThread);
            }
            catch (IllegalStateException illegalStateException) {}
            if (!InvocationMetricLogger.getInvocationMetrics().containsKey(InvocationMetricLogger.InvocationMetricKey.TEST_PAIR.toString())) {
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.TEST_PAIR, start, System.currentTimeMillis());
            }
        }
    }

    @Override
    public void reportLogs(ITestDevice device, ITestLogger listener, TestInvocation.Stage stage) {
        String name;
        if (device == null) {
            return;
        }
        IDevice idevice = device.getIDevice();
        try (InputStreamSource logcatSource = device.getLogcat();){
            device.clearLogcat();
            if (logcatSource != null && logcatSource.size() > 0L) {
                name = String.format("%s_%s", TestInvocation.getDeviceLogName(stage), device.getSerialNumber());
                listener.testLog(name, LogDataType.LOGCAT, logcatSource);
            }
        }
        if (idevice != null && idevice.isEmulator()) {
            try (InputStreamSource emulatorOutput = device.getEmulatorOutput();){
                name = TestInvocation.getEmulatorLogName(stage);
                listener.testLog(name, LogDataType.TEXT, emulatorOutput);
            }
        }
    }

    private String getTestTag(IConfiguration config) {
        String testTag = config.getCommandOptions().getTestTag();
        if (config.getCommandOptions().getTestTagSuffix() != null) {
            testTag = String.format("%s-%s", testTag, config.getCommandOptions().getTestTagSuffix());
        }
        return testTag;
    }

    protected void setTestTag(IBuildInfo info, IConfiguration config) {
        if (!"stub".equals(config.getCommandOptions().getTestTag())) {
            info.setTestTag(this.getTestTag(config));
        } else if (Strings.isNullOrEmpty(info.getTestTag())) {
            info.setTestTag("stub");
        }
    }

    void updateBuild(IBuildInfo info, IConfiguration config) {
        this.setTestTag(info, config);
        if (config.getCommandOptions().getInvocationData().containsKey("subprocess")) {
            return;
        }
        if (config.getCommandLine() != null) {
            info.addBuildAttribute("command_line_args", config.getCommandLine());
        }
        if (config.getCommandOptions().getShardCount() != null) {
            info.addBuildAttribute("shard_count", config.getCommandOptions().getShardCount().toString());
        }
        if (config.getCommandOptions().getShardIndex() != null) {
            info.addBuildAttribute("shard_index", config.getCommandOptions().getShardIndex().toString());
        }
    }

    private long runTest(IConfiguration config, TestInformation info, ITestInvocationListener listener, IRemoteTest test, Timer timer, long testPhaseTimeout, boolean testPhaseTimeoutNeeded) throws DeviceNotAvailableException, Throwable {
        ArrayList<IMetricCollector> clonedCollectors = new ArrayList<IMetricCollector>();
        for (AutoLogCollector auto : config.getCommandOptions().getAutoLogCollectors()) {
            clonedCollectors.add(auto.getInstanceForValue());
        }
        clonedCollectors.addAll(CollectorHelper.cloneCollectors(config.getMetricCollectors()));
        if (test instanceof IMetricCollectorReceiver) {
            ((IMetricCollectorReceiver)((Object)test)).setMetricCollectors(clonedCollectors);
            if (testPhaseTimeoutNeeded) {
                return this.runTestThread(info, listener, test, timer, testPhaseTimeout);
            }
            long startTime = System.currentTimeMillis();
            test.run(info, listener);
            return System.currentTimeMillis() - startTime;
        }
        ITestInvocationListener listenerWithCollectors = listener;
        if (config.getCommandOptions().reportTestCaseCount()) {
            CountTestCasesCollector counter = new CountTestCasesCollector(test);
            clonedCollectors.add(counter);
        }
        for (IMetricCollector collector : clonedCollectors) {
            if (collector.isDisabled()) {
                LogUtil.CLog.d("%s has been disabled. Skipping.", collector);
                continue;
            }
            if (collector instanceof IConfigurationReceiver) {
                ((IConfigurationReceiver)((Object)collector)).setConfiguration(config);
            }
            listenerWithCollectors = collector.init(info.getContext(), listenerWithCollectors);
            TfObjectTracker.countWithParents(collector.getClass());
        }
        if (testPhaseTimeoutNeeded) {
            return this.runTestThread(info, listenerWithCollectors, test, timer, testPhaseTimeout);
        }
        long startTime = System.currentTimeMillis();
        test.run(info, listenerWithCollectors);
        return System.currentTimeMillis() - startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long runTestThread(TestInformation info, ITestInvocationListener listener, IRemoteTest test, Timer timer, long testPhaseTimeout) throws Throwable {
        if (testPhaseTimeout <= 0L) {
            throw new RunInterruptedException("Test Phase Timeout Reached.", TestErrorIdentifier.TEST_PHASE_TIMED_OUT);
        }
        TestThread testThread = new TestThread(info, listener, test);
        TestPhaseMonitor testPhaseMonitor = new TestPhaseMonitor(testThread);
        timer.schedule((TimerTask)testPhaseMonitor, testPhaseTimeout);
        long startTime = System.currentTimeMillis();
        testThread.start();
        try {
            testThread.join();
        }
        catch (InterruptedException e) {
            LogUtil.CLog.e(e);
        }
        finally {
            testPhaseMonitor.cancel();
            long timeSpent = System.currentTimeMillis() - startTime;
            if (testThread.getLastThrownException() != null) {
                throw testThread.getLastThrownException();
            }
            return timeSpent;
        }
    }

    private RetryLogSaverResultForwarder initializeListeners(IConfiguration config, ITestInvocationListener mainListener, ITestInvocationListener mainGranularLevelListener) {
        ArrayList<ITestInvocationListener> currentTestListeners = new ArrayList<ITestInvocationListener>();
        currentTestListeners.add(mainGranularLevelListener);
        currentTestListeners.add(mainListener);
        return new RetryLogSaverResultForwarder(config.getLogSaver(), currentTestListeners){

            @Override
            public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
                this.testLogForward(dataName, dataType, dataStream);
            }
        };
    }

    private void addRetryTime(long retryTimeMs) {
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.AUTO_RETRY_TIME, retryTimeMs);
    }

    private void linkExternalDirs(IBuildInfo info, TestInformation testInfo) {
        File testsDir;
        if (info.getProperties().contains((Object)IBuildInfo.BuildInfoProperties.DO_NOT_LINK_TESTS_DIR)) {
            LogUtil.CLog.d("Skip linking external directory as FileProperty was set.");
            return;
        }
        if (info instanceof IDeviceBuildInfo && (testsDir = ((IDeviceBuildInfo)info).getTestsDir()) != null && testsDir.exists()) {
            File hostTestCases;
            File targetTestCases;
            if (testInfo.executionFiles().get(ExecutionFiles.FilesKey.TARGET_TESTS_DIRECTORY) == null && (targetTestCases = this.handleLinkingExternalDirs((IDeviceBuildInfo)info, testsDir, SystemUtil.EnvVariable.ANDROID_TARGET_OUT_TESTCASES, BuildInfoKey.BuildInfoFileKey.TARGET_LINKED_DIR.getFileKey())) != null) {
                testInfo.executionFiles().put(ExecutionFiles.FilesKey.TARGET_TESTS_DIRECTORY, targetTestCases, true);
            }
            if (testInfo.executionFiles().get(ExecutionFiles.FilesKey.HOST_TESTS_DIRECTORY) == null && (hostTestCases = this.handleLinkingExternalDirs((IDeviceBuildInfo)info, testsDir, SystemUtil.EnvVariable.ANDROID_HOST_OUT_TESTCASES, BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR.getFileKey())) != null) {
                testInfo.executionFiles().put(ExecutionFiles.FilesKey.HOST_TESTS_DIRECTORY, hostTestCases, true);
            }
        }
    }

    private File handleLinkingExternalDirs(IDeviceBuildInfo info, File testsDir, SystemUtil.EnvVariable var, String baseName) {
        File externalDir = this.getExternalTestCasesDirs(var);
        if (externalDir == null) {
            String path = SystemUtil.ENV_VARIABLE_PATHS_IN_TESTS_DIR.get((Object)var);
            File varDir = FileUtil.getFileForPath(testsDir, path);
            if (varDir.exists()) {
                info.setFile(baseName, varDir, "v1");
                return varDir;
            }
            return null;
        }
        try {
            File subDir = FileUtil.createTempDir(baseName, testsDir);
            subDir.delete();
            FileUtil.symlinkFile(externalDir, subDir);
            info.setFile(baseName, subDir, "v1");
            subDir.deleteOnExit();
            return subDir;
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to load external test dir %s. Ignoring it.", externalDir);
            LogUtil.CLog.e(e);
            return null;
        }
    }

    private void setBinariesVersion(IInvocationContext context) {
        String javaClasspath;
        String javaVersion;
        String version = this.getAdbVersion();
        if (version != null) {
            context.addInvocationAttribute(ADB_VERSION_KEY, version);
        }
        if ((javaVersion = System.getProperty("java.version")) != null && !javaVersion.isEmpty()) {
            context.addInvocationAttribute(JAVA_VERSION_KEY, javaVersion);
        }
        if ((javaClasspath = System.getProperty("java.class.path")) != null && !javaClasspath.isEmpty()) {
            context.addInvocationAttribute(JAVA_CLASSPATH_KEY, javaClasspath);
        }
    }

    private void copyRemoteFiles(ICommandOptions options, IBuildInfo info) {
        for (String remoteFile : options.getRemoteFiles()) {
            info.setFile("remote_file:", new File(remoteFile), "");
        }
    }

    private void updateAutoCollectors(IConfiguration config) {
        if (config.getCommandOptions().captureScreenshotOnFailure()) {
            config.getCommandOptions().getAutoLogCollectors().add(AutoLogCollector.SCREENSHOT_ON_FAILURE);
        }
        if (config.getCommandOptions().captureLogcatOnFailure()) {
            config.getCommandOptions().getAutoLogCollectors().add(AutoLogCollector.LOGCAT_ON_FAILURE);
        }
    }

    @VisibleForTesting
    protected void logHostAdb(IConfiguration config, ITestLogger logger) {
        CommandResult uidRes;
        if (SystemUtil.isLocalMode()) {
            return;
        }
        if (config.getCommandOptions().getInvocationData().containsKey("subprocess")) {
            return;
        }
        String tmpDir = "/tmp";
        if (System.getenv("TMPDIR") != null) {
            tmpDir = System.getenv("TMPDIR");
        }
        if (!CommandStatus.SUCCESS.equals((Object)(uidRes = RunUtil.getDefault().runTimedCmd(60000L, "id", "-u", System.getProperty("user.name"))).getStatus())) {
            LogUtil.CLog.e("Failed to collect UID for adb logs: %s", uidRes.getStderr());
            return;
        }
        String uid = uidRes.getStdout().trim();
        File adbLog = new File(tmpDir, String.format("adb.%s.log", uid));
        if (!adbLog.exists()) {
            LogUtil.CLog.i("Did not find adb log file: %s, upload skipped.", adbLog);
            return;
        }
        CommandResult truncAdb = RunUtil.getDefault().runTimedCmd(60000L, "tail", "-c", "10MB", adbLog.getAbsolutePath());
        if (!CommandStatus.SUCCESS.equals((Object)truncAdb.getStatus())) {
            LogUtil.CLog.e("Failed to truncate the adb log: %s\n%s", adbLog, truncAdb.getStderr());
            return;
        }
        try (ByteArrayInputStreamSource source = new ByteArrayInputStreamSource(truncAdb.getStdout().getBytes());){
            logger.testLog("host_adb_log", LogDataType.ADB_HOST_LOG, source);
        }
    }

    @VisibleForTesting
    File getExternalTestCasesDirs(SystemUtil.EnvVariable envVar) {
        return SystemUtil.getExternalTestCasesDir(envVar);
    }

    protected String getAdbVersion() {
        return GlobalConfiguration.getDeviceManagerInstance().getAdbVersion();
    }

    protected void collectAutoInfo(IConfiguration config, TestInformation info) throws DeviceNotAvailableException {
        if (SystemUtil.isLocalMode()) {
            return;
        }
        if (config.getCommandOptions().getInvocationData().containsKey("subprocess")) {
            return;
        }
        ITestDevice device = info.getDevice();
        if (device.getIDevice() instanceof StubDevice) {
            return;
        }
        try (CloseableTraceScope ignored = new CloseableTraceScope("collect_device_info");){
            String vendor_img_info;
            String system_img_info;
            CommandResult kernelInfoResult = device.executeShellV2Command("uname -a");
            if (kernelInfoResult != null && CommandStatus.SUCCESS.equals((Object)kernelInfoResult.getStatus())) {
                info.getBuildInfo().addBuildAttribute("device_kernel_info", kernelInfoResult.getStdout().trim());
            }
            if ((system_img_info = device.getProperty("ro.system.build.fingerprint")) != null) {
                info.getBuildInfo().addBuildAttribute("system_img_info", system_img_info);
            }
            if ((vendor_img_info = device.getProperty("ro.vendor.build.fingerprint")) != null) {
                info.getBuildInfo().addBuildAttribute("vendor_img_info", vendor_img_info);
            }
        }
    }

    private class TestThread
    extends Thread {
        private TestInformation mTestInfo;
        private ITestInvocationListener mTestListener;
        private IRemoteTest mTest;
        private Throwable lastThrownException;

        public TestThread(TestInformation info, ITestInvocationListener listener, IRemoteTest test) {
            this.mTestInfo = info;
            this.mTestListener = listener;
            this.mTest = test;
        }

        @Override
        public void run() {
            try {
                this.mTest.run(this.mTestInfo, this.mTestListener);
            }
            catch (Exception e) {
                this.lastThrownException = e;
            }
        }

        public Throwable getLastThrownException() {
            return this.lastThrownException;
        }

        public void stopTestThread() {
            this.interrupt();
            this.mTestInfo.notifyTimeout();
            this.lastThrownException = new RunInterruptedException("Test Phase Timeout Reached.", TestErrorIdentifier.TEST_PHASE_TIMED_OUT);
        }
    }

    private class TestPhaseMonitor
    extends TimerTask {
        private TestThread mTestThread;

        public TestPhaseMonitor(TestThread toMonitor) {
            this.mTestThread = toMonitor;
        }

        @Override
        public void run() {
            if (this.mTestThread != null) {
                this.mTestThread.stopTestThread();
            }
        }
    }
}

