/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.command.CommandRunner;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfigOptionValueTransformer;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceOptions;
import com.android.tradefed.device.cloud.GceAvdInfo;
import com.android.tradefed.device.cloud.GceManager;
import com.android.tradefed.device.cloud.ManagedRemoteDevice;
import com.android.tradefed.device.cloud.RemoteFileUtil;
import com.android.tradefed.device.connection.AdbSshConnection;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.internal.protobuf.InvalidProtocolBufferException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.IRescheduler;
import com.android.tradefed.invoker.InvocationExecution;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.proto.FileProtoResultReporter;
import com.android.tradefed.result.proto.ProtoResultParser;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.SerializationUtil;
import com.android.tradefed.util.SubprocessExceptionParser;
import com.android.tradefed.util.TimeUtil;
import com.android.tradefed.util.proto.TestRecordProtoUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;

public class RemoteInvocationExecution
extends InvocationExecution {
    public static final String START_FEATURE_SERVER = "START_FEATURE_SERVER";
    public static final long PUSH_TF_TIMEOUT = 150000L;
    public static final long PULL_RESULT_TIMEOUT = 180000L;
    public static final long REMOTE_PROCESS_RUNNING_WAIT = 15000L;
    public static final long LAUNCH_EXTRA_DEVICE = 900000L;
    public static final long SETUP_REMOTE_DIR_TIMEOUT = 600000L;
    public static final long NEW_USER_TIMEOUT = 300000L;
    public static final long JOIN_CLEAN_TIMEOUT_MS = 120000L;
    public static final String REMOTE_USER_DIR = "/home/{$USER}/";
    public static final String PROTO_RESULT_NAME = "output.pb";
    public static final String STDOUT_FILE = "screen-VM_tradefed-stdout.txt";
    public static final String STDERR_FILE = "screen-VM_tradefed-stderr.txt";
    public static final String REMOTE_CONFIG = "configuration";
    public static final String GLOBAL_REMOTE_CONFIG = "global-remote-configuration";
    private static final int MAX_CONNECTION_REFUSED_COUNT = 3;
    private static final int MAX_PUSH_TF_ATTEMPTS = 3;
    private static final String TRADEFED_EARLY_TERMINATION = "Remote Tradefed might have terminated early.\nRemote Stderr:\n%s";
    private static final String[] INVOCATION_CONTEXT_ATTR_TO_DATA = new String[]{"invocation_id", "work_unit_id"};
    private String mRemoteTradefedDir = null;
    private String mRemoteAdbPath = null;
    private ProtoResultParser mProtoParser = null;
    private String mRemoteConsoleStdErr = null;

    @Override
    public boolean fetchBuild(TestInformation testInfo, IConfiguration config, IRescheduler rescheduler, ITestInvocationListener listener) throws DeviceNotAvailableException, BuildRetrievalError {
        StubBuildProvider stubProvider = new StubBuildProvider();
        String deviceName = config.getDeviceConfig().get(0).getDeviceName();
        OptionCopier.copyOptionsNoThrow(config.getDeviceConfig().get(0).getBuildProvider(), stubProvider);
        IBuildInfo info = stubProvider.getBuild();
        if (info == null) {
            return false;
        }
        testInfo.getContext().addDeviceBuildInfo(deviceName, info);
        this.updateBuild(info, config);
        return true;
    }

    @Override
    protected void customizeDevicePreInvocation(IConfiguration config, IInvocationContext context) {
        super.customizeDevicePreInvocation(config, context);
        if (config.getCommandOptions().getShardCount() != null && config.getCommandOptions().getShardIndex() == null && !config.getCommandOptions().isRemoteInvocationDeviceless()) {
            ITestDevice device = context.getDevices().get(0);
            TestDeviceOptions options = device.getOptions();
            options.addGceDriverParams("--num-avds-per-instance");
            String count = config.getCommandOptions().getShardCount().toString();
            options.addGceDriverParams(count);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CF_INSTANCE_COUNT, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTests(TestInformation info, IConfiguration config, ITestInvocationListener listener) throws Throwable {
        FileOptionValueTransformer fileTransformer;
        File globalConfig;
        File configFile;
        CommandResult cr;
        String invocationWorkDir;
        TestDeviceOptions options;
        RunUtil runUtil;
        GceAvdInfo gceInfo;
        block26: {
            block24: {
                ManagedRemoteDevice device = (ManagedRemoteDevice)info.getDevice();
                gceInfo = ((AdbSshConnection)device.getConnection()).getAvdInfo();
                runUtil = new RunUtil();
                options = device.getOptions();
                String mainRemoteDir = this.getRemoteMainDir(options);
                this.mRemoteAdbPath = String.format("/home/%s/bin/adb", options.getInstanceUser());
                File tfToPush = this.getLocalTradefedPath(listener, options.getRemoteTf());
                if (tfToPush == null) {
                    return;
                }
                invocationWorkDir = String.format("%stf-invocation-%s/", mainRemoteDir, UUID.randomUUID().toString());
                LogUtil.CLog.d("Remote invocation work directory is at %s", invocationWorkDir);
                cr = GceManager.remoteSshCommandExecution(gceInfo, options, runUtil, 120000L, "mkdir", "-p", invocationWorkDir);
                if (!CommandStatus.SUCCESS.equals((Object)cr.getStatus())) {
                    LogUtil.CLog.e("Creation of %s failed.", invocationWorkDir);
                    LogUtil.CLog.e("Command stdout: %s, stderr: %s", cr.getStdout(), cr.getStderr());
                    listener.invocationFailed(this.createInvocationFailure("Failed to create remote tradefed dir.", TestRecordProto.FailureStatus.INFRA_FAILURE));
                    return;
                }
                boolean result = false;
                for (int attempt = 0; !result && attempt < 3; ++attempt) {
                    result = RemoteFileUtil.pushFileToRemote(gceInfo, options, Arrays.asList("-r"), runUtil, 150000L, invocationWorkDir, tfToPush);
                }
                if (!result) {
                    LogUtil.CLog.e("Failed to push Tradefed.");
                    listener.invocationFailed(this.createInvocationFailure("Failed to push Tradefed.", TestRecordProto.FailureStatus.INFRA_FAILURE));
                    return;
                }
                this.mRemoteTradefedDir = invocationWorkDir + tfToPush.getName() + "/";
                CommandResult listRemoteDir = GceManager.remoteSshCommandExecution(gceInfo, options, runUtil, 120000L, "ls", "-l", this.mRemoteTradefedDir);
                LogUtil.CLog.d("stdout: %s", listRemoteDir.getStdout());
                LogUtil.CLog.d("stderr: %s", listRemoteDir.getStderr());
                configFile = this.createRemoteConfig(info.getContext(), config, listener, this.mRemoteTradefedDir);
                globalConfig = null;
                LogUtil.CLog.d("Pushing Tradefed XML configuration to remote.");
                boolean resultPush = RemoteFileUtil.pushFileToRemote(gceInfo, options, null, runUtil, 150000L, this.mRemoteTradefedDir, configFile);
                if (resultPush) break block24;
                LogUtil.CLog.e("Failed to push Tradefed Configuration.");
                listener.invocationFailed(this.createInvocationFailure("Failed to push Tradefed Configuration.", TestRecordProto.FailureStatus.INFRA_FAILURE));
                FileUtil.recursiveDelete(configFile);
                FileUtil.recursiveDelete(globalConfig);
                cr = GceManager.remoteSshCommandExecution(gceInfo, options, runUtil, 120000L, "rm", "-rf", invocationWorkDir);
                if (!CommandStatus.SUCCESS.equals((Object)cr.getStatus())) {
                    LogUtil.CLog.w("Clean up of %s failed.", invocationWorkDir);
                    LogUtil.CLog.w("Command stdout: %s, stderr: %s", cr.getStdout(), cr.getStderr());
                }
                return;
            }
            String[] allowListConfigs = new String[]{"sandbox_factory", "host_options", "android-build"};
            fileTransformer = new FileOptionValueTransformer(this.mRemoteTradefedDir);
            try {
                globalConfig = GlobalConfiguration.getInstance().cloneConfigWithFilter(new HashSet<String>(), fileTransformer, true, allowListConfigs);
            }
            catch (IOException e) {
                listener.invocationFailed(this.createInvocationFailure(e, TestRecordProto.FailureStatus.INFRA_FAILURE));
                FileUtil.recursiveDelete(configFile);
                FileUtil.recursiveDelete(globalConfig);
                cr = GceManager.remoteSshCommandExecution(gceInfo, options, runUtil, 120000L, "rm", "-rf", invocationWorkDir);
                if (!CommandStatus.SUCCESS.equals((Object)cr.getStatus())) {
                    LogUtil.CLog.w("Clean up of %s failed.", invocationWorkDir);
                    LogUtil.CLog.w("Command stdout: %s, stderr: %s", cr.getStdout(), cr.getStderr());
                }
                return;
            }
            try (FileInputStreamSource source = new FileInputStreamSource(globalConfig);){
                listener.testLog(GLOBAL_REMOTE_CONFIG, LogDataType.HARNESS_CONFIG, source);
            }
            boolean resultPushGlobal = RemoteFileUtil.pushFileToRemote(gceInfo, options, null, runUtil, 150000L, this.mRemoteTradefedDir, globalConfig);
            if (resultPushGlobal) break block26;
            LogUtil.CLog.e("Failed to push Tradefed Global Configuration.");
            listener.invocationFailed(this.createInvocationFailure("Failed to push Tradefed Global Configuration.", TestRecordProto.FailureStatus.INFRA_FAILURE));
            FileUtil.recursiveDelete(configFile);
            FileUtil.recursiveDelete(globalConfig);
            cr = GceManager.remoteSshCommandExecution(gceInfo, options, runUtil, 120000L, "rm", "-rf", invocationWorkDir);
            if (!CommandStatus.SUCCESS.equals((Object)cr.getStatus())) {
                LogUtil.CLog.w("Clean up of %s failed.", invocationWorkDir);
                LogUtil.CLog.w("Command stdout: %s, stderr: %s", cr.getStdout(), cr.getStderr());
            }
            return;
        }
        try {
            if (!fileTransformer.getRenamedFiles().isEmpty()) {
                ArrayList<String> pushErrors = new ArrayList<String>();
                LogUtil.CLog.d("Pushing files referenced in global config to remote.");
                for (Map.Entry<String, String> entry : fileTransformer.getRenamedFiles().entrySet()) {
                    boolean pushResult = RemoteFileUtil.pushFileToRemote(gceInfo, options, null, runUtil, 150000L, entry.getValue(), new File(entry.getKey()));
                    if (pushResult) continue;
                    pushErrors.add(entry.getKey());
                }
                LogUtil.CLog.d("Done pushing files.");
                if (!pushErrors.isEmpty()) {
                    listener.invocationFailed(this.createInvocationFailure("Failed to push some files to remote: " + pushErrors, TestRecordProto.FailureStatus.INFRA_FAILURE));
                }
            }
            this.resetAdb(gceInfo, options, runUtil);
            this.runRemote(listener, info.getContext(), configFile, gceInfo, options, runUtil, config, globalConfig);
            this.collectAdbLogs(gceInfo, options, runUtil, listener);
        }
        catch (Throwable throwable) {
            FileUtil.recursiveDelete(configFile);
            FileUtil.recursiveDelete(globalConfig);
            cr = GceManager.remoteSshCommandExecution(gceInfo, options, runUtil, 120000L, "rm", "-rf", invocationWorkDir);
            if (!CommandStatus.SUCCESS.equals((Object)cr.getStatus())) {
                LogUtil.CLog.w("Clean up of %s failed.", invocationWorkDir);
                LogUtil.CLog.w("Command stdout: %s, stderr: %s", cr.getStdout(), cr.getStderr());
            }
            throw throwable;
        }
        FileUtil.recursiveDelete(configFile);
        FileUtil.recursiveDelete(globalConfig);
        cr = GceManager.remoteSshCommandExecution(gceInfo, options, runUtil, 120000L, "rm", "-rf", invocationWorkDir);
        if (!CommandStatus.SUCCESS.equals((Object)cr.getStatus())) {
            LogUtil.CLog.w("Clean up of %s failed.", invocationWorkDir);
            LogUtil.CLog.w("Command stdout: %s, stderr: %s", cr.getStdout(), cr.getStderr());
        }
    }

    @Override
    public void doSetup(TestInformation testInfo, IConfiguration config, ITestLogger logger) throws TargetSetupError, BuildError, DeviceNotAvailableException {
    }

    @Override
    public void doTeardown(TestInformation testInfo, IConfiguration config, ITestLogger logger, Throwable exception) throws Throwable {
        super.runDevicePostInvocationTearDown(testInfo.getContext(), config, exception);
    }

    @Override
    public void doCleanUp(IInvocationContext context, IConfiguration config, Throwable exception) {
    }

    @Override
    protected String getAdbVersion() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRemote(ITestInvocationListener currentInvocationListener, IInvocationContext context, File configFile, GceAvdInfo info, TestDeviceOptions options, IRunUtil runUtil, IConfiguration config, File globalConfig) throws InvalidProtocolBufferException, IOException {
        ArrayList<String> remoteTfCommand = new ArrayList<String>();
        remoteTfCommand.add("pushd");
        remoteTfCommand.add(this.mRemoteTradefedDir + ";");
        remoteTfCommand.add(String.format("PATH=%s:$PATH", new File(this.mRemoteAdbPath).getParent()));
        remoteTfCommand.add("screen -dmSU tradefed sh -c");
        StringBuilder tfCmdBuilder = new StringBuilder("TF_GLOBAL_CONFIG=" + globalConfig.getName());
        tfCmdBuilder.append(" REMOTE_VM_ENV=1");
        tfCmdBuilder.append(" DISABLE_CLEARCUT=1");
        tfCmdBuilder.append(" START_FEATURE_SERVER=1");
        tfCmdBuilder.append(" ENTRY_CLASS=" + CommandRunner.class.getCanonicalName());
        tfCmdBuilder.append(" ./tradefed.sh " + this.mRemoteTradefedDir + configFile.getName());
        if (config.getCommandOptions().shouldUseRemoteSandboxMode()) {
            tfCmdBuilder.append(" --use-sandbox");
        }
        tfCmdBuilder.append(" > screen-VM_tradefed-stdout.txt 2> screen-VM_tradefed-stderr.txt");
        remoteTfCommand.add("\"" + tfCmdBuilder.toString() + "\"");
        CommandResult resultRemoteExecution = GceManager.remoteSshCommandExecution(info, options, runUtil, 0L, remoteTfCommand.toArray(new String[0]));
        if (!CommandStatus.SUCCESS.equals((Object)resultRemoteExecution.getStatus())) {
            LogUtil.CLog.e("Error running the remote command: %s", resultRemoteExecution.getStdout());
            currentInvocationListener.invocationFailed(this.createInvocationFailure(resultRemoteExecution.getStderr(), TestRecordProto.FailureStatus.INFRA_FAILURE));
            return;
        }
        RunUtil.getDefault().sleep(10000L);
        this.mProtoParser = new ProtoResultParser(currentInvocationListener, context, false, "remote-");
        this.mProtoParser.setQuiet(false);
        this.mProtoParser.setSkipParsingAccounting(true);
        boolean stillRunning = true;
        try {
            stillRunning = this.isStillRunning(currentInvocationListener, configFile, info, options, runUtil, config);
        }
        finally {
            File stdout = this.fetchRemoteAndLogFile(currentInvocationListener, STDOUT_FILE, STDOUT_FILE, info, options, runUtil);
            FileUtil.recursiveDelete(stdout);
            File stderr = this.fetchRemoteAndLogFile(currentInvocationListener, STDERR_FILE, STDERR_FILE, info, options, runUtil);
            if (stderr != null && stderr.exists()) {
                this.mRemoteConsoleStdErr = FileUtil.readStringFromFile(stderr);
                FileUtil.recursiveDelete(stderr);
            } else {
                this.mRemoteConsoleStdErr = "Failed to fetch stderr from remote.";
            }
        }
        if (!config.getCommandOptions().shouldReportModuleProgression()) {
            this.fetchAndProcessResults(stillRunning, currentInvocationListener, info, options, runUtil, this.mRemoteTradefedDir);
        } else if (!this.mProtoParser.invocationEndedReached()) {
            File remoteSerialized;
            String message2 = String.format("Parsing of results protos might be incomplete: invocation ended of remote execution was not found. Remote Tradefed might have terminated early.\nRemote Stderr:\n%s", this.mRemoteConsoleStdErr);
            String exceptionRemoteFilePath = SubprocessExceptionParser.getPathFromStderr(this.mRemoteConsoleStdErr);
            FailureDescription failureDescription = this.createInvocationFailure(message2, TestRecordProto.FailureStatus.INFRA_FAILURE);
            if (exceptionRemoteFilePath != null && (remoteSerialized = RemoteFileUtil.fetchRemoteFile(info, options, runUtil, 180000L, exceptionRemoteFilePath)) != null) {
                try {
                    Throwable obj = (Throwable)SerializationUtil.deserialize(remoteSerialized, true);
                    failureDescription = this.createInvocationFailure(obj, TestRecordProto.FailureStatus.INFRA_FAILURE);
                }
                catch (IOException e) {
                    LogUtil.CLog.w("Could not parse the stderr as a particular exception.");
                }
            }
            currentInvocationListener.invocationFailed(failureDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStillRunning(ITestInvocationListener currentInvocationListener, File configFile, GceAvdInfo info, TestDeviceOptions options, IRunUtil runUtil, IConfiguration config) throws IOException {
        long maxTimeout = config.getCommandOptions().getInvocationTimeout();
        Long endTime = null;
        if (maxTimeout > 0L) {
            endTime = System.currentTimeMillis() + maxTimeout;
        }
        boolean stillRunning = true;
        int errorConnectCount = 0;
        int currentIndex = 0;
        long currentTimeOnProto = 0L;
        while (stillRunning) {
            CommandResult psRes;
            File resultFile;
            String remoteFilePath;
            if (config.getCommandOptions().shouldReportModuleProgression() && RemoteFileUtil.doesRemoteFileExist(info, options, runUtil, 180000L, remoteFilePath = this.mRemoteTradefedDir + PROTO_RESULT_NAME + currentIndex) && (resultFile = RemoteFileUtil.fetchRemoteFile(info, options, runUtil, 180000L, remoteFilePath)) != null) {
                ++currentIndex;
                currentTimeOnProto = System.currentTimeMillis();
                try {
                    this.mProtoParser.processFileProto(resultFile);
                    continue;
                }
                finally {
                    FileUtil.deleteFile(resultFile);
                    continue;
                }
            }
            if (System.currentTimeMillis() - currentTimeOnProto > 0x6DDD00L) {
                File stdout = this.fetchRemoteAndLogFile(currentInvocationListener, STDOUT_FILE, "screen-VM_tradefed-stdout.txt-early", info, options, runUtil);
                FileUtil.recursiveDelete(stdout);
                currentTimeOnProto = System.currentTimeMillis();
            }
            if (!CommandStatus.SUCCESS.equals((Object)(psRes = GceManager.remoteSshCommandExecution(info, options, runUtil, 120000L, "ps", "-ef", "| grep", CommandRunner.class.getCanonicalName())).getStatus())) {
                if (++errorConnectCount > 3) {
                    LogUtil.CLog.e("Failed to connect to the remote to check running status.");
                    return false;
                }
            } else {
                errorConnectCount = 0;
                LogUtil.CLog.d("ps -ef: stdout: %s\nstderr: %s\n", psRes.getStdout(), psRes.getStderr());
                stillRunning = psRes.getStdout().contains(configFile.getName());
                LogUtil.CLog.d("still running: %s", stillRunning);
                if (endTime != null && System.currentTimeMillis() > endTime) {
                    currentInvocationListener.invocationFailed(this.createInvocationFailure(String.format("Remote invocation timeout after %s", TimeUtil.formatElapsedTime(maxTimeout)), TestRecordProto.FailureStatus.TIMED_OUT));
                    break;
                }
            }
            if (!stillRunning) continue;
            RunUtil.getDefault().sleep(15000L);
        }
        File resultFile = null;
        if (config.getCommandOptions().shouldReportModuleProgression()) {
            String remoteFilePath;
            while (RemoteFileUtil.doesRemoteFileExist(info, options, runUtil, 180000L, remoteFilePath = this.mRemoteTradefedDir + PROTO_RESULT_NAME + currentIndex)) {
                resultFile = RemoteFileUtil.fetchRemoteFile(info, options, runUtil, 180000L, remoteFilePath);
                if (resultFile != null) {
                    ++currentIndex;
                    try {
                        this.mProtoParser.processFileProto(resultFile);
                    }
                    finally {
                        FileUtil.deleteFile(resultFile);
                    }
                }
                if (resultFile != null) continue;
            }
        }
        return stillRunning;
    }

    private String getRemoteMainDir(TestDeviceOptions options) {
        return REMOTE_USER_DIR.replace("{$USER}", options.getInstanceUser());
    }

    private void resetAdb(GceAvdInfo info, TestDeviceOptions options, IRunUtil runUtil) {
        CommandResult probAdb = GceManager.remoteSshCommandExecution(info, options, runUtil, 120000L, this.mRemoteAdbPath, "devices");
        LogUtil.CLog.d("remote adb prob: %s", probAdb.getStdout());
        LogUtil.CLog.d("%s", probAdb.getStderr());
        CommandResult versionAdb = GceManager.remoteSshCommandExecution(info, options, runUtil, 120000L, this.mRemoteAdbPath, "version");
        LogUtil.CLog.d("version adb: %s", versionAdb.getStdout());
        LogUtil.CLog.d("%s", versionAdb.getStderr());
    }

    private void collectAdbLogs(GceAvdInfo info, TestDeviceOptions options, IRunUtil runUtil, ITestLogger logger) {
        CommandResult tmpDirFolder = GceManager.remoteSshCommandExecution(info, options, runUtil, 120000L, "bash -c \"echo \\$TMPDIR\"");
        String folder = tmpDirFolder.getStdout().trim();
        LogUtil.CLog.d("Remote TMPDIR folder is: %s", folder);
        if (Strings.isNullOrEmpty(folder)) {
            folder = "/tmp";
        }
        CommandResult uid = GceManager.remoteSshCommandExecution(info, options, new RunUtil(), 120000L, "bash -c \"echo \\$UID\"");
        String uidString = uid.getStdout().trim();
        LogUtil.CLog.d("Remote $UID for adb is: %s", uidString);
        if (Strings.isNullOrEmpty(uidString)) {
            LogUtil.CLog.w("Could not determine adb log path.");
            return;
        }
        GceManager.logNestedRemoteFile(logger, info, options, runUtil, folder + "/adb." + uidString + ".log", LogDataType.TEXT, "full_adb.log");
    }

    File createRemoteConfig(IInvocationContext context, IConfiguration config, ITestLogger logger, String resultDirPath) throws IOException, ConfigurationException {
        ArrayList<ITestInvocationListener> reporters = new ArrayList<ITestInvocationListener>();
        FileProtoResultReporter protoReporter = new FileProtoResultReporter();
        OptionSetter protoResSetter = new OptionSetter(protoReporter);
        if (config.getCommandOptions().shouldReportModuleProgression()) {
            protoResSetter.setOptionValue("periodic-proto-writing", "true");
        }
        protoResSetter.setOptionValue("proto-output-file", new File(resultDirPath + PROTO_RESULT_NAME).getPath());
        reporters.add(protoReporter);
        config.setTestInvocationListeners(reporters);
        for (IDeviceConfiguration deviceConfig : config.getDeviceConfig()) {
            deviceConfig.getDeviceRequirements().setSerial(new String[0]);
            if (deviceConfig.getDeviceRequirements() instanceof DeviceSelectionOptions) {
                ((DeviceSelectionOptions)deviceConfig.getDeviceRequirements()).setDeviceTypeRequested(null);
                if (config.getCommandOptions().isRemoteInvocationDeviceless()) {
                    ((DeviceSelectionOptions)deviceConfig.getDeviceRequirements()).setDeviceTypeRequested(DeviceSelectionOptions.DeviceRequestedType.NULL_DEVICE);
                }
            }
            if (!config.getCommandOptions().isRemoteInvocationDeviceless()) continue;
            deviceConfig.getDeviceOptions().setInstanceType(TestDeviceOptions.InstanceType.GCE);
        }
        if (config.getCommandOptions().getShardCount() != null && config.getCommandOptions().getShardIndex() == null) {
            config.getCommandOptions().setReplicateSetup(true);
        }
        long invocationTimeout = Math.max(config.getCommandOptions().getInvocationTimeout() - 120000L, 0L);
        config.getCommandOptions().setInvocationTimeout(invocationTimeout);
        config.getCommandOptions().getInvocationData().put("subprocess", "true");
        for (String key : INVOCATION_CONTEXT_ATTR_TO_DATA) {
            String value;
            if (config.getCommandOptions().getInvocationData().containsKey(key) || Strings.isNullOrEmpty(value = context.getAttribute(key))) continue;
            config.getCommandOptions().getInvocationData().put(key, value);
        }
        if (GlobalConfiguration.getInstance().getFeatureServer() != null) {
            GlobalConfiguration.getInstance().getFeatureServer().unregisterInvocation(config);
        }
        config.getConfigurationDescription().removeMetadata("SERVER_REFERENCE");
        OptionSetter deviceOptions = new OptionSetter(config.getDeviceConfig().get(0).getDeviceOptions());
        deviceOptions.setOptionValue("remote-tf-version", "");
        File configFile = FileUtil.createTempFile(config.getName(), ".xml");
        config.dumpXml(new PrintWriter(configFile), new ArrayList<String>(), true, false);
        try (FileInputStreamSource source = new FileInputStreamSource(configFile);){
            logger.testLog(REMOTE_CONFIG, LogDataType.HARNESS_CONFIG, source);
        }
        return configFile;
    }

    private File getLocalTradefedPath(ITestInvocationListener listener, File remoteTf) {
        if (remoteTf != null && remoteTf.exists()) {
            return remoteTf;
        }
        String tfPath = System.getProperty("TF_JAR_DIR");
        if (tfPath == null) {
            listener.invocationFailed(this.createInvocationFailure("Failed to find $TF_JAR_DIR.", TestRecordProto.FailureStatus.INFRA_FAILURE));
            return null;
        }
        File currentTf = new File(tfPath).getAbsoluteFile();
        if (tfPath.equals(".")) {
            currentTf = new File("").getAbsoluteFile();
        }
        return currentTf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAndProcessResults(boolean wasStillRunning, ITestInvocationListener invocationListener, GceAvdInfo info, TestDeviceOptions options, IRunUtil runUtil, String resultDirPath) throws InvalidProtocolBufferException, IOException {
        File resultFile = null;
        if (wasStillRunning) {
            LogUtil.CLog.d("Remote invocation was still running. No result can be pulled.");
            return;
        }
        resultFile = RemoteFileUtil.fetchRemoteFile(info, options, runUtil, 180000L, resultDirPath + PROTO_RESULT_NAME);
        if (resultFile == null) {
            invocationListener.invocationFailed(this.createInvocationFailure(String.format("Could not find remote result file at %s. Remote Tradefed might have terminated early.\nRemote Stderr:\n%s", resultDirPath + PROTO_RESULT_NAME, this.mRemoteConsoleStdErr), TestRecordProto.FailureStatus.INFRA_FAILURE));
            return;
        }
        LogUtil.CLog.d("Fetched remote result file!");
        try {
            this.mProtoParser.processFinalizedProto(TestRecordProtoUtil.readFromFile(resultFile));
        }
        finally {
            FileUtil.deleteFile(resultFile);
        }
    }

    private File fetchRemoteAndLogFile(ITestLogger logger, String fileName, String logName, GceAvdInfo info, TestDeviceOptions options, IRunUtil runUtil) {
        File file2 = RemoteFileUtil.fetchRemoteFile(info, options, runUtil, 180000L, this.mRemoteTradefedDir + fileName);
        if (file2 != null) {
            try (FileInputStreamSource source = new FileInputStreamSource(file2, false);){
                logger.testLog(logName, LogDataType.HARNESS_STD_LOG, source);
            }
        }
        return file2;
    }

    private FailureDescription createInvocationFailure(String errorMessage, TestRecordProto.FailureStatus status) {
        FailureDescription failure = FailureDescription.create(errorMessage);
        failure.setFailureStatus(status);
        failure.setCause(new RuntimeException(errorMessage));
        return failure;
    }

    private FailureDescription createInvocationFailure(Throwable exception, TestRecordProto.FailureStatus defaultStatus) {
        String message2;
        ErrorIdentifier id = null;
        if (exception instanceof IHarnessException) {
            id = ((IHarnessException)((Object)exception)).getErrorId();
        }
        if ((message2 = exception.getMessage()) == null) {
            message2 = "No error message";
        }
        FailureDescription failure = CurrentInvocation.createFailure(message2, id).setCause(exception);
        if (id == null) {
            failure.setFailureStatus(defaultStatus);
        }
        return failure;
    }

    protected static class FileOptionValueTransformer
    implements IConfigOptionValueTransformer {
        private Map<String, String> mRenamedFiles = new HashMap<String, String>();
        private String mBaseRemoteDir;

        public FileOptionValueTransformer(String baseRemoteDir) {
            this.mBaseRemoteDir = baseRemoteDir;
        }

        public Map<String, String> getRenamedFiles() {
            return this.mRenamedFiles;
        }

        private boolean shouldTransformValueForOption(Option option) {
            return option.name().contains("key-file");
        }

        private File handleFileTypeValue(File file2) {
            String filePath = file2.toString();
            if (filePath.startsWith("/")) {
                String remoteName = this.mBaseRemoteDir + filePath.substring(1).replace('/', '_');
                this.mRenamedFiles.put(filePath, remoteName);
                LogUtil.CLog.v("File to be transferred: local=%s -> remote=%s", filePath, remoteName);
                return new File(remoteName);
            }
            return file2;
        }

        @Override
        public Object transform(Object configObj, Option option, Object fieldValue) {
            if (fieldValue instanceof File && this.shouldTransformValueForOption(option)) {
                return this.handleFileTypeValue((File)fieldValue);
            }
            return fieldValue;
        }
    }
}

