/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.ShardMainResultForwarder;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.retry.ISupportGranularResults;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShardListener
extends CollectingTestListener
implements ISupportGranularResults {
    private ITestInvocationListener mMainListener;
    private ShardMainResultForwarder mShardMainForwarder;
    private IInvocationContext mModuleContext = null;
    private int mAttemptInProgress = 0;
    private boolean mEnableGranularResults = false;
    private IInvocationContext mContext;

    public ShardListener(ITestInvocationListener main) {
        this.mMainListener = main;
        if (main instanceof ShardMainResultForwarder) {
            this.mShardMainForwarder = (ShardMainResultForwarder)main;
        }
    }

    public List<ITestInvocationListener> getUnderlyingResultReporter() {
        return this.mShardMainForwarder.getListeners();
    }

    @Override
    public boolean supportGranularResults() {
        return this.mEnableGranularResults;
    }

    public void setSupportGranularResults(boolean enableGranularResults) {
        this.mEnableGranularResults = enableGranularResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationStarted(IInvocationContext context) {
        this.mContext = context;
        super.invocationStarted(context);
        ITestInvocationListener iTestInvocationListener = this.mMainListener;
        synchronized (iTestInvocationListener) {
            this.mMainListener.invocationStarted(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationFailed(Throwable cause) {
        super.invocationFailed(cause);
        ITestInvocationListener iTestInvocationListener = this.mMainListener;
        synchronized (iTestInvocationListener) {
            this.mMainListener.invocationFailed(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationFailed(FailureDescription failure) {
        super.invocationFailed(failure);
        ITestInvocationListener iTestInvocationListener = this.mMainListener;
        synchronized (iTestInvocationListener) {
            this.mMainListener.invocationFailed(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        ITestInvocationListener iTestInvocationListener = this.mMainListener;
        synchronized (iTestInvocationListener) {
            if (this.mMainListener instanceof ShardMainResultForwarder) {
                ((ShardMainResultForwarder)this.mMainListener).testLogForward(dataName, dataType, dataStream);
            } else {
                this.mMainListener.testLog(dataName, dataType, dataStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        super.testLogSaved(dataName, dataType, dataStream, logFile);
        ITestInvocationListener iTestInvocationListener = this.mMainListener;
        synchronized (iTestInvocationListener) {
            if (this.mMainListener instanceof ILogSaverListener) {
                ((ILogSaverListener)this.mMainListener).testLogSaved(dataName, dataType, dataStream, logFile);
            }
        }
    }

    @Override
    public void testModuleStarted(IInvocationContext moduleContext) {
        super.testModuleStarted(moduleContext);
        this.mModuleContext = moduleContext;
    }

    @Override
    public void testRunStarted(String name, int numTests, int attemptNumber, long startTime) {
        super.testRunStarted(name, numTests, attemptNumber, startTime);
        this.mAttemptInProgress = attemptNumber;
    }

    @Override
    public void testRunFailed(String failureMessage) {
        super.testRunFailed(failureMessage);
        LogUtil.CLog.logAndDisplay(Log.LogLevel.ERROR, "FAILED: %s failed with message: %s", this.getCurrentRunResults().getName(), failureMessage);
    }

    @Override
    public void testRunFailed(FailureDescription failure) {
        super.testRunFailed(failure);
        LogUtil.CLog.logAndDisplay(Log.LogLevel.ERROR, "FAILED: %s failed with message: %s", this.getCurrentRunResults().getName(), failure.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        super.testRunEnded(elapsedTime, runMetrics);
        LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "Sharded test completed: %s", this.getCurrentRunResults().getName());
        if (this.mModuleContext == null) {
            ITestInvocationListener iTestInvocationListener = this.mMainListener;
            synchronized (iTestInvocationListener) {
                this.forwardRunResults(this.getCurrentRunResults(), this.mAttemptInProgress);
            }
            this.mAttemptInProgress = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testModuleEnded() {
        super.testModuleEnded();
        ITestInvocationListener iTestInvocationListener = this.mMainListener;
        synchronized (iTestInvocationListener) {
            this.mMainListener.testModuleStarted(this.mModuleContext);
            ArrayList<String> resultNames = new ArrayList<String>();
            if (this.mEnableGranularResults) {
                for (int i = 0; i < this.mAttemptInProgress + 1; ++i) {
                    List<TestRunResult> runResults = this.getTestRunForAttempts(i);
                    for (TestRunResult runResult : runResults) {
                        this.forwardRunResults(runResult, i);
                        resultNames.add(runResult.getName());
                    }
                }
            } else {
                for (TestRunResult runResult : this.getMergedTestRunResults()) {
                    this.forwardRunResults(runResult, 0);
                    this.clearResultsForName(runResult.getName());
                }
            }
            for (String name : resultNames) {
                this.clearResultsForName(name);
            }
            this.forwardLogAssociation(this.getModuleLogFiles(), this.mMainListener);
            this.clearModuleLogFiles();
            this.mMainListener.testModuleEnded();
        }
        this.mModuleContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationEnded(long elapsedTime) {
        super.invocationEnded(elapsedTime);
        ITestInvocationListener iTestInvocationListener = this.mMainListener;
        synchronized (iTestInvocationListener) {
            this.logShardContent(this.getMergedTestRunResults());
            this.forwardLogAssociation(this.getNonAssociatedLogFiles(), this.mMainListener);
            if (this.mShardMainForwarder != null) {
                this.mShardMainForwarder.invocationEnded(elapsedTime, this.mContext);
            } else {
                this.mMainListener.invocationEnded(elapsedTime);
            }
        }
    }

    @Override
    public void logAssociation(String dataName, LogFile logFile) {
        if (dataName.equals("invocation-trace")) {
            LogUtil.CLog.d("Received a trace for shard");
            this.mShardMainForwarder.logAssociation(dataName, logFile);
        } else {
            super.logAssociation(dataName, logFile);
        }
    }

    private void forwardRunResults(TestRunResult runResult, int attempt) {
        this.mMainListener.testRunStarted(runResult.getName(), runResult.getExpectedTestCount(), attempt, runResult.getStartTime());
        this.forwardTestResults(runResult.getTestResults());
        if (runResult.isRunFailure()) {
            this.mMainListener.testRunFailed(runResult.getRunFailureDescription());
        }
        this.forwardLogAssociation(runResult.getRunLoggedFiles(), this.mMainListener);
        this.mMainListener.testRunEnded(runResult.getElapsedTime(), runResult.getRunProtoMetrics());
    }

    private void forwardTestResults(Map<TestDescription, TestResult> testResults) {
        for (Map.Entry<TestDescription, TestResult> testEntry : testResults.entrySet()) {
            this.mMainListener.testStarted(testEntry.getKey(), testEntry.getValue().getStartTime());
            switch (testEntry.getValue().getStatus()) {
                case FAILURE: {
                    this.mMainListener.testFailed(testEntry.getKey(), testEntry.getValue().getFailure());
                    break;
                }
                case ASSUMPTION_FAILURE: {
                    this.mMainListener.testAssumptionFailure(testEntry.getKey(), testEntry.getValue().getFailure());
                    break;
                }
                case IGNORED: {
                    this.mMainListener.testIgnored(testEntry.getKey());
                    break;
                }
            }
            this.forwardLogAssociation(testEntry.getValue().getLoggedFiles(), this.mMainListener);
            if (testEntry.getValue().getStatus().equals((Object)TestResult.TestStatus.INCOMPLETE)) continue;
            this.mMainListener.testEnded(testEntry.getKey(), testEntry.getValue().getEndTime(), testEntry.getValue().getProtoMetrics());
        }
    }

    private void forwardLogAssociation(MultiMap<String, LogFile> loggedFiles, ITestInvocationListener listener) {
        for (String key : loggedFiles.keySet()) {
            for (LogFile logFile : loggedFiles.get(key)) {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).logAssociation(key, logFile);
            }
        }
    }

    private void forwardLogAssociation(Map<String, LogFile> loggedFiles, ITestInvocationListener listener) {
        for (Map.Entry<String, LogFile> logFile : loggedFiles.entrySet()) {
            if (!(listener instanceof ILogSaverListener)) continue;
            ((ILogSaverListener)listener).logAssociation(logFile.getKey(), logFile.getValue());
        }
    }

    private void logShardContent(Collection<TestRunResult> listResults) {
        StringBuilder sb = new StringBuilder();
        sb.append("=================================================\n");
        sb.append(String.format("========== Shard Primary Device %s ==========\n", this.getInvocationContext().getDevices().get(0).getSerialNumber()));
        for (TestRunResult runRes : listResults) {
            sb.append(String.format("\tRan '%s' in %s\n", runRes.getName(), TimeUtil.formatElapsedTime(runRes.getElapsedTime())));
        }
        sb.append("=================================================\n");
        LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, sb.toString());
    }
}

